/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ArrayIndexReplacementConstructor;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ElimStorePlain;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DerPreprocessor
extends TermTransformer {
    private static final String AUX_VAR_PREFIX = "DerPreprocessor";
    private final List<TermVariable> mNewAuxVars;
    private final Term mResult;
    private final boolean mIntroducedDerPossibility;

    public DerPreprocessor(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, int n, TermVariable termVariable, Term term, List<BinaryEqualityRelation> list, ArrayIndexEqualityManager arrayIndexEqualityManager) throws ElimStorePlain.ElimStorePlainException {
        Term term2;
        Object object3;
        HashRelation<DerCase, BinaryEqualityRelation> hashRelation = DerPreprocessor.classify(managedScript.getScript(), list, termVariable);
        boolean bl = false;
        Object object2 = null;
        DerCase derCase = null;
        Set set = Arrays.stream(QuantifierUtils.getDualFiniteJuncts(n, term)).collect(Collectors.toSet());
        Map<Term, Term> map = hashRelation.getImage((Object)DerCase.CLASSICAL_DER).iterator();
        if (map.hasNext()) {
            BinaryEqualityRelation binaryEqualityRelation = (BinaryEqualityRelation)map.next();
            if (set.contains(binaryEqualityRelation.toTerm(managedScript.getScript()))) {
                throw new AssertionError((Object)"Should have been eliminated by DER");
            }
            throw new ElimStorePlain.ElimStorePlainException("DER that is not on top-level");
        }
        for (Object object3 : hashRelation.getImage((Object)DerCase.EQ_SELECT)) {
            if (set.contains(((BinaryRelation)object3).toTerm(managedScript.getScript()))) {
                if (object2 != null) continue;
                object2 = object3;
                derCase = DerCase.EQ_SELECT;
                continue;
            }
            bl = true;
        }
        for (Object object3 : hashRelation.getImage((Object)DerCase.EQ_STORE)) {
            term2 = ((BinaryRelation)object3).toTerm(managedScript.getScript());
            if (set.contains(term2)) {
                if (object2 != null) continue;
                object2 = object3;
                derCase = DerCase.EQ_STORE;
                continue;
            }
            bl = true;
        }
        object3 = new ArrayIndexReplacementConstructor(managedScript, AUX_VAR_PREFIX, termVariable);
        if (object2 != null) {
            term2 = DerPreprocessor.constructDerEnabler((BinaryEqualityRelation)object2, managedScript, termVariable, n, derCase, (ArrayIndexReplacementConstructor)object3, arrayIndexEqualityManager);
            map = Collections.singletonMap(((BinaryRelation)object2).toTerm(managedScript.getScript()), term2);
            this.mIntroducedDerPossibility = true;
        } else {
            if (bl) {
                throw new AssertionError((Object)"Some non-self update cases but no top-level DER relation");
            }
            map = DerPreprocessor.handleAllSelfUpdates(hashRelation.getImage((Object)DerCase.SELF_UPDATE), managedScript, termVariable, n, (ArrayIndexReplacementConstructor)object3, arrayIndexEqualityManager);
            this.mIntroducedDerPossibility = false;
        }
        term2 = Substitution.apply(managedScript, map, term);
        Term term3 = ((ArrayIndexReplacementConstructor)object3).constructDefinitions(managedScript.getScript(), n);
        this.mNewAuxVars = new ArrayList<TermVariable>(((ArrayIndexReplacementConstructor)object3).getConstructedAuxVars());
        this.mResult = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), n, term2, term3);
    }

    private static Map<Term, Term> handleAllSelfUpdates(Set<BinaryEqualityRelation> set, ManagedScript managedScript, TermVariable termVariable, int n, ArrayIndexReplacementConstructor arrayIndexReplacementConstructor, ArrayIndexEqualityManager arrayIndexEqualityManager) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (BinaryEqualityRelation binaryEqualityRelation : set) {
            Term term = DerPreprocessor.getOtherSide(binaryEqualityRelation, termVariable);
            MultiDimensionalNestedStore multiDimensionalNestedStore = MultiDimensionalNestedStore.of(term);
            Term term2 = DerPreprocessor.constructReplacementForStoreCase(multiDimensionalNestedStore, managedScript, termVariable, n, arrayIndexReplacementConstructor, arrayIndexEqualityManager);
            hashMap.put(binaryEqualityRelation.toTerm(managedScript.getScript()), term2);
        }
        return hashMap;
    }

    private static Term constructDerEnabler(BinaryEqualityRelation binaryEqualityRelation, ManagedScript managedScript, TermVariable termVariable, int n, DerCase derCase, ArrayIndexReplacementConstructor arrayIndexReplacementConstructor, ArrayIndexEqualityManager arrayIndexEqualityManager) {
        Term term = DerPreprocessor.getOtherSide(binaryEqualityRelation, termVariable);
        return switch (derCase) {
            case DerCase.EQ_SELECT -> {
                MultiDimensionalSelect var9_8 = MultiDimensionalSelect.of(term);
                yield DerPreprocessor.constructReplacementForSelectCase(var9_8.getArray(), var9_8.getIndex(), managedScript, termVariable, n, arrayIndexReplacementConstructor);
            }
            case DerCase.EQ_STORE -> {
                MultiDimensionalNestedStore var10_10 = MultiDimensionalNestedStore.of(term);
                yield DerPreprocessor.constructReplacementForStoreCase(var10_10, managedScript, termVariable, n, arrayIndexReplacementConstructor, arrayIndexEqualityManager);
            }
            default -> throw new AssertionError((Object)"only select case and store case possible");
        };
    }

    private static HashRelation<DerCase, BinaryEqualityRelation> classify(Script script, List<BinaryEqualityRelation> list, TermVariable termVariable) throws ElimStorePlain.ElimStorePlainException {
        HashRelation hashRelation = new HashRelation();
        for (BinaryEqualityRelation binaryEqualityRelation : list) {
            Term term = DerPreprocessor.getOtherSide(binaryEqualityRelation, termVariable);
            DerCase derCase = DerPreprocessor.classify(script, term, termVariable);
            hashRelation.addPair((Object)derCase, (Object)binaryEqualityRelation);
        }
        return hashRelation;
    }

    private static Term getOtherSide(BinaryEqualityRelation binaryEqualityRelation, TermVariable termVariable) {
        Term term;
        if (binaryEqualityRelation.getLhs().equals(termVariable)) {
            term = binaryEqualityRelation.getRhs();
        } else if (binaryEqualityRelation.getRhs().equals(termVariable)) {
            term = binaryEqualityRelation.getLhs();
        } else {
            throw new AssertionError((Object)"has to be on one side");
        }
        return term;
    }

    private static DerCase classify(Script script, Term term, TermVariable termVariable) throws ElimStorePlain.ElimStorePlainException {
        if (!Arrays.asList(term.getFreeVars()).contains(termVariable)) {
            return DerCase.CLASSICAL_DER;
        }
        MultiDimensionalNestedStore multiDimensionalNestedStore = MultiDimensionalNestedStore.of(term);
        if (multiDimensionalNestedStore != null) {
            if (multiDimensionalNestedStore.getArray() == termVariable) {
                return DerCase.SELF_UPDATE;
            }
            if (Arrays.asList(multiDimensionalNestedStore.getArray().getFreeVars()).contains(termVariable)) {
                throw new AssertionError((Object)("Complicated and unsupported kind of self-update: " + String.valueOf(multiDimensionalNestedStore.getArray())));
            }
            return DerCase.EQ_STORE;
        }
        MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of(term);
        if (multiDimensionalSelect.getIndex().size() > 0) {
            return DerCase.EQ_SELECT;
        }
        throw new UnsupportedOperationException("DerPreprocessor supports only store and select, but not " + String.valueOf(term));
    }

    public List<TermVariable> getNewAuxVars() {
        return this.mNewAuxVars;
    }

    public Term getResult() {
        return this.mResult;
    }

    public boolean introducedDerPossibility() {
        return this.mIntroducedDerPossibility;
    }

    private static Term constructReplacementForStoreCase(MultiDimensionalNestedStore multiDimensionalNestedStore, ManagedScript managedScript, TermVariable termVariable, int n, ArrayIndexReplacementConstructor arrayIndexReplacementConstructor, ArrayIndexEqualityManager arrayIndexEqualityManager) {
        Object object;
        Term term22;
        LinkedList<ArrayIndex> linkedList;
        ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>();
        for (ArrayIndex list2 : multiDimensionalNestedStore.getIndices()) {
            linkedList = arrayIndexReplacementConstructor.constructIndexReplacementIfNeeded(list2);
            arrayList.add((ArrayIndex)((Object)linkedList));
        }
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (Term term22 : multiDimensionalNestedStore.getValues()) {
            object = arrayIndexReplacementConstructor.constructTermReplacementIfNeeded(term22);
            arrayList2.add((Term)object);
        }
        if (multiDimensionalNestedStore.getArray().equals(termVariable)) {
            linkedList = new LinkedList<ArrayIndex>(arrayList);
            object = new LinkedList(arrayList2);
            Term[] termArray = new Term[linkedList.size()];
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ArrayIndex arrayIndex = (ArrayIndex)linkedList.removeFirst();
                Term term = (Term)((LinkedList)object).removeFirst();
                termArray[n2] = DerPreprocessor.constructDisjointIndexImplication(arrayIndex, linkedList, term, (Term)termVariable, managedScript.getScript(), n, arrayIndexEqualityManager);
                ++n2;
            }
            assert (linkedList.isEmpty());
            assert (((AbstractCollection)object).isEmpty());
            term22 = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), n, termArray);
        } else {
            if (Arrays.asList(multiDimensionalNestedStore.getArray().getFreeVars()).contains(termVariable)) {
                throw new UnsupportedOperationException("We have to descend beyond store chains. Introduce auxiliary variables only for arrays of lower dimension to avoid non-termination.");
            }
            term22 = QuantifierUtils.applyDerOperator(managedScript.getScript(), n, new MultiDimensionalNestedStore(multiDimensionalNestedStore.getArray(), arrayList, arrayList2).toTerm(managedScript.getScript()), (Term)termVariable);
        }
        return term22;
    }

    private static List<Term> constructReplacementsIfNeeded(List<Term> list, ConstructionCache<Term, TermVariable> constructionCache, TermVariable termVariable) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        boolean bl = false;
        for (Term term : list) {
            Term term2;
            if (Arrays.asList(term.getFreeVars()).contains(termVariable)) {
                term2 = (Term)constructionCache.getOrConstruct((Object)term);
                bl = true;
            } else {
                term2 = term;
            }
            arrayList.add(term2);
        }
        if (bl) {
            return arrayList;
        }
        return list;
    }

    private static Term constructReplacementForSelectCase(Term term, ArrayIndex arrayIndex, ManagedScript managedScript, TermVariable termVariable, int n, ArrayIndexReplacementConstructor arrayIndexReplacementConstructor) {
        ArrayIndex arrayIndex2 = arrayIndexReplacementConstructor.constructIndexReplacementIfNeeded(arrayIndex);
        if (arrayIndex2 == arrayIndex) {
            throw new AssertionError((Object)"no need to replace index");
        }
        MultiDimensionalSelect multiDimensionalSelect = new MultiDimensionalSelect(term, arrayIndex2);
        Term term2 = QuantifierUtils.applyDerOperator(managedScript.getScript(), n, (Term)termVariable, multiDimensionalSelect.toTerm(managedScript.getScript()));
        return term2;
    }

    private static Term constructDisjointIndexImplication(ArrayIndex arrayIndex, LinkedList<ArrayIndex> linkedList, Term term, Term term2, Script script, int n, ArrayIndexEqualityManager arrayIndexEqualityManager) {
        Term term3 = new MultiDimensionalSelect(term2, arrayIndex).toTerm(script);
        ArrayList<Term> arrayList = new ArrayList<Term>(linkedList.stream().map(arrayIndex2 -> arrayIndexEqualityManager.constructDerRelation(script, n, arrayIndex, (ArrayIndex)arrayIndex2)).collect(Collectors.toList()));
        Term term4 = QuantifierUtils.applyDerOperator(script, n, term3, term);
        arrayList.add(term4);
        Term term5 = QuantifierUtils.applyCorrespondingFiniteConnective(script, n, arrayList);
        return term5;
    }

    private static enum DerCase {
        SELF_UPDATE,
        EQ_STORE,
        EQ_SELECT,
        CLASSICAL_DER;

    }
}

