/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.OctagonRelation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;

public class OctagonMatrix {
    public static final BiPredicate<Rational, Rational> sRelationEqual = (rational, rational2) -> rational.compareTo(rational2) == 0;
    public static final BiPredicate<Rational, Rational> sRelationLessThanOrEqual = (rational, rational2) -> rational.compareTo(rational2) <= 0;
    public static final OctagonMatrix NEW = new OctagonMatrix(0);
    private static final Consumer<OctagonMatrix> sDefaultShortestPathClosure = OctagonMatrix::shortestPathClosurePrimitiveSparse;
    private final int mSize;
    private final Rational[] mEntries;
    private OctagonMatrix mStrongClosure;
    private OctagonMatrix mTightClosure;

    private OctagonMatrix copy() {
        OctagonMatrix octagonMatrix = new OctagonMatrix(this.variables());
        System.arraycopy(this.mEntries, 0, octagonMatrix.mEntries, 0, this.mEntries.length);
        octagonMatrix.mStrongClosure = this.mStrongClosure == this ? octagonMatrix : this.mStrongClosure;
        octagonMatrix.mTightClosure = this.mTightClosure == this ? octagonMatrix : this.mTightClosure;
        return octagonMatrix;
    }

    public OctagonMatrix(int n) {
        this.mSize = n * 2;
        this.mEntries = new Rational[OctagonMatrix.entriesInBlockLowerTriangular(n)];
        this.fill(Rational.POSITIVE_INFINITY);
    }

    private static int entriesInBlockLowerTriangular(int n) {
        return 2 * (n * n + n);
    }

    private void fill(Rational rational) {
        int n = 0;
        while (n < this.mEntries.length) {
            this.mEntries[n] = rational;
            ++n;
        }
        this.mTightClosure = null;
        this.mStrongClosure = null;
    }

    public int getSize() {
        return this.mSize;
    }

    public int variables() {
        return this.mSize / 2;
    }

    private Rational get(int n, int n2) {
        return this.mEntries[this.indexOf(n, n2)];
    }

    private void set(int n, int n2, Rational rational) {
        assert (rational != null) : "null is not a valid matrix entry.";
        this.mTightClosure = null;
        this.mStrongClosure = null;
        this.mEntries[this.indexOf((int)n, (int)n2)] = rational;
    }

    private void setMin(int n, int n2, Rational rational) {
        assert (rational != null) : "null is not a valid matrix entry.";
        int n3 = this.indexOf(n, n2);
        if (rational.compareTo(this.mEntries[n3]) < 0) {
            this.mEntries[n3] = rational;
            this.mTightClosure = null;
            this.mStrongClosure = null;
        }
    }

    public void processRelation(OctagonRelation octagonRelation, Map<Term, Integer> map) {
        boolean bl;
        boolean bl2;
        Rational rational;
        Rational rational2 = octagonRelation.getConstant();
        switch (octagonRelation.getRelationSymbol()) {
            case LEQ: {
                rational = octagonRelation.getConstant();
                bl2 = octagonRelation.isNegateVar1();
                bl = octagonRelation.isNegateVar2();
                break;
            }
            case GEQ: {
                rational = octagonRelation.getConstant().negate();
                bl2 = !octagonRelation.isNegateVar1();
                bl = !octagonRelation.isNegateVar2();
                break;
            }
            case LESS: {
                rational = SmtSortUtils.isRealSort((Sort)octagonRelation.getVar1().getSort()) ? rational2 : rational2.sub(Rational.ONE);
                bl2 = octagonRelation.isNegateVar1();
                bl = octagonRelation.isNegateVar2();
                break;
            }
            case GREATER: {
                rational = SmtSortUtils.isRealSort((Sort)octagonRelation.getVar1().getSort()) ? rational2.negate() : rational2.negate().sub(Rational.ONE);
                bl2 = !octagonRelation.isNegateVar1();
                bl = !octagonRelation.isNegateVar2();
                break;
            }
            default: {
                return;
            }
        }
        int n = 2 * map.get(octagonRelation.getVar1());
        int n2 = 2 * map.get(octagonRelation.getVar2());
        if (!bl2) {
            n |= 1;
        }
        if (!bl) {
            n2 |= 1;
        }
        this.setMin(n, n2, rational);
    }

    private boolean minimizeDiagonal() {
        int n = 0;
        while (n < this.mSize) {
            if (this.minimizeDiagonalEntry(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean minimizeDiagonalEntry(int n) {
        int n2 = OctagonMatrix.indexOfLower(n, n);
        int n3 = this.mEntries[n2].signum();
        if (n3 > 0) {
            this.mEntries[n2] = Rational.ZERO;
            return false;
        }
        return n3 < 0;
    }

    private int indexOf(int n, int n2) {
        assert (n < this.mSize && n2 < this.mSize) : n + "," + n2 + " is not an index for matrix of size " + this.mSize + ".";
        if (n < n2) {
            return OctagonMatrix.indexOfLower(n2 ^ 1, n ^ 1);
        }
        return OctagonMatrix.indexOfLower(n, n2);
    }

    private static int indexOfLower(int n, int n2) {
        return n2 + (n + 1) * (n + 1) / 2;
    }

    private OctagonMatrix elementwiseOperation(OctagonMatrix octagonMatrix, BinaryOperator<Rational> binaryOperator) {
        this.checkCompatibility(octagonMatrix);
        OctagonMatrix octagonMatrix2 = new OctagonMatrix(this.variables());
        int n = 0;
        while (n < this.mEntries.length) {
            octagonMatrix2.mEntries[n] = (Rational)binaryOperator.apply(this.mEntries[n], octagonMatrix.mEntries[n]);
            ++n;
        }
        return octagonMatrix2;
    }

    private boolean elementwiseRelation(OctagonMatrix octagonMatrix, BiPredicate<Rational, Rational> biPredicate) {
        this.checkCompatibility(octagonMatrix);
        int n = 0;
        while (n < this.mEntries.length) {
            if (!biPredicate.test(this.mEntries[n], octagonMatrix.mEntries[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean elementwiseRelation(OctagonMatrix octagonMatrix, BiPredicate<Rational, Rational> biPredicate, int[] nArray) {
        if (nArray == null) {
            return this.elementwiseRelation(octagonMatrix, biPredicate);
        }
        this.checkCompatibility(octagonMatrix);
        int n = 0;
        while (n < this.variables()) {
            int n2 = 0;
            while (n2 <= n) {
                int n3 = nArray[n];
                int n4 = nArray[n2];
                if (!this.blockwiseRelation(n, n2, octagonMatrix, n3, n4, biPredicate)) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    private boolean blockwiseRelation(int n, int n2, OctagonMatrix octagonMatrix, int n3, int n4, BiPredicate<Rational, Rational> biPredicate) {
        n *= 2;
        n2 *= 2;
        n3 *= 2;
        n4 *= 2;
        int n5 = 0;
        while (n5 < 2) {
            int n6 = 0;
            while (n6 < 2) {
                if (!biPredicate.test(this.get(n + n6, n2 + n5), octagonMatrix.get(n3 + n6, n4 + n5))) {
                    return false;
                }
                ++n6;
            }
            ++n5;
        }
        return true;
    }

    private void checkCompatibility(OctagonMatrix octagonMatrix) {
        if (octagonMatrix.mSize != this.mSize) {
            throw new IllegalArgumentException("Incompatible matrices");
        }
    }

    public OctagonMatrix rearrange(int[] nArray) {
        int n;
        int n2;
        OctagonMatrix octagonMatrix = new OctagonMatrix(nArray.length);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            n2 = nArray[n5];
            n = n2 < 0 ? 1 : 0;
            hashMap.put(n5, n != 0 ? null : Integer.valueOf(n2));
            if (n5 == n2 && n3 == n5) {
                ++n3;
            }
            n4 = n != 0 ? ++n4 : 0;
            ++n5;
        }
        n5 = octagonMatrix.variables() - n4;
        n2 = OctagonMatrix.entriesInBlockLowerTriangular(n3);
        System.arraycopy(this.mEntries, 0, octagonMatrix.mEntries, 0, n2);
        octagonMatrix.copySelection(this, hashMap, n3, n5);
        n = OctagonMatrix.entriesInBlockLowerTriangular(n5);
        Arrays.fill(octagonMatrix.mEntries, n, octagonMatrix.mEntries.length, Rational.POSITIVE_INFINITY);
        return octagonMatrix;
    }

    private static Rational min(Rational rational, Rational rational2) {
        return rational.compareTo(rational2) < 0 ? rational : rational2;
    }

    private static Rational max(Rational rational, Rational rational2) {
        return rational.compareTo(rational2) > 0 ? rational : rational2;
    }

    public static OctagonMatrix min(OctagonMatrix octagonMatrix, OctagonMatrix octagonMatrix2) {
        return octagonMatrix.elementwiseOperation(octagonMatrix2, OctagonMatrix::min);
    }

    public static OctagonMatrix max(OctagonMatrix octagonMatrix, OctagonMatrix octagonMatrix2) {
        OctagonMatrix octagonMatrix3 = octagonMatrix.elementwiseOperation(octagonMatrix2, OctagonMatrix::max);
        if (octagonMatrix.mStrongClosure != null && octagonMatrix2.mStrongClosure != null) {
            octagonMatrix3.mStrongClosure = octagonMatrix3;
        }
        if (octagonMatrix.mTightClosure != null && octagonMatrix2.mTightClosure != null) {
            octagonMatrix3.mTightClosure = octagonMatrix3;
        }
        return octagonMatrix3;
    }

    public boolean isEqualTo(OctagonMatrix octagonMatrix) {
        if (this == octagonMatrix) {
            return true;
        }
        return this.elementwiseRelation(octagonMatrix, sRelationEqual);
    }

    public boolean isEqualTo(OctagonMatrix octagonMatrix, int[] nArray) {
        return this.elementwiseRelation(octagonMatrix, sRelationEqual, nArray);
    }

    public OctagonMatrix cachedStrongClosure() {
        if (this.mStrongClosure != null) {
            return this.mStrongClosure;
        }
        return this.strongClosure(sDefaultShortestPathClosure);
    }

    public boolean hasCachedStrongClosure() {
        return this.mStrongClosure != null;
    }

    private OctagonMatrix strongClosure(Consumer<OctagonMatrix> consumer) {
        OctagonMatrix octagonMatrix = this.copy();
        boolean bl = octagonMatrix.minimizeDiagonal();
        if (!bl) {
            consumer.accept(octagonMatrix);
            octagonMatrix.strengtheningInPlace();
        }
        octagonMatrix.mStrongClosure = this.mStrongClosure = octagonMatrix;
        octagonMatrix.mTightClosure = this.mTightClosure;
        return octagonMatrix;
    }

    public OctagonMatrix cachedTightClosure() {
        if (this.mTightClosure != null) {
            return this.mTightClosure;
        }
        return this.tightClosure(sDefaultShortestPathClosure);
    }

    public boolean hasCachedTightClosure() {
        return this.mTightClosure != null;
    }

    private OctagonMatrix tightClosure(Consumer<OctagonMatrix> consumer) {
        OctagonMatrix octagonMatrix = this.copy();
        if (!octagonMatrix.minimizeDiagonal()) {
            consumer.accept(octagonMatrix);
            octagonMatrix.tighteningInPlace();
        }
        octagonMatrix.mStrongClosure = this.mStrongClosure;
        octagonMatrix.mTightClosure = this.mTightClosure = octagonMatrix;
        return octagonMatrix;
    }

    public void shortestPathClosurePrimitiveSparse() {
        int[] nArray = null;
        int[] nArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.mSize) {
            int n3 = n2 ^ 1;
            if (n2 < n3) {
                nArray = new int[this.mSize];
                nArray2 = new int[this.mSize];
                n = this.primitiveIndexFiniteEntriesInBlockRowAndColumn(n2, nArray, nArray2);
            }
            int n4 = 0;
            while (n4 < n) {
                int n5 = nArray2[n4];
                Rational rational = this.get(n5, n2);
                Rational rational2 = this.get(n5, n3);
                int n6 = n5 | 1;
                int n7 = 0;
                while (n7 < n) {
                    int n8 = nArray[n7];
                    if (n8 > n6) break;
                    Rational rational3 = this.get(n2, n8);
                    Rational rational4 = this.get(n3, n8);
                    Rational rational5 = OctagonMatrix.min(rational.add(rational3), rational2.add(rational4));
                    if (this.get(n5, n8).compareTo(rational5) > 0) {
                        this.set(n5, n8, rational5);
                    }
                    ++n7;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private int primitiveIndexFiniteEntriesInBlockRowAndColumn(int n, int[] nArray, int[] nArray2) {
        int n2 = 0;
        int n3 = n ^ 1;
        int n4 = 0;
        while (n4 < this.mSize) {
            if (!this.get(n4, n).equals((Object)Rational.POSITIVE_INFINITY) || !this.get(n4, n3).equals((Object)Rational.POSITIVE_INFINITY)) {
                nArray2[n2] = n4;
                nArray[n2] = n4 ^ 1;
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    private void strengtheningInPlace() {
        int n = 2;
        while (n < this.mSize) {
            Rational rational = this.get(n, n ^ 1).div(Rational.TWO);
            int n2 = n - 2 | 1;
            int n3 = 0;
            while (n3 <= n2) {
                Rational rational2 = this.get(n3 ^ 1, n3).div(Rational.TWO);
                Rational rational3 = rational.add(rational2);
                if (this.get(n, n3).compareTo(rational3) > 0) {
                    this.set(n, n3, rational3);
                }
                ++n3;
            }
            ++n;
        }
    }

    private void tighteningInPlace() {
        int n = 0;
        while (n < this.mSize) {
            Rational rational = this.get(n, n ^ 1).div(Rational.TWO).floor();
            int n2 = n | 1;
            int n3 = 0;
            while (n3 <= n2) {
                Rational rational2 = this.get(n3 ^ 1, n3).div(Rational.TWO).floor();
                Rational rational3 = rational.add(rational2);
                if (this.get(n, n3).compareTo(rational3) > 0) {
                    this.set(n, n3, rational3);
                }
                ++n3;
            }
            ++n;
        }
    }

    public boolean hasNegativeSelfLoop() {
        int n = 0;
        while (n < this.mSize) {
            if (this.get(n, n).signum() < 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public OctagonMatrix widenSimple(OctagonMatrix octagonMatrix) {
        return this.elementwiseOperation(octagonMatrix, (rational, rational2) -> rational.compareTo(rational2) >= 0 ? rational : Rational.POSITIVE_INFINITY);
    }

    public OctagonMatrix widenExponential(OctagonMatrix octagonMatrix, Rational rational) {
        Rational rational2 = Rational.ONE;
        Rational rational3 = rational2.add(rational2).negate();
        Rational rational4 = rational2.div(Rational.TWO);
        return this.elementwiseOperation(octagonMatrix, (rational5, rational6) -> {
            if (rational5.compareTo(rational6) >= 0) {
                return rational5;
            }
            if (rational6.compareTo(rational) > 0) {
                return Rational.POSITIVE_INFINITY;
            }
            Rational rational7 = rational6.compareTo(rational3) <= 0 ? rational6.div(Rational.TWO) : (rational6.signum() <= 0 ? Rational.ZERO : (rational6.compareTo(rational4) <= 0 ? rational2 : rational6.add(rational6)));
            return OctagonMatrix.min(rational7, rational);
        });
    }

    public OctagonMatrix widenStepwise(OctagonMatrix octagonMatrix, WideningStepSupplier wideningStepSupplier) {
        return this.elementwiseOperation(octagonMatrix, (rational, rational2) -> {
            if (rational.compareTo(rational2) >= 0) {
                return rational;
            }
            return wideningStepSupplier.nextWideningStep((Rational)rational2);
        });
    }

    public void copySelection(OctagonMatrix octagonMatrix, Map<Integer, Integer> map, int n, int n2) {
        n = Math.min(0, n);
        n2 = Math.min(this.variables(), n2);
        assert (!this.containsTautology(octagonMatrix, map, n, n2)) : "Overwrite in place with same target and source is not necessary and may cause problems.";
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            int n3 = entry.getKey();
            if (n3 < n || n2 <= n3) continue;
            Integer n4 = entry.getValue();
            int n5 = n;
            while (n5 < n2) {
                if (n5 >= n3 || !map.containsKey(n5)) {
                    Integer n6 = map.get(n5);
                    if (n6 == null || n4 == null) {
                        this.setBlock(n5, n3, Rational.POSITIVE_INFINITY);
                    } else {
                        this.copyBlock(n5, n3, octagonMatrix, n6, n4);
                    }
                }
                ++n5;
            }
        }
    }

    private boolean containsTautology(OctagonMatrix octagonMatrix, Map<Integer, Integer> map, int n, int n2) {
        return octagonMatrix.mEntries == this.mEntries && map.entrySet().stream().anyMatch(entry -> n <= (Integer)entry.getKey() && (Integer)entry.getKey() < n2 && ((Integer)entry.getKey()).equals(entry.getValue()));
    }

    private void copyBlock(int n, int n2, OctagonMatrix octagonMatrix, int n3, int n4) {
        n *= 2;
        n2 *= 2;
        n3 *= 2;
        n4 *= 2;
        int n5 = 0;
        while (n5 < 2) {
            int n6 = 0;
            while (n6 < 2) {
                this.set(n + n6, n2 + n5, octagonMatrix.get(n3 + n6, n4 + n5));
                ++n6;
            }
            ++n5;
        }
    }

    private void setBlock(int n, int n2, Rational rational) {
        n *= 2;
        n2 *= 2;
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 2) {
                this.set(n + n4, n2 + n3, rational);
                ++n4;
            }
            ++n3;
        }
    }

    public Term getTerm(Script script, Term[] termArray) {
        HashSet<Term> hashSet = new HashSet<Term>();
        int n = 0;
        while (n < 2 * this.variables()) {
            Term term = OctagonMatrix.selectVar(script, n, termArray);
            int n2 = 0;
            while (n2 < (n / 2 + 1) * 2) {
                Rational rational = this.get(n, n2);
                if (n2 == n) {
                    if (rational.signum() < 0) {
                        return script.term("false", new Term[0]);
                    }
                } else if (!rational.equals((Object)Rational.POSITIVE_INFINITY)) {
                    Term term2 = OctagonMatrix.selectVar(script, n2, termArray);
                    Rational rational2 = this.get(OctagonMatrix.getDualIndex(n), OctagonMatrix.getDualIndex(n2));
                    hashSet.add(OctagonMatrix.createBoundedDiffTerm(script, term2, term, rational, rational.negate().equals((Object)rational2)));
                }
                ++n2;
            }
            ++n;
        }
        return SmtUtils.and((Script)script, hashSet);
    }

    private static int getDualIndex(int n) {
        return n % 2 == 0 ? n + 1 : n - 1;
    }

    private static Term selectVar(Script script, int n, Term[] termArray) {
        Term term = termArray[n / 2];
        if (n % 2 == 1) {
            return script.term("-", new Term[]{term});
        }
        return term;
    }

    private static Term createBoundedDiffTerm(Script script, Term term, Term term2, Rational rational, boolean bl) {
        Term term3;
        Term term4 = term;
        boolean bl2 = SmtSortUtils.isIntSort((Sort)term4.getSort());
        Term term5 = term2;
        boolean bl3 = SmtSortUtils.isIntSort((Sort)term5.getSort());
        if (bl2 && bl3) {
            term3 = rational.floor().toTerm(term4.getSort());
        } else {
            term3 = rational.toTerm(SmtSortUtils.getRealSort((Script)script));
            if (bl2) {
                term = script.term("to_real", new Term[]{term});
            } else if (bl3) {
                term2 = script.term("to_real", new Term[]{term2});
            }
        }
        Term term6 = SmtUtils.minus((Script)script, (Term[])new Term[]{term, term2});
        if (bl) {
            return SmtUtils.binaryEquality((Script)script, (Term)term6, (Term)term3);
        }
        return SmtUtils.leq((Script)script, (Term)term6, (Term)term3);
    }

    public String toString() {
        return this.toStringHalf();
    }

    public String toStringFull() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.mSize) {
            String string = "";
            int n2 = 0;
            while (n2 < this.mSize) {
                stringBuilder.append(string);
                stringBuilder.append(this.get(n, n2));
                string = "\t";
                ++n2;
            }
            stringBuilder.append("\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    public String toStringHalf() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 2;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.mEntries.length) {
            stringBuilder.append(this.mEntries[n3]);
            if (n3 == n2) {
                stringBuilder.append("\n");
                n2 = ++n * n / 2 - 1;
            } else {
                stringBuilder.append("\t");
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static interface WideningStepSupplier {
        public Rational nextWideningStep(Rational var1);
    }
}

