/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IndexedStatement;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVar;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVarBuilder;
import java.util.Collection;

public class ReachDefBoogieVisitor
extends BoogieVisitor {
    private final ReachDefStatementAnnotation mCurrentRD;
    private Statement mCurrentStatement;
    private UnmodifiableTransFormula mCurrentTransFormula;
    private boolean mIsLHS;
    private boolean mIsAssume;
    private ReachDefStatementAnnotation mOldRD;
    private final ScopedBoogieVarBuilder mBuilder;
    private final String mKey;

    public ReachDefBoogieVisitor(ReachDefStatementAnnotation reachDefStatementAnnotation, ScopedBoogieVarBuilder scopedBoogieVarBuilder) {
        this(reachDefStatementAnnotation, scopedBoogieVarBuilder, null);
    }

    public ReachDefBoogieVisitor(ReachDefStatementAnnotation reachDefStatementAnnotation, ScopedBoogieVarBuilder scopedBoogieVarBuilder, String string) {
        assert (reachDefStatementAnnotation != null);
        this.mCurrentRD = reachDefStatementAnnotation;
        this.mBuilder = scopedBoogieVarBuilder;
        this.mKey = string;
    }

    public void process(Statement statement, UnmodifiableTransFormula unmodifiableTransFormula) throws Throwable {
        assert (statement != null);
        assert (this.mCurrentRD != null);
        this.mCurrentStatement = statement;
        this.mCurrentTransFormula = unmodifiableTransFormula;
        this.mIsLHS = false;
        this.mIsAssume = false;
        this.mOldRD = this.mCurrentRD.clone();
        this.processStatement(statement);
    }

    protected LeftHandSide processLeftHandSide(LeftHandSide leftHandSide) {
        this.mIsLHS = true;
        LeftHandSide leftHandSide2 = super.processLeftHandSide(leftHandSide);
        this.mIsLHS = false;
        return leftHandSide2;
    }

    protected void visit(VariableLHS variableLHS) {
        super.visit(variableLHS);
        this.updateDef(this.mBuilder.getScopedBoogieVar(variableLHS, this.mCurrentTransFormula), this.mCurrentStatement);
    }

    protected Statement processStatement(Statement statement) {
        this.mIsAssume = statement instanceof AssumeStatement;
        return super.processStatement(statement);
    }

    protected void visit(IdentifierExpression identifierExpression) {
        super.visit(identifierExpression);
        ScopedBoogieVar scopedBoogieVar = this.mBuilder.getScopedBoogieVar(identifierExpression, this.mCurrentTransFormula);
        if (this.mIsAssume) {
            this.updateUse(scopedBoogieVar);
            this.updateDef(scopedBoogieVar, this.mCurrentStatement);
        } else if (this.mIsLHS) {
            this.updateDef(scopedBoogieVar, this.mCurrentStatement);
        } else {
            this.updateUse(scopedBoogieVar);
        }
    }

    private void updateDef(ScopedBoogieVar scopedBoogieVar, Statement statement) {
        this.mCurrentRD.removeAllDefs(scopedBoogieVar);
        this.mCurrentRD.addDef(scopedBoogieVar, statement, this.mKey);
    }

    private void updateUse(ScopedBoogieVar scopedBoogieVar) {
        Collection<IndexedStatement> collection = this.mOldRD.getDef(scopedBoogieVar);
        if (collection != null) {
            for (IndexedStatement indexedStatement : collection) {
                this.mCurrentRD.addUse(scopedBoogieVar, indexedStatement.getStatement(), indexedStatement.getKey());
            }
        }
    }
}

