/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;

public abstract class LAReason {
    private final LinVar mVar;
    protected InfinitesimalNumber mBound;
    private LAReason mOldReason;
    private final boolean mIsUpper;
    private final LiteralReason mLastlit;

    public LAReason(LinVar linVar, InfinitesimalNumber infinitesimalNumber, boolean bl, LiteralReason literalReason) {
        this.mVar = linVar;
        this.mBound = infinitesimalNumber;
        this.mIsUpper = bl;
        this.mLastlit = literalReason == null ? (LiteralReason)this : literalReason;
    }

    public InfinitesimalNumber getBound() {
        return this.mBound;
    }

    public InfinitesimalNumber getExactBound() {
        return this.mBound;
    }

    public LinVar getVar() {
        return this.mVar;
    }

    public boolean isUpper() {
        return this.mIsUpper;
    }

    public LAReason getOldReason() {
        return this.mOldReason;
    }

    public void setOldReason(LAReason lAReason) {
        this.mOldReason = lAReason;
    }

    public LiteralReason getLastLiteral() {
        return this.mLastlit;
    }

    abstract InfinitesimalNumber explain(Explainer var1, InfinitesimalNumber var2, Rational var3);

    public String toString() {
        return String.valueOf(this.mVar) + (this.mIsUpper ? "<=" : ">=") + String.valueOf(this.mBound);
    }

    public int hashCode() {
        return HashUtils.hashJenkins((int)this.mBound.hashCode(), (Object)this.mVar);
    }

    public Term toSMTLIB(Theory theory, boolean bl) {
        MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
        mutableAffineTerm.add(Rational.ONE, this.mVar);
        mutableAffineTerm.add(this.mBound.negate());
        if (!this.mIsUpper) {
            mutableAffineTerm.add(this.mVar.getEpsilon());
        }
        Term term = mutableAffineTerm.toSMTLibLeq0(theory);
        return this.mIsUpper ? term : theory.term("not", new Term[]{term});
    }
}

