/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListExistingOperations {
    private final Map<String, Set<Class<?>>> mExistingOperations;
    private final List<String> mOperationList = new ArrayList<String>();

    public ListExistingOperations(Map<String, Set<Class<?>>> map) {
        this.mExistingOperations = map;
        for (Set<Class<?>> set : this.mExistingOperations.values()) {
            for (Class<?> clazz : set) {
                Constructor<?>[] constructorArray = clazz.getConstructors();
                int n = constructorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Constructor<?> constructor = constructorArray[n2];
                    this.mOperationList.add(ListExistingOperations.constructorStringRepresentation(constructor));
                    ++n2;
                }
            }
        }
    }

    private static String constructorStringRepresentation(Constructor<?> constructor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ListExistingOperations.firstLetterToLowerCase(constructor.getDeclaringClass().getSimpleName()));
        stringBuilder.append("(");
        boolean bl = false;
        int n = 0;
        while (n < constructor.getParameterTypes().length) {
            Class<?> clazz = constructor.getParameterTypes()[n];
            if (!AutomataLibraryServices.class.isAssignableFrom(clazz) && !IStateFactory.class.isAssignableFrom(clazz)) {
                if (bl) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(clazz.getSimpleName());
                bl = true;
            }
            ++n;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String prettyPrint() {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = this.mOperationList.toArray(new String[this.mOperationList.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            stringBuilder.append((String)object);
            stringBuilder.append(System.getProperty("line.separator"));
            ++n2;
        }
        return stringBuilder.toString();
    }

    static String firstLetterToLowerCase(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }
}

