/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import java.util.function.Function;

public final class EvaluatorUtils {
    private EvaluatorUtils() {
    }

    public static EvaluatorType getEvaluatorType(IProgramVar iProgramVar) {
        Function<Sort, EvaluatorType> function = sort -> EvaluatorType.INTEGER;
        Function<Sort, EvaluatorType> function2 = sort -> EvaluatorType.REAL;
        Function<Sort, EvaluatorType> function3 = sort -> EvaluatorType.BOOL;
        Function<Sort, EvaluatorType> function4 = sort -> (EvaluatorType)((Object)((Object)TypeUtils.applyTypeFunction(function, function2, function3, null, TypeUtils.getInnermostArrayValueSort(sort))));
        return TypeUtils.applyTypeFunction(function, function2, function3, function4, iProgramVar.getSort());
    }

    public static EvaluatorType getEvaluatorType(IProgramVarOrConst iProgramVarOrConst) {
        Function<Sort, EvaluatorType> function = sort -> EvaluatorType.INTEGER;
        Function<Sort, EvaluatorType> function2 = sort -> EvaluatorType.REAL;
        Function<Sort, EvaluatorType> function3 = sort -> EvaluatorType.BOOL;
        Function<Sort, EvaluatorType> function4 = sort -> (EvaluatorType)((Object)((Object)TypeUtils.applyTypeFunction(function, function2, function3, null, TypeUtils.getInnermostArrayValueSort(sort))));
        return TypeUtils.applyTypeFunction(function, function2, function3, function4, iProgramVarOrConst.getTerm().getSort());
    }

    public static EvaluatorType getEvaluatorType(IBoogieType iBoogieType2) {
        Function<IBoogieType, EvaluatorType> function = iBoogieType -> EvaluatorType.INTEGER;
        Function<IBoogieType, EvaluatorType> function2 = iBoogieType -> EvaluatorType.REAL;
        Function<IBoogieType, EvaluatorType> function3 = iBoogieType -> EvaluatorType.BOOL;
        ArrayFunction arrayFunction = new ArrayFunction(iBoogieType2, function, function2, function3);
        return TypeUtils.applyTypeFunction(function, function2, function3, arrayFunction, iBoogieType2);
    }

    private static final class ArrayFunction
    implements Function<IBoogieType, EvaluatorType> {
        private final IBoogieType mType;
        private final Function<IBoogieType, EvaluatorType> mIntFunction;
        private final Function<IBoogieType, EvaluatorType> mRealFunction;
        private final Function<IBoogieType, EvaluatorType> mBoolFunction;

        private ArrayFunction(IBoogieType iBoogieType, Function<IBoogieType, EvaluatorType> function, Function<IBoogieType, EvaluatorType> function2, Function<IBoogieType, EvaluatorType> function3) {
            this.mType = iBoogieType;
            this.mIntFunction = function;
            this.mRealFunction = function2;
            this.mBoolFunction = function3;
        }

        @Override
        public EvaluatorType apply(IBoogieType iBoogieType) {
            BoogieArrayType boogieArrayType = (BoogieArrayType)this.mType;
            return TypeUtils.applyTypeFunction(this.mIntFunction, this.mRealFunction, this.mBoolFunction, new ArrayFunction(iBoogieType, this.mIntFunction, this.mRealFunction, this.mBoolFunction), (IBoogieType)boogieArrayType.getValueType());
        }
    }

    public static enum EvaluatorType {
        REAL,
        INTEGER,
        BOOL;

    }
}

