/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.INaryTermEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.ITermEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ApplicationTermEvaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends IAbstractState<STATE>>
implements INaryTermEvaluator<VALUE, STATE> {
    private final int mArity;
    private final List<ITermEvaluator<VALUE, STATE>> mSubEvaluators;
    private final String mOperator;
    private final INonrelationalValueFactory<VALUE> mNonrelationalValueFactory;
    private final Supplier<STATE> mBottomStateSupplier;
    private final VALUE mTopValue;
    private final int mMaxParallelStates;
    private final Set<String> mVarIdentifiers;
    private final EvaluatorLogger mLogger;
    private STATE mLastEvaluatedState;
    private List<List<IEvaluationResult<VALUE>>> mLastEvaluatedResult;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String COMPEQ = "=";
    private static final String LOGICNEG = "not";

    protected ApplicationTermEvaluator(EvaluatorLogger evaluatorLogger, int n, String string, int n2, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory, Supplier<STATE> supplier) {
        this.mLogger = evaluatorLogger;
        this.mArity = n;
        this.mSubEvaluators = new ArrayList<ITermEvaluator<VALUE, STATE>>();
        this.mOperator = string;
        this.mNonrelationalValueFactory = iNonrelationalValueFactory;
        this.mMaxParallelStates = n2;
        this.mBottomStateSupplier = supplier;
        this.mTopValue = this.mNonrelationalValueFactory.createTopValue();
        this.mVarIdentifiers = new HashSet<String>();
    }

    @Override
    public List<IEvaluationResult<VALUE>> evaluate(STATE STATE) {
        assert (STATE != null);
        if (this.mOperator == TRUE) {
            return this.onlyBooleanValue(BooleanValue.TRUE);
        }
        if (this.mOperator == FALSE) {
            return this.onlyBooleanValue(BooleanValue.FALSE);
        }
        List<List<IEvaluationResult<VALUE>>> list = this.evaluateAndPermutate(STATE);
        this.mSubEvaluators.forEach(iTermEvaluator -> {
            boolean bl = this.mVarIdentifiers.addAll(iTermEvaluator.getVarIdentifiers());
        });
        ArrayList<IEvaluationResult<VALUE>> arrayList = new ArrayList<IEvaluationResult<VALUE>>();
        for (List<IEvaluationResult<VALUE>> list2 : list) {
            List<IEvaluationResult<VALUE>> list3 = this.evaluate(list2);
            this.mLogger.logEvaluation((Object)this.mOperator, list3, list2);
            arrayList.addAll(list3);
        }
        assert (!arrayList.isEmpty());
        return new ArrayList<IEvaluationResult<VALUE>>(this.mergeResult(arrayList));
    }

    private Collection<IEvaluationResult<VALUE>> mergeResult(Collection<IEvaluationResult<VALUE>> collection) {
        if (this.mOperator == LOGICNEG) {
            return NonrelationalUtils.mergeIfNecessary(collection, 2);
        }
        return NonrelationalUtils.mergeIfNecessary(collection, this.mMaxParallelStates);
    }

    @Override
    private List<IEvaluationResult<VALUE>> evaluate(List<IEvaluationResult<VALUE>> list) {
        if (this.mOperator == COMPEQ) {
            return this.evaluateEquality(list);
        }
        if (this.mOperator == LOGICNEG) {
            return this.evaluateLogicNegation(list);
        }
        throw new UnsupportedOperationException("Unsupported operator: " + this.mOperator);
    }

    private List<List<IEvaluationResult<VALUE>>> evaluateAndPermutate(STATE STATE) {
        assert (STATE != null);
        if (this.mLastEvaluatedState != null && this.mLastEvaluatedState == STATE) {
            return this.mLastEvaluatedResult;
        }
        this.mLastEvaluatedState = STATE;
        ArrayList arrayList = new ArrayList();
        this.mSubEvaluators.forEach(iTermEvaluator -> {
            boolean bl = arrayList.add(iTermEvaluator.evaluate(STATE));
        });
        List<List<IEvaluationResult<VALUE>>> list2 = ApplicationTermEvaluator.generatePermutations(arrayList, 0, new ArrayList());
        assert (list2.stream().allMatch(list -> list.size() == this.mSubEvaluators.size()));
        this.mLastEvaluatedResult = list2;
        return list2;
    }

    private static <VALUE> List<List<VALUE>> generatePermutations(List<List<VALUE>> list, int n, List<VALUE> list2) {
        if (n == list.size() - 1) {
            ArrayList<List<VALUE>> arrayList = new ArrayList<List<VALUE>>();
            for (VALUE VALUE : list.get(list.size() - 1)) {
                ArrayList arrayList2 = new ArrayList();
                list2.forEach(object -> {
                    boolean bl = arrayList2.add(object);
                });
                arrayList2.add(VALUE);
                arrayList.add(arrayList2);
            }
            return arrayList;
        }
        ArrayList<List<VALUE>> arrayList = new ArrayList<List<VALUE>>();
        for (VALUE VALUE : list.get(n)) {
            ArrayList arrayList3 = new ArrayList();
            list2.forEach(object -> {
                boolean bl = arrayList3.add(object);
            });
            arrayList3.add(VALUE);
            arrayList.addAll(ApplicationTermEvaluator.generatePermutations(list, n + 1, arrayList3));
        }
        return arrayList;
    }

    private List<IEvaluationResult<VALUE>> onlyBooleanValue(BooleanValue booleanValue) {
        assert (booleanValue != null);
        assert (booleanValue != BooleanValue.INVALID);
        return Collections.singletonList(new NonrelationalEvaluationResult<VALUE>(this.mTopValue, booleanValue));
    }

    private List<IEvaluationResult<VALUE>> evaluateEquality(List<IEvaluationResult<VALUE>> list) {
        assert (list != null);
        assert (!list.isEmpty());
        if (list.size() < 2) {
            throw new UnsupportedOperationException("The evaluation result list (" + String.valueOf(list) + ") does not contain the necessary number of arguments to check for equality.");
        }
        BooleanValue booleanValue3 = BooleanValue.INVALID;
        if (this.mSubEvaluators.stream().anyMatch(iTermEvaluator -> iTermEvaluator.containsBool())) {
            list.get(0).getBooleanValue();
            booleanValue3 = list.stream().map(iEvaluationResult -> iEvaluationResult.getBooleanValue()).reduce(BooleanValue.TOP, (booleanValue, booleanValue2) -> booleanValue.intersect((BooleanValue)booleanValue2)) != BooleanValue.BOTTOM ? BooleanValue.TRUE : BooleanValue.BOTTOM;
        }
        INonrelationalValue iNonrelationalValue3 = list.stream().map(iEvaluationResult -> (INonrelationalValue)iEvaluationResult.getValue()).reduce((INonrelationalValue)this.mNonrelationalValueFactory.createTopValue(), (iNonrelationalValue, iNonrelationalValue2) -> iNonrelationalValue.intersect(iNonrelationalValue2));
        if (booleanValue3.isBottom() || iNonrelationalValue3.isBottom()) {
            booleanValue3 = BooleanValue.FALSE;
        } else if (!this.mSubEvaluators.stream().anyMatch(iTermEvaluator -> iTermEvaluator.containsBool())) {
            booleanValue3 = BooleanValue.TOP;
            int n = 1;
            while (n < list.size()) {
                INonrelationalValue iNonrelationalValue4 = (INonrelationalValue)list.get(n - 1).getValue();
                INonrelationalValue iNonrelationalValue5 = (INonrelationalValue)list.get(n).getValue();
                booleanValue3 = booleanValue3.intersect(iNonrelationalValue4.isEqual(iNonrelationalValue5));
                ++n;
            }
        }
        return Collections.singletonList(new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue3, booleanValue3));
    }

    private List<IEvaluationResult<VALUE>> evaluateLogicNegation(List<IEvaluationResult<VALUE>> list) {
        assert (list != null);
        assert (!list.isEmpty());
        if (list.size() > 1) {
            throw new UnsupportedOperationException("Term for logical negation has more than one argument (" + list.size() + ").");
        }
        IEvaluationResult<VALUE> iEvaluationResult = list.get(0);
        BooleanValue booleanValue = iEvaluationResult.getBooleanValue().neg();
        VALUE VALUE = this.mNonrelationalValueFactory.createTopValue();
        NonrelationalEvaluationResult<VALUE> nonrelationalEvaluationResult = new NonrelationalEvaluationResult<VALUE>(VALUE, booleanValue);
        return Collections.singletonList(nonrelationalEvaluationResult);
    }

    @Override
    public List<STATE> inverseEvaluate(IEvaluationResult<VALUE> iEvaluationResult2, STATE STATE) {
        if (this.mOperator == TRUE) {
            return Collections.singletonList(STATE);
        }
        if (this.mOperator == FALSE) {
            return Collections.singletonList((IAbstractState)this.mBottomStateSupplier.get());
        }
        ArrayList arrayList = new ArrayList();
        INonrelationalValue iNonrelationalValue = (INonrelationalValue)iEvaluationResult2.getValue();
        iEvaluationResult2.getBooleanValue();
        List<List<IEvaluationResult<VALUE>>> list3 = this.evaluateAndPermutate(STATE);
        for (List<IEvaluationResult<VALUE>> list4 : list3) {
            ArrayList<STATE> arrayList2 = new ArrayList<STATE>();
            if (this.mOperator == COMPEQ) {
                Optional optional;
                BooleanValue booleanValue3 = list4.stream().map(iEvaluationResult -> iEvaluationResult.getBooleanValue()).reduce(BooleanValue.TOP, (booleanValue, booleanValue2) -> booleanValue.intersect((BooleanValue)booleanValue2));
                if (this.mSubEvaluators.stream().anyMatch(iTermEvaluator -> iTermEvaluator.containsBool()) && booleanValue3 == BooleanValue.TOP) {
                    arrayList2.add(STATE);
                    break;
                }
                ArrayList arrayList3 = new ArrayList();
                list4.stream().forEach(iEvaluationResult -> {
                    boolean bl = arrayList3.add(iEvaluationResult);
                });
                ArrayList<List<VALUE>> arrayList4 = new ArrayList<List<VALUE>>();
                int n = 1;
                while (n < arrayList3.size()) {
                    optional = (IEvaluationResult)arrayList3.get(n - 1);
                    IEvaluationResult iEvaluationResult3 = (IEvaluationResult)arrayList3.get(n);
                    INonrelationalValue iNonrelationalValue2 = (INonrelationalValue)optional.getValue();
                    BooleanValue booleanValue4 = optional.getBooleanValue();
                    INonrelationalValue iNonrelationalValue3 = (INonrelationalValue)iEvaluationResult3.getValue();
                    BooleanValue booleanValue5 = iEvaluationResult3.getBooleanValue();
                    INonrelationalValue iNonrelationalValue4 = this.inverseEvaluate(iNonrelationalValue, iNonrelationalValue2, iNonrelationalValue3, true);
                    INonrelationalValue iNonrelationalValue5 = this.inverseEvaluate(iNonrelationalValue, iNonrelationalValue3, iNonrelationalValue2, false);
                    NonrelationalEvaluationResult<INonrelationalValue> nonrelationalEvaluationResult = new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue4, booleanValue5);
                    NonrelationalEvaluationResult<INonrelationalValue> nonrelationalEvaluationResult2 = new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue5, booleanValue4);
                    List<STATE> list5 = this.mSubEvaluators.get(n - 1).inverseEvaluate(nonrelationalEvaluationResult, STATE);
                    List<STATE> list6 = this.mSubEvaluators.get(n).inverseEvaluate(nonrelationalEvaluationResult2, STATE);
                    arrayList4.add(this.crossIntersect(list5, list6));
                    ++n;
                }
                List<List<VALUE>> list7 = ApplicationTermEvaluator.generatePermutations(arrayList4, 0, new ArrayList());
                optional = list7.stream().reduce((list, list2) -> this.crossIntersect((List<STATE>)list, (List<STATE>)list2));
                if (!optional.isPresent()) {
                    throw new UnsupportedOperationException("Could not intersect resulting states.");
                }
                arrayList2.addAll((Collection)optional.get());
            } else if (this.mOperator == LOGICNEG) {
                iEvaluationResult2.getBooleanValue().neg();
            }
            if (arrayList2.isEmpty()) {
                arrayList2.add(STATE);
            }
            this.mLogger.logEvaluation((Object)this.mOperator, arrayList2, iEvaluationResult2, STATE);
            arrayList.addAll(arrayList2);
        }
        assert (!arrayList.isEmpty());
        return arrayList;
    }

    private List<STATE> crossIntersect(List<STATE> list, List<STATE> list2) {
        ArrayList<IAbstractState> arrayList = new ArrayList<IAbstractState>(list.size() * list2.size());
        for (IAbstractState iAbstractState : list) {
            for (IAbstractState iAbstractState2 : list2) {
                arrayList.add(iAbstractState.intersect(iAbstractState2));
            }
        }
        return arrayList;
    }

    private VALUE inverseEvaluate(VALUE VALUE, VALUE VALUE2, VALUE VALUE3, boolean bl) {
        VALUE VALUE4 = null;
        if (this.mOperator.equals(COMPEQ)) {
            VALUE4 = VALUE3.inverseEquality(VALUE2, VALUE);
        }
        assert (VALUE4 != null);
        return VALUE4;
    }

    @Override
    public void addSubEvaluator(ITermEvaluator<VALUE, STATE> iTermEvaluator) {
        if (this.mSubEvaluators.size() >= this.mArity) {
            throw new UnsupportedOperationException("The arity of this evaluator (" + this.mArity + ") does not allow to add additional sub evaluators.");
        }
        this.mSubEvaluators.add(iTermEvaluator);
    }

    @Override
    public boolean hasFreeOperands() {
        return this.mSubEvaluators.size() < this.mArity;
    }

    @Override
    public boolean containsBool() {
        if (this.mArity == 0) {
            if (this.mOperator.equals(TRUE) || this.mOperator.equals(FALSE)) {
                return true;
            }
            throw new UnsupportedOperationException("An arity of 0 should indicate containment of boolean values, however, the operator was unsupported or not boolean: " + this.mOperator);
        }
        return this.mSubEvaluators.stream().anyMatch(iTermEvaluator -> iTermEvaluator.containsBool());
    }

    @Override
    public Set<String> getVarIdentifiers() {
        return this.mVarIdentifiers;
    }

    @Override
    public int getArity() {
        return this.mArity;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.mOperator);
        stringBuilder.append(" ");
        stringBuilder.append(this.mSubEvaluators.stream().map(iTermEvaluator -> iTermEvaluator.toString()).collect(Collectors.joining(" ")));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

