/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp;

import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqStateFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqTransitionRelation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.VPDomainBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.VPDomainSettings;
import de.uni_freiburg.informatik.ultimate.util.VMUtils;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VPDomain<ACTION extends IIcfgTransition<IcfgLocation>>
implements IAbstractDomain<EqState, ACTION> {
    private final EqPostOperator<ACTION> mPost;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final IIcfgSymbolTable mSymboltable;
    private final boolean mDebugMode;
    private final EqConstraintFactory<EqNode> mEqConstraintFactory;
    private final EqNodeAndFunctionFactory mEqNodeAndFunctionFactory;
    private final EqStateFactory mEqStateFactory;
    private final CfgSmtToolkit mCsToolkit;
    private final IUltimateServiceProvider mServices;
    private final VPDomainBenchmark mBenchmark;
    private final VPDomainSettings mSettings;

    public VPDomain(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, Set<IProgramConst> set, List<String> list, Set<String> set2) {
        this.mLogger = iLogger;
        this.mManagedScript = cfgSmtToolkit.getManagedScript();
        this.mSymboltable = cfgSmtToolkit.getSymbolTable();
        this.mCsToolkit = cfgSmtToolkit;
        this.mServices = iUltimateServiceProvider;
        this.mDebugMode = VMUtils.areAssertionsEnabled();
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mSettings = new VPDomainSettings();
        this.mEqNodeAndFunctionFactory = new EqNodeAndFunctionFactory(iUltimateServiceProvider, this.mManagedScript, set, list, set2);
        this.mEqConstraintFactory = new EqConstraintFactory((AbstractNodeAndFunctionFactory)this.mEqNodeAndFunctionFactory, this.mServices, this.mManagedScript, VPDomain.prepareWeqSettings(iPreferenceProvider), this.mDebugMode, set);
        this.mEqStateFactory = new EqStateFactory(this.mEqNodeAndFunctionFactory, this.mEqConstraintFactory, this.mSymboltable, this.mManagedScript, this.mSettings);
        this.mPost = new EqPostOperator(this.mServices, this.mLogger, this.mCsToolkit, this.mEqNodeAndFunctionFactory, this.mEqConstraintFactory, this.mEqStateFactory, this.mSettings);
        this.mBenchmark = new VPDomainBenchmark();
    }

    private static WeqSettings prepareWeqSettings(IPreferenceProvider iPreferenceProvider) {
        WeqSettings weqSettings = new WeqSettings();
        weqSettings.setDeactivateWeakEquivalences(iPreferenceProvider.getBoolean("Deactivate Weak Equivalences"));
        weqSettings.setPreciseWeqLabelComparison(iPreferenceProvider.getBoolean("Precise comparison operator"));
        return weqSettings;
    }

    public IAbstractStateBinaryOperator<EqState> getWideningOperator() {
        return EqState::widen;
    }

    public IAbstractPostOperator<EqState, ACTION> getPostOperator() {
        return this.mPost;
    }

    public ManagedScript getManagedScript() {
        return this.mManagedScript;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public IIcfgSymbolTable getSymbolTable() {
        return this.mSymboltable;
    }

    public EqState createTopState() {
        return this.mEqStateFactory.getTopState();
    }

    public EqState createBottomState() {
        return this.mEqStateFactory.getBottomState();
    }

    public boolean isDebugMode() {
        return this.mDebugMode;
    }

    public EqStateFactory getEqStateFactory() {
        return this.mEqStateFactory;
    }

    public boolean useHierachicalPre() {
        return true;
    }

    public <LOC> void afterFixpointComputation(IAbstractInterpretationResult<EqState, ACTION, LOC> iAbstractInterpretationResult) {
        BenchmarkWithCounters benchmarkWithCounters;
        BenchmarkWithCounters benchmarkWithCounters2;
        this.mBenchmark.setLocationsCounter(iAbstractInterpretationResult.getLoc2SingleStates().size());
        for (Map.Entry object2 : iAbstractInterpretationResult.getLoc2SingleStates().entrySet()) {
            this.mBenchmark.reportStatsForLocation(arg_0 -> ((EqState)object2.getValue()).getConstraint().getStatistics(arg_0));
        }
        this.mBenchmark.setTransitionsCounter(this.mPost.getTransformulaConverterCache().getAllTransitionRelations().size());
        Iterator<Object> iterator = this.mPost.getTransformulaConverterCache().getAllTransitionRelations().iterator();
        while (iterator.hasNext()) {
            EqTransitionRelation eqTransitionRelation = (EqTransitionRelation)iterator.next();
            this.mBenchmark.reportStatsForTransitionRelation(eqTransitionRelation::getStatistics);
        }
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, "ArrayEqualityDomainStatistics", (ICsvProviderProvider)this.mBenchmark));
        BenchmarkWithCounters benchmarkWithCounters3 = this.mPost.getBenchmark();
        if (benchmarkWithCounters3 != null) {
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, "EqPostOperator statistics", (ICsvProviderProvider)benchmarkWithCounters3));
        }
        if ((iterator = this.mEqConstraintFactory.getBenchmark()) != null) {
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, "EqConstraintFactoryStatistics", (ICsvProviderProvider)this.mEqConstraintFactory.getBenchmark()));
        }
        if ((benchmarkWithCounters2 = this.mEqConstraintFactory.getWeqCcManager().getBenchmark()) != null) {
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, "WeqCcManagerStatistics", (ICsvProviderProvider)this.mEqConstraintFactory.getWeqCcManager().getBenchmark()));
        }
        if ((benchmarkWithCounters = this.mEqConstraintFactory.getWeqCcManager().getCcManager().getBenchmark()) != null) {
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, "CcManagerStatistics", (ICsvProviderProvider)benchmarkWithCounters));
        }
        if (this.mEqConstraintFactory.getWeqCcManager().getCcManager().hasPartialOrderCacheBenchmark()) {
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, "CcManagerStatistics", (ICsvProviderProvider)this.mEqConstraintFactory.getWeqCcManager().getCcManager().getPartialOrderCacheBenchmark()));
        }
    }
}

