/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.ScopeUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IScopedMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ScopedHashMap<K, V>
extends AbstractMap<K, V>
implements IScopedMap<K, V> {
    private final HashMap<K, V> mMap;
    private HashMap<K, V>[] mHistory;
    private int mCurScope = -1;
    private final boolean mShrink;

    public ScopedHashMap() {
        this(true);
    }

    public ScopedHashMap(ScopedHashMap<K, V> scopedHashMap) {
        this.mMap = new HashMap<K, V>(scopedHashMap.mMap);
        this.mHistory = new HashMap[scopedHashMap.mHistory.length];
        int n = 0;
        while (n < this.mHistory.length) {
            HashMap<K, V> hashMap = scopedHashMap.mHistory[n];
            this.mHistory[n] = hashMap == null ? null : new HashMap<K, V>(hashMap);
            ++n;
        }
        this.mShrink = scopedHashMap.mShrink;
        this.mCurScope = scopedHashMap.mCurScope;
    }

    public ScopedHashMap(boolean bl) {
        this.mMap = new HashMap();
        this.mHistory = new HashMap[5];
        this.mShrink = bl;
    }

    HashMap<K, V> getMap() {
        return this.mMap;
    }

    public HashMap<K, V> undoMap() {
        return this.mHistory[this.mCurScope];
    }

    void recordUndo(K k, V v) {
        HashMap<K, V> hashMap;
        if (this.mCurScope != -1 && !(hashMap = this.undoMap()).containsKey(k)) {
            hashMap.put(k, v);
        }
    }

    void undoEntry(Map.Entry<K, V> entry) {
        if (entry.getValue() == null) {
            this.mMap.remove(entry.getKey());
        } else {
            this.mMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void beginScope() {
        if (this.mCurScope == this.mHistory.length - 1) {
            this.mHistory = ScopeUtils.grow(this.mHistory);
        }
        this.mHistory[++this.mCurScope] = new HashMap();
    }

    @Override
    public void endScope() {
        for (Map.Entry<K, V> entry : this.undoMap().entrySet()) {
            this.undoEntry(entry);
        }
        this.mHistory[this.mCurScope--] = null;
        if (this.mShrink && ScopeUtils.shouldShrink(this.mHistory)) {
            this.mHistory = ScopeUtils.shrink(this.mHistory);
        }
    }

    public Iterable<Map.Entry<K, V>> currentScopeEntries() {
        if (this.mCurScope == -1) {
            return this.entrySet();
        }
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        final Object k = this.mLast.getKey();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return k;
                            }

                            @Override
                            public V getValue() {
                                return ScopedHashMap.this.getMap().get(k);
                            }

                            @Override
                            public V setValue(V v) {
                                return ScopedHashMap.this.getMap().put(k, v);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedHashMap.this.undoMap().size();
            }
        };
    }

    @Override
    public Iterable<K> currentScopeKeys() {
        if (this.mCurScope == -1) {
            return this.keySet();
        }
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public K next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast.getKey();
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedHashMap.this.undoMap().size();
            }
        };
    }

    public Iterable<V> currentScopeValues() {
        if (this.mCurScope == -1) {
            return this.values();
        }
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public V next() {
                        this.mLast = this.mBacking.next();
                        return ScopedHashMap.this.getMap().get(this.mLast.getKey());
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedHashMap.this.undoMap().size();
            }
        };
    }

    @Override
    public void clear() {
        this.mMap.clear();
        this.mHistory = new HashMap[5];
    }

    @Override
    public boolean containsKey(Object object) {
        return this.mMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.mMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.mMap.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean isEmptyScope() {
        return this.mCurScope == -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedHashMap.this.getMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast;
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedHashMap.this.recordUndo(this.mLast.getKey(), this.mLast.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return ScopedHashMap.this.getMap().size();
            }
        };
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        V v2 = this.mMap.put(k, v);
        this.recordUndo(k, v2);
        return v2;
    }

    @Override
    public V remove(Object object) {
        V v = this.mMap.remove(object);
        this.recordUndo(object, v);
        return v;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    public int getActiveScopeNum() {
        return this.mCurScope + 1;
    }

    public boolean overwritesKeyInScope(Object object, int n) {
        assert (n != 0);
        return this.mHistory[n - 1].containsKey(object);
    }
}

