/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqDisjunctiveConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.FormulaToEqDisjunctiveConstraintConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqTransitionRelation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.VPDomainSettings;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TransFormulaConverterCache {
    private final EqConstraintFactory<EqNode> mEqConstraintFactory;
    private final EqNodeAndFunctionFactory mEqNodeAndFunctionFactory;
    private final Map<TransFormula, EqTransitionRelation> mTransformulaToEqTransitionRelationCache = new HashMap<TransFormula, EqTransitionRelation>();
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final VPDomainSettings mVPDomainSettings;

    public TransFormulaConverterCache(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, EqNodeAndFunctionFactory eqNodeAndFunctionFactory, EqConstraintFactory<EqNode> eqConstraintFactory, VPDomainSettings vPDomainSettings) {
        this.mEqNodeAndFunctionFactory = eqNodeAndFunctionFactory;
        this.mEqConstraintFactory = eqConstraintFactory;
        this.mMgdScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mVPDomainSettings = vPDomainSettings;
    }

    public EqTransitionRelation getTransitionRelationForTransformula(TransFormula transFormula) {
        EqTransitionRelation eqTransitionRelation = this.mTransformulaToEqTransitionRelationCache.get(transFormula);
        if (eqTransitionRelation == null) {
            throw new AssertionError();
        }
        return eqTransitionRelation;
    }

    public EqTransitionRelation getOrConstructEqTransitionRelationFromTransformula(TransFormula transFormula) {
        EqTransitionRelation eqTransitionRelation = this.mTransformulaToEqTransitionRelationCache.get(transFormula);
        if (eqTransitionRelation == null) {
            eqTransitionRelation = this.convertTransformulaToEqTransitionRelation(transFormula);
            this.mTransformulaToEqTransitionRelationCache.put(transFormula, eqTransitionRelation);
        }
        return eqTransitionRelation;
    }

    private EqTransitionRelation convertTransformulaToEqTransitionRelation(TransFormula transFormula) {
        EqDisjunctiveConstraint eqDisjunctiveConstraint = new FormulaToEqDisjunctiveConstraintConverter(this.mServices, this.mMgdScript, this.mEqConstraintFactory, this.mEqNodeAndFunctionFactory, transFormula.getFormula()).getResult();
        assert (!this.mVPDomainSettings.isCheckTransitionAbstractionCorrectness() || this.transformulaImpliesResultConstraint(transFormula, (EqDisjunctiveConstraint<EqNode>)eqDisjunctiveConstraint));
        return new EqTransitionRelation((EqDisjunctiveConstraint<EqNode>)eqDisjunctiveConstraint, transFormula);
    }

    protected Pair<Term, Term> makeShiftVariableSubstitution(ManagedScript managedScript, TransFormula transFormula, EqDisjunctiveConstraint<EqNode> eqDisjunctiveConstraint) {
        ApplicationTerm applicationTerm;
        HashMap<Object, ApplicationTerm> hashMap = new HashMap<Object, ApplicationTerm>();
        for (Map.Entry termVariable2 : transFormula.getOutVars().entrySet()) {
            hashMap.put((Term)termVariable2.getValue(), ((IProgramVar)termVariable2.getKey()).getPrimedConstant());
        }
        for (Map.Entry entry : transFormula.getInVars().entrySet()) {
            hashMap.put((Term)entry.getValue(), ((IProgramVar)entry.getKey()).getDefaultConstant());
        }
        for (TermVariable termVariable : transFormula.getAuxVars()) {
            applicationTerm = ProgramVarUtils.getAuxVarConstant((ManagedScript)managedScript, (TermVariable)termVariable);
            hashMap.put(termVariable, applicationTerm);
        }
        Term term = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)eqDisjunctiveConstraint.getTerm(managedScript.getScript()));
        assert (term.getFreeVars().length == 0);
        Iterator iterator = ((UnmodifiableTransFormula)transFormula).getClosedFormula();
        applicationTerm = this.mEqConstraintFactory.getWeqCcManager().getNonTheoryLiteralDisequalitiesIfNecessary();
        Term term2 = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{iterator, applicationTerm});
        return new Pair((Object)term2, (Object)term);
    }

    private boolean transformulaImpliesResultConstraint(TransFormula transFormula, EqDisjunctiveConstraint<EqNode> eqDisjunctiveConstraint) {
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.echo((Object)this, new QuotedObject("Start implication check"));
        this.mMgdScript.push((Object)this, 1);
        Pair<Term, Term> pair = this.makeShiftVariableSubstitution(this.mMgdScript, transFormula, eqDisjunctiveConstraint);
        boolean bl = this.implicationCheck((Term)pair.getFirst(), (Term)pair.getSecond());
        this.mMgdScript.pop((Object)this, 1);
        this.mMgdScript.echo((Object)this, new QuotedObject("End implication check"));
        this.mMgdScript.unlock((Object)this);
        return bl;
    }

    protected boolean implicationCheck(Term term, Term term2) {
        ManagedScript managedScript = this.mMgdScript;
        managedScript.assertTerm((Object)this, term);
        managedScript.assertTerm((Object)this, Util.not((Script)managedScript.getScript(), (Term)term2));
        Script.LBool lBool = managedScript.checkSat((Object)this);
        if (lBool != Script.LBool.UNSAT) assert (false);
        return lBool == Script.LBool.UNSAT;
    }

    public Collection<EqTransitionRelation> getAllTransitionRelations() {
        return Collections.unmodifiableCollection(this.mTransformulaToEqTransitionRelationCache.values());
    }
}

