/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.sifa;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.sifa.DagInterpreter;
import de.uni_freiburg.informatik.ultimate.lib.sifa.IcfgInterpreter;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.CompoundDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.EqDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.ExplicitValueDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IntervalDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.OctagonDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.StatsWrapperDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.AlwaysFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.IFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.LogSizeWrapperFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.NeverFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.SizeLimitFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.StatsWrapperFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.FixpointLoopSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ICallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ILoopSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.InterpretCallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ReUseSupersetCallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.TopInputCallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.plugins.sifa.preferences.SifaPreferences;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SifaBuilder {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final IPreferenceProvider mPrefs;

    public SifaBuilder(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mPrefs = SifaPreferences.getPreferenceProvider(this.mServices);
    }

    public SifaComponents construct(IIcfg<IcfgLocation> iIcfg, IProgressAwareTimer iProgressAwareTimer) {
        return this.construct(iIcfg, iProgressAwareTimer, IcfgInterpreter.allErrorLocations(iIcfg));
    }

    public SifaComponents construct(IIcfg<IcfgLocation> iIcfg, IProgressAwareTimer iProgressAwareTimer, Collection<IcfgLocation> collection) {
        SifaStats sifaStats = new SifaStats();
        SymbolicTools symbolicTools = this.constructTools(sifaStats, iIcfg);
        IDomain iDomain = this.constructStatsDomain(sifaStats, symbolicTools, iProgressAwareTimer);
        IFluid iFluid = this.constructStatsFluid(sifaStats);
        Function<IcfgInterpreter, Function<DagInterpreter, ILoopSummarizer>> function = this.constructLoopSummarizer(sifaStats, iProgressAwareTimer, symbolicTools, iDomain, iFluid);
        Function<IcfgInterpreter, Function<DagInterpreter, ICallSummarizer>> function2 = this.constructCallSummarizer(sifaStats, symbolicTools, iDomain);
        IcfgInterpreter icfgInterpreter = new IcfgInterpreter(this.mLogger, iProgressAwareTimer, sifaStats, symbolicTools, iIcfg, collection, iDomain, iFluid, function, function2);
        return new SifaComponents(icfgInterpreter, iDomain, sifaStats);
    }

    private SymbolicTools constructTools(SifaStats sifaStats, IIcfg<IcfgLocation> iIcfg) {
        return new SymbolicTools(this.mServices, sifaStats, iIcfg, (SmtUtils.SimplificationTechnique)this.mPrefs.getEnum("Simplification Technique", SifaPreferences.CLASS_SIMPLIFICATION));
    }

    private IDomain constructStatsDomain(SifaStats sifaStats, SymbolicTools symbolicTools, IProgressAwareTimer iProgressAwareTimer) {
        return new StatsWrapperDomain(sifaStats, this.constructDomain(symbolicTools, iProgressAwareTimer));
    }

    private IDomain constructDomain(SymbolicTools symbolicTools, IProgressAwareTimer iProgressAwareTimer) {
        String string2 = this.mPrefs.getString("Abstract Domain");
        if (CompoundDomain.class.getSimpleName().equals(string2)) {
            List list = SifaPreferences.SubdomainValidator.subdomains(this.mPrefs.getString("CompoundDomain Intern Domains")).map(string -> this.constructNonCompoundDomain((String)string, symbolicTools, iProgressAwareTimer)).collect(Collectors.toList());
            return new CompoundDomain(symbolicTools, list);
        }
        return this.constructNonCompoundDomain(string2, symbolicTools, iProgressAwareTimer);
    }

    private IDomain constructNonCompoundDomain(String string, SymbolicTools symbolicTools, IProgressAwareTimer iProgressAwareTimer) {
        ExplicitValueDomain explicitValueDomain;
        if (ExplicitValueDomain.class.getSimpleName().equals(string)) {
            explicitValueDomain = new ExplicitValueDomain(symbolicTools, this.mPrefs.getInt("Max. Parallel Explicit Values"));
        } else if (IntervalDomain.class.getSimpleName().equals(string)) {
            explicitValueDomain = new IntervalDomain(this.mLogger, symbolicTools, this.mPrefs.getInt("Max. Parallel Intervals"), () -> iProgressAwareTimer);
        } else if (OctagonDomain.class.getSimpleName().equals(string)) {
            explicitValueDomain = new OctagonDomain(this.mLogger, symbolicTools, this.mPrefs.getInt("Max. Parallel Octagon"), () -> iProgressAwareTimer);
        } else if (EqDomain.class.getSimpleName().equals(string)) {
            explicitValueDomain = new EqDomain(symbolicTools, this.mPrefs.getInt("Max. Parallel Equality"), this.mServices, this.mLogger, () -> iProgressAwareTimer);
        } else {
            throw new IllegalArgumentException("Unknown domain setting: " + string);
        }
        return explicitValueDomain;
    }

    private IFluid constructStatsFluid(SifaStats sifaStats) {
        String string = this.mPrefs.getString("Fluid");
        return new StatsWrapperFluid(sifaStats, this.constructFluid(string));
    }

    private IFluid constructFluid(String string) {
        NeverFluid neverFluid;
        if (NeverFluid.class.getSimpleName().equals(string)) {
            neverFluid = new NeverFluid();
        } else if (SizeLimitFluid.class.getSimpleName().equals(string)) {
            neverFluid = new SizeLimitFluid(this.mPrefs.getInt("SizeLimitFluid Max. DAG Size"), this.mPrefs.getInt("SizeLimitFluid Max. Disjunctions"));
        } else if (AlwaysFluid.class.getSimpleName().equals(string)) {
            neverFluid = new AlwaysFluid();
        } else if (LogSizeWrapperFluid.class.getSimpleName().equals(string)) {
            String string2 = this.mPrefs.getString("LogSizeWrapperFluid Intern Fluid");
            neverFluid = new LogSizeWrapperFluid(this.mLogger, this.constructFluid(string2));
        } else {
            throw new IllegalArgumentException("Unknown fluid setting: " + string);
        }
        return neverFluid;
    }

    private Function<IcfgInterpreter, Function<DagInterpreter, ILoopSummarizer>> constructLoopSummarizer(SifaStats sifaStats, IProgressAwareTimer iProgressAwareTimer, SymbolicTools symbolicTools, IDomain iDomain, IFluid iFluid) {
        String string = this.mPrefs.getString("Loop Summarizer");
        if (FixpointLoopSummarizer.class.getSimpleName().equals(string)) {
            return icfgInterpreter -> dagInterpreter -> new FixpointLoopSummarizer(sifaStats, this.mLogger, () -> iProgressAwareTimer, symbolicTools, iDomain, iFluid, dagInterpreter);
        }
        throw new IllegalArgumentException("Unknown loop summarizer setting: " + string);
    }

    private Function<IcfgInterpreter, Function<DagInterpreter, ICallSummarizer>> constructCallSummarizer(SifaStats sifaStats, SymbolicTools symbolicTools, IDomain iDomain) {
        String string = this.mPrefs.getString("Call Summarizer");
        if (TopInputCallSummarizer.class.getSimpleName().equals(string)) {
            return icfgInterpreter -> dagInterpreter -> new TopInputCallSummarizer(sifaStats, symbolicTools, icfgInterpreter.procedureResourceCache(), dagInterpreter);
        }
        if (InterpretCallSummarizer.class.getSimpleName().equals(string)) {
            return SifaBuilder.constructIprCallSummarizer(sifaStats);
        }
        if (ReUseSupersetCallSummarizer.class.getSimpleName().equals(string)) {
            SifaStats sifaStats2 = new SifaStats();
            return icfgInterpreter -> dagInterpreter -> new ReUseSupersetCallSummarizer(sifaStats, symbolicTools, iDomain, SifaBuilder.constructIprCallSummarizer(sifaStats2).apply((IcfgInterpreter)icfgInterpreter).apply((DagInterpreter)dagInterpreter));
        }
        throw new IllegalArgumentException("Unknown call summarizer setting: " + string);
    }

    private static Function<IcfgInterpreter, Function<DagInterpreter, ICallSummarizer>> constructIprCallSummarizer(SifaStats sifaStats) {
        return icfgInterpreter -> dagInterpreter -> new InterpretCallSummarizer(sifaStats, icfgInterpreter.procedureResourceCache(), dagInterpreter);
    }

    public static class SifaComponents {
        private final IcfgInterpreter mIcfgInterpreter;
        private final IDomain mDomain;
        private final SifaStats mStats;

        public SifaComponents(IcfgInterpreter icfgInterpreter, IDomain iDomain, SifaStats sifaStats) {
            this.mIcfgInterpreter = icfgInterpreter;
            this.mDomain = iDomain;
            this.mStats = sifaStats;
        }

        public IcfgInterpreter getIcfgInterpreter() {
            return this.mIcfgInterpreter;
        }

        public IDomain getDomain() {
            return this.mDomain;
        }

        public SifaStats getStats() {
            return this.mStats;
        }
    }
}

