/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.boogie.CachingBoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.BoogiePreprocessorBacktranslator;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieTypeConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.type.StructExpanderUtil;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class StructExpander
extends CachingBoogieTransformer
implements IUnmanagedObserver {
    private final HashMap<BoogieType, BoogieType> mFlattenCache;
    private final HashMap<String, BoogieTypeConstructor> mStructTypes;
    private final BoogiePreprocessorBacktranslator mTranslator;

    protected StructExpander(BoogiePreprocessorBacktranslator boogiePreprocessorBacktranslator, ILogger iLogger) {
        this.mTranslator = boogiePreprocessorBacktranslator;
        this.mFlattenCache = new HashMap();
        this.mStructTypes = new HashMap();
    }

    private BoogieType flattenType(IBoogieType iBoogieType) {
        return StructExpanderUtil.flattenType((IBoogieType)iBoogieType, this.mFlattenCache, this.mStructTypes);
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public void finish() {
    }

    public boolean performedChanges() {
        return true;
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof Unit) {
            Unit unit = (Unit)iElement;
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            TypeDeclaration typeDeclaration = unit.getDeclarations();
            int n = ((Declaration[])typeDeclaration).length;
            int n2 = 0;
            while (n2 < n) {
                Declaration[] declarationArray;
                Declaration declaration = typeDeclaration[n2];
                Declaration[] declarationArray2 = declarationArray = this.expandDeclaration(declaration);
                int n3 = declarationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Declaration declaration2 = declarationArray2[n4];
                    this.mTranslator.addMapping((BoogieASTNode)declaration, (BoogieASTNode)declaration2);
                    arrayDeque.add(declaration2);
                    ++n4;
                }
                ++n2;
            }
            for (BoogieTypeConstructor boogieTypeConstructor : this.mStructTypes.values()) {
                String[] stringArray = new String[boogieTypeConstructor.getParamCount()];
                int n5 = 0;
                while (n5 < stringArray.length) {
                    stringArray[n5] = "$" + n5;
                    ++n5;
                }
                typeDeclaration = new TypeDeclaration(unit.getLocation(), new Attribute[0], boogieTypeConstructor.isFinite(), boogieTypeConstructor.getName(), stringArray);
                arrayDeque.addFirst(typeDeclaration);
            }
            unit.setDeclarations(arrayDeque.toArray(new Declaration[arrayDeque.size()]));
            return false;
        }
        return true;
    }

    protected VarList[] processVarLists(VarList[] varListArray) {
        ArrayList<VarList> arrayList = new ArrayList<VarList>();
        VarList[] varListArray2 = varListArray;
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray2[n2];
            VarList[] varListArray3 = this.expandVarList(varList);
            int n3 = varListArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                VarList varList2 = varListArray3[n4];
                arrayList.add(varList2);
                if (varList2 != varList) {
                    this.mTranslator.addMapping((BoogieASTNode)varList, (BoogieASTNode)varList2);
                }
                ++n4;
            }
            ++n2;
        }
        if (arrayList.equals(Arrays.asList(varListArray))) {
            return varListArray;
        }
        return arrayList.toArray(new VarList[arrayList.size()]);
    }

    protected VarList processVarList(VarList varList) {
        VarList[] varListArray = this.processVarLists(new VarList[]{varList});
        assert (varListArray.length == 1);
        return varListArray[0];
    }

    private VarList[] expandVarList(VarList varList) {
        IBoogieType iBoogieType = varList.getType().getBoogieType();
        BoogieType boogieType = this.flattenType(iBoogieType);
        if (boogieType instanceof BoogieStructType) {
            BoogieStructType boogieStructType = (BoogieStructType)boogieType;
            VarList[] varListArray = new VarList[varList.getIdentifiers().length * boogieStructType.getFieldCount()];
            int n = 0;
            String[] stringArray = varList.getIdentifiers();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                int n4 = 0;
                while (n4 < boogieStructType.getFieldCount()) {
                    varListArray[n] = new VarList(varList.getLocation(), new String[]{string + "." + boogieStructType.getFieldIds()[n4]}, boogieStructType.getFieldType(n4).toASTType(varList.getLocation()));
                    ++n;
                    ++n4;
                }
                ++n3;
            }
            return varListArray;
        }
        if (boogieType.equals((Object)iBoogieType)) {
            return new VarList[]{varList};
        }
        return new VarList[]{new VarList(varList.getLocation(), varList.getIdentifiers(), boogieType.toASTType(varList.getLocation()))};
    }

    protected Expression processExpression(Expression expression) {
        BinaryExpression binaryExpression;
        BinaryExpression.Operator operator;
        Expression expression2 = null;
        if (expression instanceof StructAccessExpression) {
            StructAccessExpression structAccessExpression = (StructAccessExpression)expression;
            Expression[] expressionArray = this.expandExpression(structAccessExpression.getStruct());
            BoogieStructType boogieStructType = (BoogieStructType)this.flattenType(structAccessExpression.getStruct().getType());
            String[] stringArray = boogieStructType.getFieldIds();
            assert (stringArray.length == expressionArray.length);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(structAccessExpression.getField())) {
                    expression2 = expressionArray[n];
                    ModelUtils.copyAnnotations((IElement)expression, (IElement)expression2);
                    return expression2;
                }
                ++n;
            }
            throw new RuntimeException("Field name not found in " + String.valueOf(expression));
        }
        if (expression instanceof BinaryExpression && ((operator = (binaryExpression = (BinaryExpression)expression).getOperator()) == BinaryExpression.Operator.COMPEQ || operator == BinaryExpression.Operator.COMPNEQ)) {
            Expression[] expressionArray = this.expandExpression(binaryExpression.getLeft());
            Expression[] expressionArray2 = this.expandExpression(binaryExpression.getRight());
            assert (expressionArray.length == expressionArray2.length && expressionArray.length > 0);
            BinaryExpression.Operator operator2 = operator == BinaryExpression.Operator.COMPEQ ? BinaryExpression.Operator.LOGICAND : BinaryExpression.Operator.LOGICOR;
            int n = expressionArray.length - 1;
            BinaryExpression binaryExpression2 = new BinaryExpression(expression.getLocation(), expression.getType(), operator, expressionArray[n], expressionArray2[n]);
            while (n-- > 0) {
                binaryExpression2 = new BinaryExpression(expression.getLocation(), expression.getType(), operator2, (Expression)new BinaryExpression(expression.getLocation(), expression.getType(), operator, expressionArray[n], expressionArray2[n]), (Expression)binaryExpression2);
            }
            expression2 = binaryExpression2;
        }
        if (expression2 == null) {
            binaryExpression = super.processExpression(expression);
            binaryExpression.setType((IBoogieType)this.flattenType(expression.getType()));
            return binaryExpression;
        }
        ModelUtils.copyAnnotations((IElement)expression, expression2);
        return expression2;
    }

    private Expression[] expandExpression(Expression expression) {
        if (expression instanceof StringLiteral) {
            return new Expression[]{expression};
        }
        if (expression.getType() == null) {
            throw new IllegalArgumentException("The expression " + BoogiePrettyPrinter.print((Expression)expression) + " has a null type!");
        }
        BoogieType boogieType = this.flattenType(expression.getType());
        if (!(boogieType instanceof BoogieStructType)) {
            return new Expression[]{this.processExpression(expression)};
        }
        BoogieStructType boogieStructType = (BoogieStructType)boogieType;
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            String string = identifierExpression.getIdentifier();
            Expression[] expressionArray = new Expression[boogieStructType.getFieldCount()];
            int n = 0;
            while (n < expressionArray.length) {
                String string2 = string + "." + boogieStructType.getFieldIds()[n];
                BoogieType boogieType2 = boogieStructType.getFieldType(n);
                expressionArray[n] = new IdentifierExpression(expression.getLocation(), (IBoogieType)boogieType2, string2, identifierExpression.getDeclarationInformation());
                ++n;
            }
            return expressionArray;
        }
        if (expression instanceof ArrayAccessExpression) {
            ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)expression;
            Expression[] expressionArray = this.expandExpression(arrayAccessExpression.getArray());
            Expression[] expressionArray2 = this.processExpressions(arrayAccessExpression.getIndices());
            Expression[] expressionArray3 = new Expression[expressionArray.length];
            assert (boogieStructType.getFieldCount() == expressionArray3.length);
            int n = 0;
            while (n < expressionArray3.length) {
                BoogieType boogieType3 = boogieStructType.getFieldType(n);
                expressionArray3[n] = new ArrayAccessExpression(arrayAccessExpression.getLocation(), (IBoogieType)boogieType3, expressionArray[n], expressionArray2);
                ++n;
            }
            return expressionArray3;
        }
        if (expression instanceof FunctionApplication) {
            FunctionApplication functionApplication = (FunctionApplication)expression;
            Expression[] expressionArray = this.processExpressions(functionApplication.getArguments());
            Expression[] expressionArray4 = new Expression[boogieStructType.getFieldCount()];
            int n = 0;
            while (n < expressionArray4.length) {
                String string = functionApplication.getIdentifier() + "." + boogieStructType.getFieldIds()[n];
                BoogieType boogieType4 = boogieStructType.getFieldType(n);
                expressionArray4[n] = new FunctionApplication(functionApplication.getLocation(), (IBoogieType)boogieType4, string, expressionArray);
                ++n;
            }
            return expressionArray4;
        }
        if (expression instanceof ArrayStoreExpression) {
            ArrayStoreExpression arrayStoreExpression = (ArrayStoreExpression)expression;
            Expression[] expressionArray = this.expandExpression(arrayStoreExpression.getArray());
            Expression[] expressionArray5 = this.processExpressions(arrayStoreExpression.getIndices());
            Expression[] expressionArray6 = this.expandExpression(arrayStoreExpression.getValue());
            Expression[] expressionArray7 = new Expression[expressionArray.length];
            assert (boogieStructType.getFieldCount() == expressionArray7.length);
            int n = 0;
            while (n < expressionArray7.length) {
                BoogieType boogieType5 = boogieStructType.getFieldType(n);
                expressionArray7[n] = new ArrayStoreExpression(arrayStoreExpression.getLocation(), (IBoogieType)boogieType5, expressionArray[n], expressionArray5, expressionArray6[n]);
                ++n;
            }
            return expressionArray7;
        }
        if (expression instanceof StructConstructor) {
            return this.processExpressions(((StructConstructor)expression).getFieldValues());
        }
        if (expression instanceof StructAccessExpression) {
            StructAccessExpression structAccessExpression = (StructAccessExpression)expression;
            Expression[] expressionArray = this.expandExpression(structAccessExpression.getStruct());
            BoogieStructType boogieStructType2 = (BoogieStructType)this.flattenType(structAccessExpression.getStruct().getType());
            String string = structAccessExpression.getField();
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            while (n3 < boogieStructType2.getFieldCount()) {
                if (boogieStructType2.getFieldIds()[n3].startsWith(string + ".")) {
                    if (n == -1) {
                        n = n3;
                    }
                    n2 = n3;
                }
                ++n3;
            }
            if (n == -1) {
                throw new RuntimeException("Field name not found in " + String.valueOf(expression));
            }
            Expression[] expressionArray8 = new Expression[n2 - n + 1];
            System.arraycopy(expressionArray, n, expressionArray8, 0, n2 - n + 1);
            return expressionArray8;
        }
        if (expression instanceof IfThenElseExpression) {
            IfThenElseExpression ifThenElseExpression = (IfThenElseExpression)expression;
            Expression expression2 = this.processExpression(ifThenElseExpression.getCondition());
            Expression[] expressionArray = this.expandExpression(ifThenElseExpression.getThenPart());
            Expression[] expressionArray9 = this.expandExpression(ifThenElseExpression.getElsePart());
            assert (expressionArray.length == expressionArray9.length);
            Expression[] expressionArray10 = new Expression[expressionArray.length];
            int n = 0;
            while (n < expressionArray10.length) {
                assert (expressionArray[n].getType().equals(expressionArray9[n].getType()));
                expressionArray10[n] = new IfThenElseExpression(ifThenElseExpression.getLocation(), expressionArray[n].getType(), expression2, expressionArray[n], expressionArray9[n]);
                ++n;
            }
            return expressionArray10;
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            assert (unaryExpression.getOperator() == UnaryExpression.Operator.OLD);
            Expression[] expressionArray = this.expandExpression(unaryExpression.getExpr());
            Expression[] expressionArray11 = new Expression[expressionArray.length];
            int n = 0;
            while (n < expressionArray11.length) {
                expressionArray11[n] = new UnaryExpression(expression.getLocation(), expressionArray[n].getType(), unaryExpression.getOperator(), expressionArray[n]);
                ++n;
            }
            return expressionArray11;
        }
        throw new AssertionError((Object)("Strange struct type expression " + String.valueOf(expression)));
    }

    protected Expression[] processExpressions(Expression[] expressionArray) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        Expression[] expressionArray2 = expressionArray;
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray2[n2];
            arrayList.addAll(Arrays.asList(this.expandExpression(expression)));
            ++n2;
        }
        return arrayList.toArray(new Expression[arrayList.size()]);
    }

    protected LeftHandSide processLeftHandSide(LeftHandSide leftHandSide) {
        if (leftHandSide instanceof StructLHS) {
            StructLHS structLHS = (StructLHS)leftHandSide;
            LeftHandSide[] leftHandSideArray = this.expandLeftHandSide(structLHS.getStruct());
            BoogieStructType boogieStructType = (BoogieStructType)this.flattenType(structLHS.getStruct().getType());
            int n = 0;
            while (n < boogieStructType.getFieldCount()) {
                if (boogieStructType.getFieldIds()[n].equals(structLHS.getField())) {
                    LeftHandSide leftHandSide2 = leftHandSideArray[n];
                    ModelUtils.copyAnnotations((IElement)leftHandSide, (IElement)leftHandSide2);
                    return leftHandSide2;
                }
                ++n;
            }
            throw new RuntimeException("Field name not found in " + String.valueOf(leftHandSide));
        }
        LeftHandSide leftHandSide3 = super.processLeftHandSide(leftHandSide);
        leftHandSide3.setType((IBoogieType)this.flattenType(leftHandSide.getType()));
        return leftHandSide3;
    }

    private LeftHandSide[] expandLeftHandSide(LeftHandSide leftHandSide) {
        if (leftHandSide.getType() == null) {
            throw new IllegalArgumentException("type of " + leftHandSide.toString() + " is null");
        }
        BoogieType boogieType = this.flattenType(leftHandSide.getType());
        if (!(boogieType instanceof BoogieStructType)) {
            return new LeftHandSide[]{this.processLeftHandSide(leftHandSide)};
        }
        BoogieStructType boogieStructType = (BoogieStructType)boogieType;
        if (leftHandSide instanceof VariableLHS) {
            VariableLHS variableLHS = (VariableLHS)leftHandSide;
            String string = variableLHS.getIdentifier();
            VariableLHS[] variableLHSArray = new VariableLHS[boogieStructType.getFieldCount()];
            int n = 0;
            while (n < variableLHSArray.length) {
                String string2 = string + "." + boogieStructType.getFieldIds()[n];
                BoogieType boogieType2 = boogieStructType.getFieldType(n);
                variableLHSArray[n] = new VariableLHS(leftHandSide.getLocation(), (IBoogieType)boogieType2, string2, variableLHS.getDeclarationInformation());
                ++n;
            }
            return variableLHSArray;
        }
        if (leftHandSide instanceof ArrayLHS) {
            ArrayLHS arrayLHS = (ArrayLHS)leftHandSide;
            LeftHandSide[] leftHandSideArray = this.expandLeftHandSide(arrayLHS.getArray());
            Expression[] expressionArray = this.processExpressions(arrayLHS.getIndices());
            LeftHandSide[] leftHandSideArray2 = new LeftHandSide[leftHandSideArray.length];
            int n = 0;
            while (n < leftHandSideArray2.length) {
                BoogieType boogieType3 = boogieStructType.getFieldType(n);
                leftHandSideArray2[n] = new ArrayLHS(arrayLHS.getLocation(), (IBoogieType)boogieType3, leftHandSideArray[n], expressionArray);
                ++n;
            }
            return leftHandSideArray2;
        }
        if (leftHandSide instanceof StructLHS) {
            StructLHS structLHS = (StructLHS)leftHandSide;
            LeftHandSide[] leftHandSideArray = this.expandLeftHandSide(structLHS.getStruct());
            BoogieStructType boogieStructType2 = (BoogieStructType)this.flattenType(structLHS.getStruct().getType());
            assert (boogieStructType2.getFieldCount() == leftHandSideArray.length);
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            while (n3 < boogieStructType2.getFieldCount()) {
                if (boogieStructType2.getFieldIds()[n3].startsWith(structLHS.getField() + ".")) {
                    if (n == -1) {
                        n = n3;
                    }
                    n2 = n3;
                }
                ++n3;
            }
            if (n == -1) {
                throw new RuntimeException("Field name not found in " + String.valueOf(leftHandSide));
            }
            LeftHandSide[] leftHandSideArray3 = new LeftHandSide[n2 - n + 1];
            System.arraycopy(leftHandSideArray, n, leftHandSideArray3, 0, n2 - n + 1);
            return leftHandSideArray3;
        }
        throw new AssertionError((Object)("Strange LHS " + String.valueOf(leftHandSide)));
    }

    protected LeftHandSide[] processLeftHandSides(LeftHandSide[] leftHandSideArray) {
        ArrayList<LeftHandSide> arrayList = new ArrayList<LeftHandSide>();
        LeftHandSide[] leftHandSideArray2 = leftHandSideArray;
        int n = leftHandSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            LeftHandSide leftHandSide = leftHandSideArray2[n2];
            arrayList.addAll(Arrays.asList(this.expandLeftHandSide(leftHandSide)));
            ++n2;
        }
        return arrayList.toArray(new LeftHandSide[arrayList.size()]);
    }

    private Declaration[] expandDeclaration(Declaration declaration) {
        if (declaration instanceof FunctionDeclaration) {
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)declaration;
            IBoogieType iBoogieType = functionDeclaration.getOutParam().getType().getBoogieType();
            BoogieType boogieType = this.flattenType(iBoogieType);
            if (!(boogieType instanceof BoogieStructType)) {
                StructExpander.processExpandStructAttribute(functionDeclaration, 0, null);
                return new Declaration[]{this.processDeclaration((Declaration)functionDeclaration)};
            }
            BoogieStructType boogieStructType = (BoogieStructType)boogieType;
            Declaration[] declarationArray = new Declaration[boogieStructType.getFieldCount()];
            Expression[] expressionArray = functionDeclaration.getBody() == null ? new Expression[boogieStructType.getFieldCount()] : this.expandExpression(functionDeclaration.getBody());
            VarList[] varListArray = this.processVarLists(functionDeclaration.getInParams());
            Attribute[][] attributeArray = StructExpander.processExpandStructAttribute(functionDeclaration, boogieStructType.getFieldCount(), boogieStructType);
            int n = 0;
            while (n < declarationArray.length) {
                ILocation iLocation = functionDeclaration.getOutParam().getLocation();
                VarList varList = new VarList(iLocation, functionDeclaration.getOutParam().getIdentifiers(), boogieStructType.getFieldType(n).toASTType(iLocation));
                assert (attributeArray[n] != null);
                declarationArray[n] = new FunctionDeclaration(functionDeclaration.getLocation(), attributeArray[n], functionDeclaration.getIdentifier() + "." + boogieStructType.getFieldIds()[n], functionDeclaration.getTypeParams(), varListArray, varList, expressionArray[n]);
                ++n;
            }
            return declarationArray;
        }
        if (declaration instanceof ConstDeclaration) {
            ConstDeclaration constDeclaration = (ConstDeclaration)declaration;
            VarList varList = constDeclaration.getVarList();
            VarList[] varListArray = this.expandVarList(varList);
            if (varListArray.length == 1 && varListArray[0] == varList) {
                return new Declaration[]{declaration};
            }
            Declaration[] declarationArray = new Declaration[varListArray.length];
            int n = 0;
            while (n < declarationArray.length) {
                declarationArray[n] = new ConstDeclaration(constDeclaration.getLocation(), constDeclaration.getAttributes(), constDeclaration.isUnique(), varListArray[n], constDeclaration.getParentInfo(), constDeclaration.isComplete());
                ++n;
            }
            return declarationArray;
        }
        if (declaration instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration;
            TypeDeclaration typeDeclaration2 = typeDeclaration = (TypeDeclaration)declaration;
            if (typeDeclaration.getSynonym() != null) {
                BoogieType boogieType = this.flattenType(typeDeclaration.getSynonym().getBoogieType());
                if (boogieType instanceof BoogieStructType) {
                    return new Declaration[0];
                }
                if (!boogieType.equals((Object)typeDeclaration.getSynonym().getBoogieType())) {
                    typeDeclaration2 = new TypeDeclaration(typeDeclaration.getLocation(), typeDeclaration.getAttributes(), typeDeclaration.isFinite(), typeDeclaration.getIdentifier(), typeDeclaration.getTypeParams(), boogieType.toASTType(typeDeclaration.getLocation()));
                }
            }
            return new Declaration[]{typeDeclaration2};
        }
        return new Declaration[]{this.processDeclaration(declaration)};
    }

    private static boolean isConstArray(Attribute attribute) {
        if (!(attribute instanceof NamedAttribute)) {
            return false;
        }
        NamedAttribute namedAttribute = (NamedAttribute)attribute;
        Expression[] expressionArray = namedAttribute.getValues();
        return namedAttribute.getName().equals("const_array") && expressionArray.length == 0;
    }

    private static Attribute[][] processExpandStructAttribute(FunctionDeclaration functionDeclaration, int n, BoogieStructType boogieStructType) {
        Attribute[] attributeArray = functionDeclaration.getAttributes();
        if (n < 0) {
            throw new IllegalArgumentException("negative field count");
        }
        if (attributeArray == null) {
            Attribute[][] attributeArray2 = new Attribute[n][0];
            int n2 = 0;
            while (n2 < n) {
                attributeArray2[n2] = null;
                ++n2;
            }
            return attributeArray2;
        }
        if (attributeArray.length == 0) {
            Attribute[][] attributeArray3 = new Attribute[n][0];
            int n3 = 0;
            while (n3 < n) {
                attributeArray3[n3] = new Attribute[0];
                ++n3;
            }
            return attributeArray3;
        }
        if (n == 0) {
            if (Arrays.stream(attributeArray).filter(attribute -> attribute instanceof NamedAttribute).map(attribute -> ((NamedAttribute)attribute).getName()).anyMatch(string -> string.equals("expand_struct"))) {
                throw new IllegalExpandStructUsageException(functionDeclaration.getIdentifier() + " has expand_struct attribute but no struct return type");
            }
            Attribute[][] attributeArrayArray = new Attribute[][]{functionDeclaration.getAttributes()};
            return attributeArrayArray;
        }
        Attribute[][] attributeArrayArray = new Attribute[n][];
        if (StructExpander.isConstArray(attributeArray[0])) {
            int n4 = 0;
            while (n4 < n) {
                ILocation iLocation = attributeArray[0].getLocation();
                attributeArrayArray[n4] = new Attribute[2];
                attributeArrayArray[n4][0] = attributeArray[0];
                attributeArrayArray[n4][1] = new NamedAttribute(iLocation, "structpos", new Expression[]{new StringLiteral(iLocation, Integer.toString(n4))});
                ++n4;
            }
            return attributeArrayArray;
        }
        int n5 = -1;
        int n6 = 0;
        while (n6 < attributeArray.length) {
            NamedAttribute namedAttribute;
            if (attributeArray[n6] instanceof NamedAttribute && "expand_struct".equals((namedAttribute = (NamedAttribute)attributeArray[n6]).getName())) {
                if (n5 != -1) {
                    StructExpander.fillNextAttributeSegment(functionDeclaration, boogieStructType, attributeArray, attributeArrayArray, n5, n6);
                } else if (n5 == -1 && n6 != 0) {
                    throw new IllegalExpandStructUsageException(functionDeclaration.getIdentifier() + " expand_struct attribute is not the first attribute; you will loose attributes");
                }
                n5 = n6;
            }
            ++n6;
        }
        StructExpander.fillNextAttributeSegment(functionDeclaration, boogieStructType, attributeArray, attributeArrayArray, n5, attributeArray.length);
        n6 = 0;
        while (n6 < attributeArrayArray.length) {
            if (attributeArrayArray[n6] == null) {
                attributeArrayArray[n6] = new Attribute[0];
            }
            ++n6;
        }
        return attributeArrayArray;
    }

    private static void fillNextAttributeSegment(FunctionDeclaration functionDeclaration, BoogieStructType boogieStructType, Attribute[] attributeArray, Attribute[][] attributeArray2, int n, int n2) {
        if (n == -1) {
            throw new IllegalExpandStructUsageException(functionDeclaration.getIdentifier() + " has no expand_struct attribute but struct return type");
        }
        Expression[] expressionArray = ((NamedAttribute)attributeArray[n]).getValues();
        if (expressionArray.length != 1) {
            throw new IllegalExpandStructUsageException(functionDeclaration.getIdentifier() + " has expand_struct attribute with wrong number of arguments: " + expressionArray.length);
        }
        Expression expression = expressionArray[0];
        if (!(expression instanceof StringLiteral)) {
            throw new IllegalExpandStructUsageException(functionDeclaration.getIdentifier() + " has expand_struct attribute but wrong attribute type");
        }
        String string = ((StringLiteral)expression).getValue();
        int n3 = Arrays.asList(boogieStructType.getFieldIds()).indexOf(string);
        if (n3 == -1) {
            throw new IllegalExpandStructUsageException(functionDeclaration.getIdentifier() + " has expand_struct attribute but field name " + string + " does not exist in flattened struct");
        }
        if (n3 >= attributeArray2.length) {
            throw new IllegalExpandStructUsageException(functionDeclaration.getIdentifier() + " has too many expand_struct attributes for its return type");
        }
        if (attributeArray2[n3] != null) {
            throw new IllegalExpandStructUsageException(functionDeclaration.getIdentifier() + " expand_struct attribute occurs twice");
        }
        int n4 = n2 - n - 1;
        Attribute[] attributeArray3 = new Attribute[n4];
        System.arraycopy(attributeArray, n + 1, attributeArray3, 0, n4);
        attributeArray2[n3] = attributeArray3;
    }

    protected Statement processStatement(Statement statement) {
        Statement statement2 = super.processStatement(statement);
        if (statement2 != statement) {
            this.mTranslator.addMapping((BoogieASTNode)statement, (BoogieASTNode)statement2);
        }
        return statement2;
    }

    private static final class IllegalExpandStructUsageException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public IllegalExpandStructUsageException(String string) {
            super(string);
        }
    }
}

