/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class BidirectionalMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = -7727684030243112324L;
    private final BidirectionalMap<V, K> mInverse;

    public BidirectionalMap() {
        this.mInverse = new BidirectionalMap(new HashMap(), this);
    }

    public BidirectionalMap(BidirectionalMap<K, V> bidirectionalMap) {
        super(bidirectionalMap);
        this.mInverse = new BidirectionalMap<K, V>(bidirectionalMap.mInverse, this);
    }

    private BidirectionalMap(HashMap<K, V> hashMap, BidirectionalMap<V, K> bidirectionalMap) {
        super(hashMap);
        this.mInverse = bidirectionalMap;
    }

    public BidirectionalMap<V, K> inverse() {
        return this.mInverse;
    }

    @Override
    public void clear() {
        this.clearAsymmetric();
        this.mInverse.clearAsymmetric();
    }

    private void clearAsymmetric() {
        super.clear();
    }

    @Override
    public boolean containsValue(Object object) {
        return this.mInverse.containsKey(object);
    }

    @Override
    public V put(K k, V v) {
        K k2 = this.mInverse.putAsymmetric(v, k);
        this.removeAsymmetric(k2);
        V v2 = this.putAsymmetric(k, v);
        this.mInverse.removeAsymmetric(v2);
        return v2;
    }

    public V putAsymmetric(K k, V v) {
        return super.put(k, v);
    }

    @Override
    public V remove(Object object) {
        V v = this.removeAsymmetric(object);
        this.mInverse.removeAsymmetric(v);
        return v;
    }

    public V removeAsymmetric(Object object) {
        return super.remove(object);
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Set<V> values() {
        return this.mInverse.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        V v = super.computeIfAbsent(k, function);
        if (v != null) {
            this.mInverse.putAsymmetric(v, k);
        }
        return v;
    }
}

