/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import de.uni_freiburg.informatik.ultimate.util.VMUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsAggregator;
import de.uni_freiburg.informatik.ultimate.util.statistics.TimeTracker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ChainingHoareTripleChecker
implements IHoareTripleChecker {
    private static final int LONG_CHECK_THRESHOLD_MS = 1000;
    private final List<IWrappedHoareTripleChecker> mHtcs;
    private final ILogger mLogger;
    private static final Predicate<IPredicate> SKIP_PRED = iPredicate -> false;
    private static final Predicate<IAction> SKIP_ACT = iAction -> false;

    private ChainingHoareTripleChecker(ILogger iLogger) {
        this(iLogger, Collections.emptyList());
    }

    private ChainingHoareTripleChecker(ILogger iLogger, List<IWrappedHoareTripleChecker> list) {
        this.mLogger = iLogger;
        this.mHtcs = list;
        DataStructureUtils.filteredCast(this.mHtcs.stream(), ReviewedProtectedHtc.class).forEach(reviewedProtectedHtc -> reviewedProtectedHtc.setLockRelease(this::releaseLock));
    }

    public void releaseLock() {
        this.mHtcs.stream().forEach(ManagedScript.ILockHolderWithVoluntaryLockRelease::releaseLock);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        for (IWrappedHoareTripleChecker iWrappedHoareTripleChecker : this.mHtcs) {
            IncrementalPlicationChecker.Validity validity = iWrappedHoareTripleChecker.checkInternal(iPredicate, iInternalAction, iPredicate2);
            iWrappedHoareTripleChecker.getUnderlying().reportLongChecks(iPredicate, iInternalAction, iPredicate2, validity);
            if (validity != IncrementalPlicationChecker.Validity.INVALID && validity != IncrementalPlicationChecker.Validity.VALID) continue;
            return validity;
        }
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        for (IWrappedHoareTripleChecker iWrappedHoareTripleChecker : this.mHtcs) {
            IncrementalPlicationChecker.Validity validity = iWrappedHoareTripleChecker.checkCall(iPredicate, iCallAction, iPredicate2);
            iWrappedHoareTripleChecker.getUnderlying().reportLongChecks(iPredicate, iCallAction, iPredicate2, validity);
            if (validity != IncrementalPlicationChecker.Validity.INVALID && validity != IncrementalPlicationChecker.Validity.VALID) continue;
            return validity;
        }
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        for (IWrappedHoareTripleChecker iWrappedHoareTripleChecker : this.mHtcs) {
            IncrementalPlicationChecker.Validity validity = iWrappedHoareTripleChecker.checkReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3);
            iWrappedHoareTripleChecker.getUnderlying().reportLongChecks(iPredicate, iPredicate2, iReturnAction, iPredicate3, validity);
            if (validity != IncrementalPlicationChecker.Validity.INVALID && validity != IncrementalPlicationChecker.Validity.VALID) continue;
            return validity;
        }
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        StatisticsAggregator statisticsAggregator = new StatisticsAggregator();
        for (IWrappedHoareTripleChecker iWrappedHoareTripleChecker : this.mHtcs) {
            statisticsAggregator.aggregateBenchmarkData(iWrappedHoareTripleChecker.getStatistics());
            ProtectedHtc protectedHtc = iWrappedHoareTripleChecker.getUnderlying();
            String string = protectedHtc.mHtc.getClass().getSimpleName();
            statisticsAggregator.aggregateBenchmarkData(string, (IStatisticsDataProvider)protectedHtc.mStats);
        }
        return statisticsAggregator;
    }

    public String toString() {
        return this.mHtcs.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    public static ChainingHoareTripleChecker with(ILogger iLogger, IHoareTripleChecker iHoareTripleChecker) {
        return new ChainingHoareTripleChecker(iLogger).andThen(iHoareTripleChecker);
    }

    public static ChainingHoareTripleChecker empty(ILogger iLogger) {
        return new ChainingHoareTripleChecker(iLogger);
    }

    public ChainingHoareTripleChecker andThen(IHoareTripleChecker iHoareTripleChecker) {
        if (iHoareTripleChecker instanceof ChainingHoareTripleChecker) {
            ChainingHoareTripleChecker chainingHoareTripleChecker = (ChainingHoareTripleChecker)iHoareTripleChecker;
            ChainingHoareTripleChecker chainingHoareTripleChecker2 = this;
            for (IWrappedHoareTripleChecker iWrappedHoareTripleChecker : chainingHoareTripleChecker.mHtcs) {
                chainingHoareTripleChecker2 = chainingHoareTripleChecker2.add(iWrappedHoareTripleChecker.copy());
            }
            return chainingHoareTripleChecker2;
        }
        return this.add(new ProtectedHtc(this.mLogger, iHoareTripleChecker, SKIP_ACT, SKIP_PRED));
    }

    public ChainingHoareTripleChecker predicatesProtectedBy(Predicate<IPredicate> predicate) {
        return this.replaceLast(this.createFromLastProtected(protectedHtc -> new ProtectedHtc(protectedHtc.mLogger, protectedHtc.mHtc, protectedHtc.mPredActionProtection, protectedHtc.mPredPredicateProtection.or(predicate))));
    }

    public ChainingHoareTripleChecker actionsProtectedBy(Predicate<IAction> predicate) {
        return this.replaceLast(this.createFromLastProtected(protectedHtc -> new ProtectedHtc(protectedHtc.mLogger, protectedHtc.mHtc, protectedHtc.mPredActionProtection.or(predicate), protectedHtc.mPredPredicateProtection)));
    }

    public ChainingHoareTripleChecker reviewWith(IHoareTripleChecker iHoareTripleChecker) {
        if (VMUtils.areAssertionsEnabled()) {
            return this.replaceLast(this.createFromLastReview(iHoareTripleChecker));
        }
        return this;
    }

    private ChainingHoareTripleChecker replaceLast(IWrappedHoareTripleChecker iWrappedHoareTripleChecker) {
        ArrayList<IWrappedHoareTripleChecker> arrayList = new ArrayList<IWrappedHoareTripleChecker>(this.mHtcs);
        arrayList.set(arrayList.size() - 1, iWrappedHoareTripleChecker);
        return new ChainingHoareTripleChecker(this.mLogger, arrayList);
    }

    private ChainingHoareTripleChecker add(IWrappedHoareTripleChecker iWrappedHoareTripleChecker) {
        ArrayList<IWrappedHoareTripleChecker> arrayList = new ArrayList<IWrappedHoareTripleChecker>(this.mHtcs.size() + 1);
        arrayList.addAll(this.mHtcs);
        arrayList.add(iWrappedHoareTripleChecker);
        return new ChainingHoareTripleChecker(this.mLogger, arrayList);
    }

    private IWrappedHoareTripleChecker getLast() {
        return this.mHtcs.get(this.mHtcs.size() - 1);
    }

    private IWrappedHoareTripleChecker createFromLastReview(IHoareTripleChecker iHoareTripleChecker) {
        ProtectedHtc protectedHtc = this.getLast().getUnderlying();
        return new ReviewedProtectedHtc(iHoareTripleChecker, new ProtectedHtc(protectedHtc.mLogger, protectedHtc.mHtc, protectedHtc.mPredActionProtection, protectedHtc.mPredPredicateProtection));
    }

    private IWrappedHoareTripleChecker createFromLastProtected(Function<ProtectedHtc, ProtectedHtc> function) {
        IWrappedHoareTripleChecker iWrappedHoareTripleChecker = this.getLast();
        return iWrappedHoareTripleChecker.replaceUnderlying(function.apply(iWrappedHoareTripleChecker.getUnderlying()));
    }

    private static interface IWrappedHoareTripleChecker
    extends IHoareTripleChecker {
        public ProtectedHtc getUnderlying();

        public IWrappedHoareTripleChecker replaceUnderlying(ProtectedHtc var1);

        public IWrappedHoareTripleChecker copy();
    }

    private static class ProtectedHtc
    implements IWrappedHoareTripleChecker {
        private final IHoareTripleChecker mHtc;
        private final Predicate<IPredicate> mPredPredicateProtection;
        private final Predicate<IAction> mPredActionProtection;
        private final ValidityInCaReCounter mStats;
        private final ILogger mLogger;

        public ProtectedHtc(ILogger iLogger, IHoareTripleChecker iHoareTripleChecker, Predicate<IAction> predicate, Predicate<IPredicate> predicate2) {
            this.mLogger = Objects.requireNonNull(iLogger);
            this.mHtc = Objects.requireNonNull(iHoareTripleChecker);
            this.mPredPredicateProtection = Objects.requireNonNull(predicate2);
            this.mPredActionProtection = Objects.requireNonNull(predicate);
            this.mStats = new ValidityInCaReCounter();
        }

        public ProtectedHtc(ProtectedHtc protectedHtc) {
            this(protectedHtc.mLogger, protectedHtc.mHtc, protectedHtc.mPredActionProtection, protectedHtc.mPredPredicateProtection);
        }

        public void releaseLock() {
            this.mHtc.releaseLock();
        }

        @Override
        public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
            this.mStats.start();
            IncrementalPlicationChecker.Validity validity = this.mPredPredicateProtection.test(iPredicate) || this.mPredPredicateProtection.test(iPredicate2) || this.mPredActionProtection.test(iInternalAction) ? IncrementalPlicationChecker.Validity.NOT_CHECKED : this.mHtc.checkInternal(iPredicate, iInternalAction, iPredicate2);
            this.mStats.stop();
            this.mStats.inc(validity, iInternalAction);
            return validity;
        }

        @Override
        public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
            this.mStats.start();
            IncrementalPlicationChecker.Validity validity = this.mPredPredicateProtection.test(iPredicate) || this.mPredPredicateProtection.test(iPredicate2) || this.mPredActionProtection.test(iCallAction) ? IncrementalPlicationChecker.Validity.NOT_CHECKED : this.mHtc.checkCall(iPredicate, iCallAction, iPredicate2);
            this.mStats.stop();
            this.mStats.inc(validity, iCallAction);
            return validity;
        }

        @Override
        public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
            this.mStats.start();
            IncrementalPlicationChecker.Validity validity = this.mPredPredicateProtection.test(iPredicate) || this.mPredPredicateProtection.test(iPredicate2) || this.mPredPredicateProtection.test(iPredicate3) || this.mPredActionProtection.test(iReturnAction) ? IncrementalPlicationChecker.Validity.NOT_CHECKED : this.mHtc.checkReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3);
            this.mStats.stop();
            this.mStats.inc(validity, iReturnAction);
            return validity;
        }

        @Override
        public IStatisticsDataProvider getStatistics() {
            return this.mHtc.getStatistics();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.mHtc.getClass().getSimpleName());
            stringBuilder.append(" [");
            stringBuilder.append((Object)this.mStats);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        @Override
        public ProtectedHtc getUnderlying() {
            return this;
        }

        @Override
        public IWrappedHoareTripleChecker replaceUnderlying(ProtectedHtc protectedHtc) {
            return protectedHtc;
        }

        public void reportLongChecks(IPredicate iPredicate, IAction iAction, IPredicate iPredicate2, IncrementalPlicationChecker.Validity validity) {
            this.reportLongChecks(iPredicate, null, iAction, iPredicate2, validity);
        }

        public void reportLongChecks(IPredicate iPredicate, IPredicate iPredicate2, IAction iAction, IPredicate iPredicate3, IncrementalPlicationChecker.Validity validity) {
            long l = this.mStats.mTime.lastDelta(TimeUnit.MILLISECONDS);
            if (l > 1000L) {
                TermClassifier termClassifier = new TermClassifier();
                termClassifier.checkTerm(iAction.getTransformula().getFormula());
                termClassifier.checkTerm(iPredicate.getFormula());
                termClassifier.checkTerm(iPredicate3.getFormula());
                if (iPredicate2 != null) {
                    termClassifier.checkTerm(iPredicate2.getFormula());
                }
                this.mLogger.warn("%s took %s for a HTC check with result %s. Formula has sorts %s, hasArrays=%s, hasNonlinArith=%s, quantifiers %s", new Object[]{this.mHtc.getClass().getSimpleName(), CoreUtil.humanReadableTime((long)l, (TimeUnit)TimeUnit.MILLISECONDS, (int)2), validity, termClassifier.getOccuringSortNames(), termClassifier.hasArrays(), termClassifier.hasNonlinearArithmetic(), termClassifier.getOccuringQuantifiers()});
            }
        }

        @Override
        public IWrappedHoareTripleChecker copy() {
            return new ProtectedHtc(this);
        }
    }

    private static class ReviewedProtectedHtc
    implements IWrappedHoareTripleChecker {
        private final IHoareTripleChecker mReviewHtc;
        private final ProtectedHtc mHtc;
        private ManagedScript.ILockHolderWithVoluntaryLockRelease mFunReleaseLocks;

        public ReviewedProtectedHtc(IHoareTripleChecker iHoareTripleChecker, ProtectedHtc protectedHtc) {
            this.mReviewHtc = Objects.requireNonNull(iHoareTripleChecker);
            this.mHtc = Objects.requireNonNull(protectedHtc);
        }

        private void setLockRelease(ManagedScript.ILockHolderWithVoluntaryLockRelease iLockHolderWithVoluntaryLockRelease) {
            this.mFunReleaseLocks = iLockHolderWithVoluntaryLockRelease;
        }

        public void releaseLock() {
            this.mHtc.releaseLock();
            this.mReviewHtc.releaseLock();
        }

        @Override
        public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
            IncrementalPlicationChecker.Validity validity = this.mHtc.checkInternal(iPredicate, iInternalAction, iPredicate2);
            if (validity == IncrementalPlicationChecker.Validity.NOT_CHECKED || validity == IncrementalPlicationChecker.Validity.UNKNOWN) {
                return validity;
            }
            assert (this.reviewInductiveInternal(iPredicate, iInternalAction, iPredicate2, validity));
            return validity;
        }

        @Override
        public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
            IncrementalPlicationChecker.Validity validity = this.mHtc.checkCall(iPredicate, iCallAction, iPredicate2);
            if (validity == IncrementalPlicationChecker.Validity.NOT_CHECKED || validity == IncrementalPlicationChecker.Validity.UNKNOWN) {
                return validity;
            }
            assert (this.reviewInductiveCall(iPredicate, iCallAction, iPredicate2, validity));
            return validity;
        }

        @Override
        public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
            IncrementalPlicationChecker.Validity validity = this.mHtc.checkReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3);
            if (validity == IncrementalPlicationChecker.Validity.NOT_CHECKED || validity == IncrementalPlicationChecker.Validity.UNKNOWN) {
                return validity;
            }
            assert (this.reviewInductiveReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3, validity));
            return validity;
        }

        private boolean reviewInductiveInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2, IncrementalPlicationChecker.Validity validity) {
            this.mFunReleaseLocks.releaseLock();
            IncrementalPlicationChecker.Validity validity2 = this.mReviewHtc.checkInternal(iPredicate, iInternalAction, iPredicate2);
            if (ReviewedProtectedHtc.reviewResult(validity, validity2)) {
                this.mReviewHtc.releaseLock();
                return true;
            }
            throw this.createAssertionError(validity, validity2);
        }

        private boolean reviewInductiveCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2, IncrementalPlicationChecker.Validity validity) {
            this.mFunReleaseLocks.releaseLock();
            IncrementalPlicationChecker.Validity validity2 = this.mReviewHtc.checkCall(iPredicate, iCallAction, iPredicate2);
            if (ReviewedProtectedHtc.reviewResult(validity, validity2)) {
                this.mReviewHtc.releaseLock();
                return true;
            }
            throw this.createAssertionError(validity, validity2);
        }

        private boolean reviewInductiveReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3, IncrementalPlicationChecker.Validity validity) {
            this.mFunReleaseLocks.releaseLock();
            IncrementalPlicationChecker.Validity validity2 = this.mReviewHtc.checkReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3);
            if (ReviewedProtectedHtc.reviewResult(validity, validity2)) {
                this.mReviewHtc.releaseLock();
                return true;
            }
            throw this.createAssertionError(validity, validity2);
        }

        private static boolean reviewResult(IncrementalPlicationChecker.Validity validity, IncrementalPlicationChecker.Validity validity2) {
            return switch (validity) {
                case IncrementalPlicationChecker.Validity.VALID -> {
                    if (validity2 != IncrementalPlicationChecker.Validity.VALID && validity2 != IncrementalPlicationChecker.Validity.UNKNOWN) {
                        yield false;
                    }
                    yield true;
                }
                case IncrementalPlicationChecker.Validity.INVALID -> {
                    if (validity2 != IncrementalPlicationChecker.Validity.INVALID && validity2 != IncrementalPlicationChecker.Validity.UNKNOWN) {
                        yield false;
                    }
                    yield true;
                }
                case IncrementalPlicationChecker.Validity.UNKNOWN, IncrementalPlicationChecker.Validity.NOT_CHECKED -> true;
                default -> throw new MatchException(null, null);
            };
        }

        private AssertionError createAssertionError(IncrementalPlicationChecker.Validity validity, IncrementalPlicationChecker.Validity validity2) {
            return new AssertionError((Object)String.format("HoareTripleChecker results differ between %s (result: %s) and %s (result: %s)", this.mHtc.mHtc.getClass().getSimpleName(), validity, this.mReviewHtc.getClass().getSimpleName(), validity2));
        }

        @Override
        public IStatisticsDataProvider getStatistics() {
            return this.mHtc.getStatistics();
        }

        public String toString() {
            return this.mHtc.toString();
        }

        @Override
        public ProtectedHtc getUnderlying() {
            return this.mHtc;
        }

        @Override
        public IWrappedHoareTripleChecker replaceUnderlying(ProtectedHtc protectedHtc) {
            return new ReviewedProtectedHtc(this.mReviewHtc, protectedHtc);
        }

        @Override
        public IWrappedHoareTripleChecker copy() {
            return new ReviewedProtectedHtc(this.mReviewHtc, new ProtectedHtc(this.mHtc.getUnderlying()));
        }
    }

    private static final class ValidityInCaReCounter
    extends AbstractStatisticsDataProvider {
        @ReflectionUtil.Reflected(prettyName="Valid")
        @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
        private final InCaReCounter mValid = new InCaReCounter();
        @ReflectionUtil.Reflected(prettyName="Invalid")
        @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
        private final InCaReCounter mInvalid = new InCaReCounter();
        @ReflectionUtil.Reflected(prettyName="Unknown")
        @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
        private final InCaReCounter mUnknown = new InCaReCounter();
        @ReflectionUtil.Reflected(prettyName="Unchecked")
        @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
        private final InCaReCounter mUnchecked = new InCaReCounter();
        @ReflectionUtil.Reflected(prettyName="Time")
        @StatisticsAggregator.Statistics(type=KeyType.TT_TIMER)
        private final TimeTracker mTime = new TimeTracker();
        @ReflectionUtil.Reflected(excluded=true)
        private static final Lazy<List<Field>> FIELDS = new Lazy(() -> ReflectionUtil.instanceFields(ValidityInCaReCounter.class).stream().filter(field -> field.getAnnotation(StatisticsAggregator.Statistics.class) != null).collect(Collectors.toList()));

        public ValidityInCaReCounter() {
            for (Field field : (List)FIELDS.get()) {
                StatisticsAggregator.Statistics statistics = field.getAnnotation(StatisticsAggregator.Statistics.class);
                this.declare(ReflectionUtil.fieldPrettyName((Field)field), () -> statistics.type().convert(ReflectionUtil.access((Object)((Object)this), (Field)field)), statistics.type());
            }
        }

        public void start() {
            this.mTime.start();
        }

        public void stop() {
            this.mTime.stop();
        }

        public void inc(IncrementalPlicationChecker.Validity validity, IAction iAction) {
            InCaReCounter inCaReCounter = switch (validity) {
                case IncrementalPlicationChecker.Validity.INVALID -> this.mInvalid;
                case IncrementalPlicationChecker.Validity.NOT_CHECKED -> this.mUnchecked;
                case IncrementalPlicationChecker.Validity.UNKNOWN -> this.mUnknown;
                case IncrementalPlicationChecker.Validity.VALID -> this.mValid;
                default -> throw new MatchException(null, null);
            };
            ValidityInCaReCounter.inc(iAction, inCaReCounter);
        }

        private static void inc(IAction iAction, InCaReCounter inCaReCounter) {
            if (iAction instanceof IInternalAction) {
                inCaReCounter.incIn();
            } else if (iAction instanceof ICallAction) {
                inCaReCounter.incCa();
            } else if (iAction instanceof IReturnAction) {
                inCaReCounter.incRe();
            } else {
                throw new UnsupportedOperationException("Unknown action " + String.valueOf(iAction.getClass()));
            }
        }

        public String toString() {
            return this.getBenchmarkType().prettyprintBenchmarkData((IStatisticsDataProvider)this);
        }
    }
}

