/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.MatrixBB;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LoopAccelerationMatrix<INLOC extends IcfgLocation> {
    private final MatrixBB mMatrix;
    private final int mMatrixSize;
    private final UnmodifiableTransFormula mOriginalTransFormula;
    private final ManagedScript mMgScript;
    private final ILogger mLogger;
    private List<Integer> mOpenV = new ArrayList<Integer>();

    public LoopAccelerationMatrix(ILogger iLogger, UnmodifiableTransFormula unmodifiableTransFormula, ManagedScript managedScript) {
        this.mLogger = iLogger;
        this.mMgScript = managedScript;
        this.mMgScript.lock((Object)this);
        this.mMgScript.push((Object)this, 1);
        this.mOriginalTransFormula = unmodifiableTransFormula;
        this.mMatrixSize = this.mOriginalTransFormula.getInVars().size();
        this.mMatrix = new MatrixBB(this.mOriginalTransFormula.getInVars(), iLogger);
        this.fillMatrix();
        this.mMgScript.pop((Object)this, 1);
        this.mMgScript.unlock((Object)this);
    }

    private void fillMatrix() {
        boolean bl = true;
        int n = this.mOriginalTransFormula.getInVars().size();
        int n2 = 0;
        while (n2 < n) {
            this.mOpenV.add(n2);
            ++n2;
        }
        if (!this.findInitVector()) {
            this.accelerationFailed();
        }
        while (bl && !this.mOpenV.isEmpty()) {
            bl = false;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            block2: for (int n3 : this.mOpenV) {
                HashMap<Integer, Map<Term, Term>> hashMap = new HashMap<Integer, Map<Term, Term>>(this.mMatrix.getMatrix());
                for (Map map : hashMap.values()) {
                    if (this.findVector(map, n3)) {
                        bl = true;
                        continue block2;
                    }
                    arrayList.add(n3);
                }
            }
            this.mOpenV = arrayList;
        }
        if (!this.find2nVector()) {
            this.accelerationFailed();
        }
    }

    private void findSolution(int n) {
        Script script = this.mMgScript.getScript();
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>(this.mMatrix.getMatrix().get(n));
        Term term = Substitution.apply((ManagedScript)this.mMgScript, hashMap, (Term)this.mOriginalTransFormula.getFormula());
        Term term2 = UnmodifiableTransFormula.computeClosedFormula((Term)term, (Map)this.mOriginalTransFormula.getInVars(), (Map)this.mOriginalTransFormula.getOutVars(), new HashSet(), (ManagedScript)this.mMgScript);
        script.push(1);
        try {
            Script.LBool lBool = LoopAccelerationMatrix.checkSat(script, term2);
            if (lBool == Script.LBool.SAT) {
                ArrayList arrayList = new ArrayList();
                this.mOriginalTransFormula.getOutVars().entrySet().forEach(entry -> {
                    boolean bl = arrayList.add(((IProgramVar)entry.getKey()).getPrimedConstant());
                });
                Map map = SmtUtils.getValues((Script)script, arrayList);
                HashMap<Term, Term> hashMap2 = new HashMap<Term, Term>();
                this.mOriginalTransFormula.getOutVars().entrySet().forEach(entry -> {
                    Term term = hashMap2.put((Term)entry.getValue(), (Term)map.get(((IProgramVar)entry.getKey()).getPrimedConstant()));
                });
                this.mMatrix.setSolution(hashMap2, n);
            }
        }
        finally {
            script.pop(1);
        }
    }

    private boolean find2nVector() {
        Map map;
        Term term;
        Script script = this.mMgScript.getScript();
        Term term2 = this.mOriginalTransFormula.getFormula();
        this.mOriginalTransFormula.getAuxVars();
        HashMap hashMap = new HashMap();
        this.mOriginalTransFormula.getOutVars().entrySet().forEach(entry -> {
            TermVariable termVariable = hashMap.put((IProgramVar)entry.getKey(), script.variable(((TermVariable)entry.getValue()).toString() + "_n", ((TermVariable)entry.getValue()).getSort()));
        });
        HashMap hashMap2 = new HashMap();
        this.mOriginalTransFormula.getOutVars().entrySet().forEach(entry -> {
            Term term = hashMap2.put((Term)entry.getValue(), (Term)hashMap.get(entry.getKey()));
        });
        this.mOriginalTransFormula.getInVars().entrySet().forEach(entry -> {
            Term term = hashMap2.put((Term)entry.getValue(), (Term)this.mOriginalTransFormula.getOutVars().get(entry.getKey()));
        });
        Term term3 = Substitution.apply((ManagedScript)this.mMgScript, hashMap2, (Term)this.mOriginalTransFormula.getFormula());
        Term term4 = script.term("and", new Term[]{term2, term3});
        Term term5 = UnmodifiableTransFormula.computeClosedFormula((Term)term4, (Map)this.mOriginalTransFormula.getInVars(), hashMap, new HashSet(), (ManagedScript)this.mMgScript);
        script.push(1);
        Script.LBool lBool = LoopAccelerationMatrix.checkSat(script, term5);
        try {
            if (lBool == Script.LBool.SAT) {
                term = new ArrayList();
                this.mOriginalTransFormula.getInVars().entrySet().forEach(entry -> {
                    boolean bl = term.add(((IProgramVar)entry.getKey()).getDefaultConstant());
                });
                map = SmtUtils.getValues((Script)script, term);
                this.mMatrix.setVector(this.termver2valueTrasformer(map), this.mMatrixSize + 1);
            }
        }
        finally {
            script.pop(1);
        }
        term = Substitution.apply((ManagedScript)this.mMgScript, this.mMatrix.getMatrix().get(this.mMatrixSize + 1), (Term)term4);
        map = UnmodifiableTransFormula.computeClosedFormula((Term)term, (Map)this.mOriginalTransFormula.getInVars(), hashMap, new HashSet(), (ManagedScript)this.mMgScript);
        script.push(1);
        try {
            Script.LBool lBool2 = LoopAccelerationMatrix.checkSat(script, (Term)map);
            if (lBool2 == Script.LBool.SAT) {
                ArrayList arrayList = new ArrayList();
                hashMap.entrySet().forEach(entry -> {
                    boolean bl = arrayList.add(((IProgramVar)entry.getKey()).getPrimedConstant());
                });
                Map map2 = SmtUtils.getValues((Script)script, arrayList);
                HashMap<Term, Term> hashMap3 = new HashMap<Term, Term>();
                this.mOriginalTransFormula.getOutVars().entrySet().forEach(entry -> {
                    Term term = hashMap3.put((Term)entry.getValue(), (Term)map2.get(((IProgramVar)entry.getKey()).getPrimedConstant()));
                });
                this.mMatrix.setSolution(hashMap3, this.mMatrixSize + 1);
            }
        }
        finally {
            script.pop(1);
        }
        return lBool == Script.LBool.SAT;
    }

    private boolean findVector(Map<Term, Term> map, int n) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>(map);
        Script script = this.mMgScript.getScript();
        Map.Entry entry = (Map.Entry)this.mOriginalTransFormula.getInVars().entrySet().stream().collect(Collectors.toList()).get(n);
        hashMap.put((Term)entry.getValue(), (Term)((IProgramVar)entry.getKey()).getDefaultConstant());
        Term term = Substitution.apply((ManagedScript)this.mMgScript, hashMap, (Term)this.mOriginalTransFormula.getFormula());
        term = script.term("and", new Term[]{term, script.term("distinct", new Term[]{((IProgramVar)entry.getKey()).getDefaultConstant(), map.get(entry.getValue())})});
        script.push(1);
        Script.LBool lBool = LoopAccelerationMatrix.checkSat(script, term);
        try {
            if (lBool == Script.LBool.SAT) {
                Map map2 = SmtUtils.getValues((Script)script, Collections.singleton(((IProgramVar)entry.getKey()).getDefaultConstant()));
                hashMap.put((Term)entry.getValue(), (Term)map2.values().iterator().next());
                this.mMatrix.setVector(hashMap, n);
                this.findSolution(n);
            }
        }
        finally {
            script.pop(1);
        }
        return lBool == Script.LBool.SAT;
    }

    private Map<Term, Term> termver2valueTrasformer(Map<Term, Term> map) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        this.mOriginalTransFormula.getInVars().entrySet().forEach(entry -> {
            Term term = hashMap.put((Term)entry.getValue(), (Term)map.get(((IProgramVar)entry.getKey()).getDefaultConstant()));
        });
        return hashMap;
    }

    private boolean findInitVector() {
        Script script = this.mMgScript.getScript();
        script.push(1);
        Script.LBool lBool = LoopAccelerationMatrix.checkSat(script, this.mOriginalTransFormula.getClosedFormula());
        try {
            if (lBool == Script.LBool.SAT) {
                ArrayList arrayList = new ArrayList();
                this.mOriginalTransFormula.getInVars().entrySet().forEach(entry -> {
                    boolean bl = arrayList.add(((IProgramVar)entry.getKey()).getDefaultConstant());
                });
                Map map = SmtUtils.getValues((Script)script, arrayList);
                this.mMatrix.setVector(this.termver2valueTrasformer(map), this.mMatrixSize);
                this.findSolution(this.mMatrixSize);
            }
        }
        finally {
            script.pop(1);
        }
        return lBool == Script.LBool.SAT;
    }

    private static Script.LBool checkSat(Script script, Term term) {
        TermVariable[] termVariableArray = term.getFreeVars();
        Term[] termArray = new Term[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            termArray[n] = LoopAccelerationMatrix.termVariable2constant(script, termVariableArray[n]);
            ++n;
        }
        Term term2 = script.let(termVariableArray, termArray, term);
        Script.LBool lBool = script.assertTerm(term2);
        if (lBool == Script.LBool.UNKNOWN) {
            lBool = script.checkSat();
        }
        return lBool;
    }

    private static Term termVariable2constant(Script script, TermVariable termVariable) {
        String string = termVariable.getName() + "_const_" + termVariable.hashCode();
        script.declareFun(string, Script.EMPTY_SORT_ARRAY, termVariable.getSort());
        return script.term(string, new Term[0]);
    }

    private void accelerationFailed() {
        this.mLogger.info((Object)"No acceleration found!");
    }

    public MatrixBB getResult() {
        return this.mMatrix;
    }
}

