/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRTermTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonCalculator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctMatrix;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FastUPRFormulaBuilder {
    private final FastUPRUtils mUtils;
    private final ManagedScript mManagedScript;
    private final Script mScript;
    private final OctagonCalculator mCalculator;
    private final OctagonTransformer mTransformer;
    private final FastUPRTermTransformer mTermTransformer;
    private final IUltimateServiceProvider mServices;

    public FastUPRFormulaBuilder(FastUPRUtils fastUPRUtils, ManagedScript managedScript, OctagonCalculator octagonCalculator, OctagonTransformer octagonTransformer, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mUtils = fastUPRUtils;
        this.mManagedScript = managedScript;
        this.mScript = managedScript.getScript();
        this.mCalculator = octagonCalculator;
        this.mTransformer = octagonTransformer;
        this.mServices = iUltimateServiceProvider;
        this.mTermTransformer = new FastUPRTermTransformer(this.mScript);
    }

    public UnmodifiableTransFormula buildTransFormula(Term term, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        Term term2 = this.mTermTransformer.transformToInt(term);
        Term term3 = SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)term2, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        ModifiableTransFormula modifiableTransFormula = new ModifiableTransFormula(term3);
        for (IProgramVar iProgramVar : map.keySet()) {
            modifiableTransFormula.addInVar(iProgramVar, map.get(iProgramVar));
        }
        for (IProgramVar iProgramVar : map2.keySet()) {
            modifiableTransFormula.addOutVar(iProgramVar, map2.get(iProgramVar));
        }
        return TransFormulaBuilder.constructCopy((ManagedScript)this.mManagedScript, (TransFormula)modifiableTransFormula, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap());
    }

    public Term buildConsistencyResult(OctConjunction octConjunction, int n, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        this.mUtils.output("Returning Consistency Result");
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n2 = 0;
        while (n2 <= n) {
            arrayList.add(this.mCalculator.sequentialize(octConjunction, map, map2, n2).toTerm(this.mScript));
            ++n2;
        }
        return arrayList.size() > 1 ? this.mScript.term("or", arrayList.toArray(new Term[0])) : (Term)arrayList.get(0);
    }

    public Term buildParametricResult(OctConjunction octConjunction, int n, ParametricOctMatrix parametricOctMatrix, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, List<TermVariable> list) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.mCalculator.sequentialize(octConjunction, map, map2, n2).toTerm(this.mScript));
            ++n2;
        }
        Term term = arrayList.size() > 1 ? this.mScript.term("or", arrayList.toArray(new Term[0])) : (Term)arrayList.get(0);
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        ParametricOctMatrix parametricOctMatrix2 = parametricOctMatrix.multiplyVar("k", this.mManagedScript);
        int n3 = 0;
        while (n3 < n) {
            arrayList2.add(this.getParametricSolutionRightSide(octConjunction, n, n3, parametricOctMatrix2, map, map2, list));
            ++n3;
        }
        Term term2 = arrayList2.size() > 1 ? this.mScript.term("or", arrayList2.toArray(new Term[0])) : (Term)arrayList2.get(0);
        Term term3 = this.mScript.quantifier(0, new TermVariable[]{parametricOctMatrix2.getParametricVar()}, this.mScript.term("and", new Term[]{this.mScript.term(">=", new Term[]{parametricOctMatrix2.getParametricVar(), this.mScript.decimal(BigDecimal.ZERO)}), term2}), (Term[][])new Term[0][]);
        Term term4 = this.mScript.term("or", new Term[]{term, term3});
        this.mUtils.output("Returning Parametric Result");
        return term4;
    }

    private Term getParametricSolutionRightSide(OctConjunction octConjunction, int n, int n2, ParametricOctMatrix parametricOctMatrix, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, List<TermVariable> list) {
        ParametricOctMatrix parametricOctMatrix2 = this.mTransformer.getMatrix(this.mCalculator.sequentialize(octConjunction, map, map2, n), list);
        ParametricOctMatrix parametricOctMatrix3 = parametricOctMatrix.add(parametricOctMatrix2);
        OctConjunction octConjunction2 = parametricOctMatrix3.toOctConjunction();
        OctConjunction octConjunction3 = this.mCalculator.binarySequentialize(octConjunction2, this.mCalculator.sequentialize(octConjunction, map, map2, n2), map, map2);
        return octConjunction3.toTerm(this.mScript);
    }

    public Term buildPeriodicityResult(OctConjunction octConjunction, ParametricOctMatrix parametricOctMatrix, int n, int n2, int n3, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, List<TermVariable> list) {
        Term term;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n4 = 0;
        while (n4 < n) {
            arrayList.add(this.mCalculator.sequentialize(octConjunction, map, map2, n4).toTerm(this.mScript));
            ++n4;
        }
        Term term2 = arrayList.size() > 1 ? this.mScript.term("or", arrayList.toArray(new Term[0])) : (Term)arrayList.get(0);
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        int n5 = 0;
        while (n5 < n3) {
            term = new ArrayList();
            int n6 = 0;
            while (n6 < n2) {
                term.add(this.getInnerOrTerm(octConjunction, n, n6, n5, parametricOctMatrix, map, map2, list));
                ++n6;
            }
            Term term3 = term.size() > 1 ? this.mScript.term("or", term.toArray(new Term[0])) : (Term)term.get(0);
            arrayList2.add(term3);
            ++n5;
        }
        Term term4 = arrayList2.size() > 1 ? this.mScript.term("or", arrayList2.toArray(new Term[0])) : (Term)arrayList2.get(0);
        term = this.mScript.term("or", new Term[]{term2, term4});
        this.mUtils.output("Returning Periodicity Result");
        return term;
    }

    private Term getInnerOrTerm(OctConjunction octConjunction, int n, int n2, int n3, ParametricOctMatrix parametricOctMatrix, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, List<TermVariable> list) {
        ParametricOctMatrix parametricOctMatrix2 = this.mTransformer.getMatrix(this.mCalculator.sequentialize(octConjunction, map, map2, n), list);
        ParametricOctMatrix parametricOctMatrix3 = parametricOctMatrix.multiplyConstant(new BigDecimal(n3));
        ParametricOctMatrix parametricOctMatrix4 = parametricOctMatrix3.add(parametricOctMatrix2);
        OctConjunction octConjunction2 = parametricOctMatrix4.toOctConjunction();
        OctConjunction octConjunction3 = this.mCalculator.binarySequentialize(octConjunction2, this.mCalculator.sequentialize(octConjunction, map, map2, n2), map, map2);
        return octConjunction3.toTerm(this.mScript);
    }

    private Term getIdentityRelation(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        TermVariable termVariable;
        TermVariable termVariable2;
        IProgramVar iProgramVar2;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IProgramVar iProgramVar2 : map.keySet()) {
            termVariable2 = map.get(iProgramVar2);
            if (map2.containsKey(iProgramVar2)) {
                termVariable = map2.get(iProgramVar2);
            } else {
                termVariable = this.mManagedScript.constructFreshTermVariable(termVariable2.getName() + "_out", termVariable2.getSort());
                map2.put(iProgramVar2, termVariable);
            }
            arrayList.add(this.mScript.term("=", new Term[]{termVariable2, termVariable}));
        }
        for (IProgramVar iProgramVar2 : map2.keySet()) {
            if (map.containsKey(iProgramVar2)) continue;
            termVariable2 = map2.get(iProgramVar2);
            termVariable = this.mManagedScript.constructFreshTermVariable(termVariable2.getName() + "_in", termVariable2.getSort());
            map.put(iProgramVar2, termVariable);
            arrayList.add(this.mScript.term("=", new Term[]{termVariable, termVariable2}));
        }
        if (arrayList.isEmpty()) {
            return this.mScript.term("true", new Term[0]);
        }
        if (arrayList.size() == 1) {
            return (Term)arrayList.get(0);
        }
        iProgramVar2 = this.mScript.term("and", arrayList.toArray(new Term[0]));
        return iProgramVar2;
    }

    public Term getExitEdgeResult(UnmodifiableTransFormula unmodifiableTransFormula, Term term, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        Term term2 = this.getIdentityRelation(map, map2);
        Term term3 = this.mScript.term("or", new Term[]{term2, term});
        Term term4 = this.buldExitRelation(map, map2, unmodifiableTransFormula);
        return this.mScript.term("and", new Term[]{term3, term4});
    }

    private Term buldExitRelation(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, UnmodifiableTransFormula unmodifiableTransFormula) {
        Term term = unmodifiableTransFormula.getFormula();
        for (Map.Entry entry : unmodifiableTransFormula.getInVars().entrySet()) {
            TermVariable termVariable = map2.get(entry.getKey());
            term = this.mTermTransformer.replaceVar(term, (TermVariable)entry.getValue(), termVariable);
        }
        return term;
    }
}

