/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractionBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrVectorSpaceBasisConstructor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QvasrAbstractor {
    public static QvasrAbstraction computeAbstraction(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula) {
        if (!SmtUtils.isArrayFree((Term)unmodifiableTransFormula.getFormula()) || !SmtUtils.containsArrayVariables((Term[])new Term[]{unmodifiableTransFormula.getFormula()})) {
            throw new UnsupportedOperationException("Cannot deal with arrays.");
        }
        Map<TermVariable, Term> map = QvasrAbstractor.getUpdates(iUltimateServiceProvider, managedScript, unmodifiableTransFormula, BaseType.ADDITIONS);
        Map<TermVariable, Term> map2 = QvasrAbstractor.getUpdates(iUltimateServiceProvider, managedScript, unmodifiableTransFormula, BaseType.RESETS);
        Term[][] termArray = QvasrAbstractor.constructBaseMatrix(managedScript, map2, unmodifiableTransFormula);
        Term[][] termArray2 = QvasrAbstractor.constructBaseMatrix(managedScript, map, unmodifiableTransFormula);
        Term[][] termArray3 = QvasrAbstractor.gaussianSolve(managedScript, termArray2);
        Term[][] termArray4 = QvasrAbstractor.gaussianSolve(managedScript, termArray);
        Rational[][] rationalArray = QvasrVectorSpaceBasisConstructor.computeVectorSpaceBasis(managedScript, termArray4);
        Rational[][] rationalArray2 = QvasrVectorSpaceBasisConstructor.computeVectorSpaceBasis(managedScript, termArray3);
        return QvasrAbstractionBuilder.constructQvasrAbstraction(rationalArray, rationalArray2);
    }

    public static Term[][] gaussianSolve(ManagedScript managedScript, Term[][] termArray) {
        Term[][] termArray2 = QvasrAbstractor.gaussPartialPivot(managedScript, termArray);
        Term[][] termArray3 = QvasrAbstractor.removeZeroRows(managedScript, termArray2);
        termArray3 = QvasrAbstractor.removeDuplicateRows(managedScript, termArray3);
        termArray3 = QvasrAbstractor.gaussRowEchelonFormJordan(managedScript, termArray3);
        termArray3 = QvasrAbstractor.removeZeroRows(managedScript, termArray3);
        return termArray3;
    }

    private static Term[][] gaussPartialPivot(ManagedScript managedScript, Term[][] termArray) {
        int n = 0;
        while (n < termArray.length - 1) {
            int n2 = -1;
            if (n + 1 < termArray.length && n + 1 < termArray[0].length) {
                n2 = QvasrAbstractor.findPivot(managedScript, termArray, n);
            }
            if (n2 == -1) {
                return termArray;
            }
            if (n2 != 0) {
                termArray = QvasrAbstractor.swap(termArray, n, n2);
            }
            Term term = termArray[n][n];
            int n3 = n + 1;
            while (n3 < termArray.length) {
                Term term2 = termArray[n3][n];
                termArray[n3][n] = managedScript.getScript().decimal("0");
                Term term3 = QvasrAbstractor.simplifyRealDivision(managedScript, term2, term);
                int n4 = n + 1;
                while (n4 < termArray[0].length) {
                    Term term4;
                    Term term5 = termArray[n][n4];
                    Term term6 = termArray[n3][n4];
                    Term term7 = QvasrAbstractor.simplifyRealMultiplication(managedScript, term3, term5);
                    termArray[n3][n4] = term4 = QvasrAbstractor.simplifyRealSubtraction(managedScript, term6, term7);
                    ++n4;
                }
                ++n3;
            }
            ++n;
        }
        return termArray;
    }

    private static Term[][] gaussRowEchelonFormJordan(ManagedScript managedScript, Term[][] termArray) {
        int n = termArray.length - 1;
        while (n >= 0) {
            int n2 = 0;
            while (n2 < termArray[0].length) {
                if (!QvasrUtils.checkTermEquiv(managedScript, termArray[n][n2], managedScript.getScript().decimal("0"))) {
                    Term term;
                    Term term2 = QvasrAbstractor.getDivisionInverse(managedScript, termArray[n][n2]);
                    int n3 = n2;
                    while (n3 < termArray[0].length) {
                        Term term3;
                        term = termArray[n][n3];
                        termArray[n][n3] = term3 = QvasrAbstractor.simplifyRealMultiplication(managedScript, term, term2);
                        ++n3;
                    }
                    n3 = n - 1;
                    while (n3 >= 0) {
                        term = termArray[n3][n2];
                        int n4 = n2;
                        while (n4 < termArray[0].length) {
                            Term term4;
                            Term term5 = termArray[n][n4];
                            Term term6 = termArray[n3][n4];
                            Term term7 = QvasrAbstractor.simplifyRealMultiplication(managedScript, term, term5);
                            termArray[n3][n4] = term4 = QvasrAbstractor.simplifyRealSubtraction(managedScript, term6, term7);
                            ++n4;
                        }
                        --n3;
                    }
                    break;
                }
                ++n2;
            }
            --n;
        }
        return termArray;
    }

    public static Term getDivisionInverse(ManagedScript managedScript, Term term) {
        Term term2;
        if (QvasrUtils.isApplicationTerm(term) && "/".equals(((ApplicationTerm)term).getFunction().getName())) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            Term term3 = applicationTerm.getParameters()[0];
            Term term4 = applicationTerm.getParameters()[1];
            term2 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{term4, term3});
        } else {
            term2 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{managedScript.getScript().decimal("1"), term});
        }
        return term2;
    }

    private static Term[][] removeZeroRows(ManagedScript managedScript, Term[][] termArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        while (n < termArray.length) {
            int n2 = 0;
            while (n2 < termArray[0].length) {
                if (!QvasrUtils.checkTermEquiv(managedScript, termArray[n][n2], managedScript.getScript().decimal("0"))) break;
                if (n2 == termArray[0].length - 1) {
                    hashSet.add(n);
                }
                ++n2;
            }
            ++n;
        }
        n = termArray.length - hashSet.size();
        if (n > 0) {
            Term[][] termArray2 = new Term[n][termArray[0].length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < termArray.length) {
                if (!hashSet.contains(n4)) {
                    int n5 = 0;
                    while (n5 < termArray[0].length) {
                        termArray2[n3][n5] = termArray[n4][n5];
                        ++n5;
                    }
                    ++n3;
                }
                ++n4;
            }
            return termArray2;
        }
        return termArray;
    }

    /*
     * WARNING - void declaration
     */
    private static Term[][] removeDuplicateRows(ManagedScript managedScript, Term[][] termArray) {
        int n;
        Term[][] termArray2;
        HashSet hashSet = new HashSet();
        int n2 = 0;
        while (n2 < termArray.length) {
            termArray2 = new HashSet();
            n = n2 + 1;
            while (n < termArray.length) {
                if (QvasrUtils.checkTermEquiv(managedScript, termArray[n2][0], termArray[n][0])) {
                    termArray2.add(n);
                }
                HashSet hashSet2 = new HashSet(termArray2);
                for (Integer n3 : termArray2) {
                    int n4 = 0;
                    while (n4 < termArray[0].length) {
                        if (!QvasrUtils.checkTermEquiv(managedScript, termArray[n3][n4], termArray[n2][n4])) {
                            hashSet2.remove(n3);
                        }
                        ++n4;
                    }
                }
                hashSet.addAll(hashSet2);
                ++n;
            }
            ++n2;
        }
        n2 = termArray.length - hashSet.size();
        if (n2 > 0) {
            termArray2 = new Term[n2][termArray[0].length];
            n = 0;
            int n5 = 0;
            while (n5 < termArray.length) {
                if (!hashSet.contains(n5)) {
                    void var7_10;
                    boolean n6 = false;
                    while (var7_10 < termArray[0].length) {
                        termArray2[n][var7_10] = termArray[n5][var7_10];
                        ++var7_10;
                    }
                    ++n;
                }
                ++n5;
            }
            return termArray2;
        }
        return termArray;
    }

    private static Term factorOutRealSum(ManagedScript managedScript, Term term) {
        if (QvasrUtils.isApplicationTerm(term)) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            List<Term> list = QvasrAbstractor.getApplicationTermSumParams(applicationTerm);
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (Term term2 : list) {
                Term term3;
                if (!QvasrUtils.isApplicationTerm(term2) || !"+".equals(((ApplicationTerm)term2).getFunction().getName())) continue;
                List<Term> list2 = QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, term2);
                Term term4 = managedScript.getScript().decimal(Integer.toString(Collections.frequency(list2, term2)) + "1");
                int n = 1;
                Term term5 = term2;
                Term term6 = term2;
                Iterator<Term> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    term5 = term3 = iterator.next();
                    if (n > 1) continue;
                    n = Collections.frequency(list, term3) + 1;
                    term6 = term3;
                }
                term3 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term4, term6, SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{managedScript.getScript().decimal(Integer.toString(n)), term5})});
                arrayList.add(term3);
            }
            return SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])arrayList.toArray(new Term[arrayList.size()]));
        }
        return term;
    }

    /*
     * WARNING - void declaration
     */
    public static Term expandRealMultiplication(ManagedScript managedScript, Term term, Term term2) {
        Term term3;
        ApplicationTerm applicationTerm2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (QvasrUtils.isApplicationTerm(term) && QvasrUtils.isApplicationTerm(term2)) {
            Term term4;
            int n;
            applicationTerm2 = (ApplicationTerm)term;
            ApplicationTerm applicationTerm3 = (ApplicationTerm)term2;
            if ("+".equals(applicationTerm2.getFunction().getName())) {
                void var8_19;
                term3 = applicationTerm2.getParameters();
                n = ((Term[])term3).length;
                boolean bl = false;
                while (var8_19 < n) {
                    term4 = term3[var8_19];
                    if (QvasrUtils.isApplicationTerm(term4)) {
                        arrayList.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)term4));
                    } else {
                        arrayList.add(term4);
                    }
                    ++var8_19;
                }
            } else {
                arrayList.add(applicationTerm2);
            }
            if ("+".equals(applicationTerm3.getFunction().getName())) {
                void var8_21;
                term3 = applicationTerm3.getParameters();
                n = ((Term[])term3).length;
                boolean bl = false;
                while (var8_21 < n) {
                    term4 = term3[var8_21];
                    if (QvasrUtils.isApplicationTerm(term4)) {
                        arrayList2.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)term4));
                    } else {
                        arrayList2.add(term4);
                    }
                    ++var8_21;
                }
            } else {
                arrayList2.add(applicationTerm3);
            }
        }
        if (!QvasrUtils.isApplicationTerm(term) && QvasrUtils.isApplicationTerm(term2)) {
            applicationTerm2 = (ApplicationTerm)term2;
            arrayList.add(term);
            if ("+".equals(applicationTerm2.getFunction().getName())) {
                Term[] termArray = applicationTerm2.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term5 = termArray[n2];
                    if (QvasrUtils.isApplicationTerm(term5)) {
                        arrayList2.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)term5));
                    } else {
                        arrayList2.add(term5);
                    }
                    ++n2;
                }
            } else {
                arrayList2.add(applicationTerm2);
            }
        }
        if (QvasrUtils.isApplicationTerm(term) && !QvasrUtils.isApplicationTerm(term2)) {
            applicationTerm2 = (ApplicationTerm)term;
            arrayList2.add(term2);
            if ("+".equals(applicationTerm2.getFunction().getName())) {
                Term[] termArray = applicationTerm2.getParameters();
                int n = termArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Term term6 = termArray[n3];
                    if (QvasrUtils.isApplicationTerm(term6)) {
                        arrayList.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)term6));
                    } else {
                        arrayList.add(term6);
                    }
                    ++n3;
                }
            } else {
                arrayList.add(applicationTerm2);
            }
        }
        if (!QvasrUtils.isApplicationTerm(term) && !QvasrUtils.isApplicationTerm(term2)) {
            arrayList.add(term);
            arrayList2.add(term2);
        }
        applicationTerm2 = managedScript.getScript().decimal("0");
        for (Term term7 : arrayList) {
            for (Term term8 : arrayList2) {
                term3 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term7, term8});
                applicationTerm2 = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{applicationTerm2, term3});
            }
        }
        return applicationTerm2;
    }

    public static Term expandRealMultiplication(ManagedScript managedScript, List<Term> list) {
        if (list.size() < 2) {
            return list.get(0);
        }
        Term term = managedScript.getScript().decimal("0");
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>(list);
        while (!arrayDeque.isEmpty()) {
            Term term2 = (Term)arrayDeque.pop();
            for (Term term3 : arrayDeque) {
                int n;
                Term term4;
                ApplicationTerm applicationTerm;
                ApplicationTerm applicationTerm2;
                if (QvasrUtils.isApplicationTerm(term2)) {
                    applicationTerm2 = (ApplicationTerm)term2;
                    if (QvasrUtils.isApplicationTerm(term3)) {
                        applicationTerm = (ApplicationTerm)term3;
                        term4 = applicationTerm2.getParameters();
                        int n2 = ((Term[])term4).length;
                        n = 0;
                        while (n < n2) {
                            Term term5 = term4[n];
                            Term[] termArray = applicationTerm.getParameters();
                            int n3 = termArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Term term6 = termArray[n4];
                                Term term7 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term5, term6});
                                term = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{term, term7});
                                ++n4;
                            }
                            ++n;
                        }
                        continue;
                    }
                    Term[] termArray = applicationTerm2.getParameters();
                    n = termArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        applicationTerm = termArray[n5];
                        term4 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{applicationTerm, term3});
                        term = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{term, term4});
                        ++n5;
                    }
                    continue;
                }
                if (QvasrUtils.isApplicationTerm(term3)) {
                    applicationTerm2 = (ApplicationTerm)term3;
                    Term[] termArray = applicationTerm2.getParameters();
                    n = termArray.length;
                    int n6 = 0;
                    while (n6 < n) {
                        applicationTerm = termArray[n6];
                        term4 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{applicationTerm, term2});
                        term = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{term, term4});
                        ++n6;
                    }
                    continue;
                }
                applicationTerm2 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term2, term3});
                term = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{term, applicationTerm2});
            }
        }
        return term;
    }

    public static Term simplifyRealDivision(ManagedScript managedScript, Term term, Term term2) {
        Pair<Term, Term> pair;
        Term term3;
        Term term4;
        Pair<Term, Term> pair2;
        Term term5;
        Term term6 = managedScript.getScript().decimal("0");
        if (QvasrUtils.checkTermEquiv(managedScript, term2, term6)) {
            throw new UnsupportedOperationException("cannot divide by 0!");
        }
        if (QvasrUtils.checkTermEquiv(managedScript, term2, managedScript.getScript().decimal("1"))) {
            return term;
        }
        if (QvasrUtils.checkTermEquiv(managedScript, term, term6)) {
            return term6;
        }
        Term term7 = managedScript.getScript().decimal("1");
        if (QvasrUtils.checkTermEquiv(managedScript, term, term2)) {
            return term7;
        }
        Term term8 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{term, term2});
        if (QvasrUtils.isApplicationTerm(term) && QvasrUtils.isApplicationTerm(term2)) {
            Pair<Term, Term> pair3;
            term5 = term;
            pair2 = (Pair<Term, Term>)term2;
            term4 = term7;
            Term term9 = term7;
            if ("/".equals(term5.getFunction().getName())) {
                term3 = term5.getParameters()[0];
                term4 = term5.getParameters()[1];
            } else {
                term3 = term5;
            }
            if ("/".equals(pair2.getFunction().getName())) {
                pair = pair2.getParameters()[0];
                term9 = pair2.getParameters()[1];
            } else {
                pair = pair2;
            }
            if ("/".equals(pair2.getFunction().getName()) || "/".equals(term5.getFunction().getName())) {
                pair3 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term3, term9});
                Term term10 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term4, pair});
                Pair<Term, Term> pair4 = QvasrAbstractor.reduceRealDivision(managedScript, pair3, term10);
                term8 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{(Term)pair4.getFirst(), (Term)pair4.getSecond()});
            }
            if (!"/".equals(pair2.getFunction().getName()) && !"/".equals(term5.getFunction().getName())) {
                pair3 = QvasrAbstractor.reduceRealDivision(managedScript, term, term2);
                term8 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{(Term)pair3.getFirst(), (Term)pair3.getSecond()});
            }
        }
        if (QvasrUtils.isApplicationTerm(term) && !QvasrUtils.isApplicationTerm(term2)) {
            term5 = (ApplicationTerm)term;
            if ("/".equals(term5.getFunction().getName())) {
                term3 = term5.getParameters()[0];
                term4 = term5.getParameters()[1];
                pair = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term4, term2});
                pair2 = QvasrAbstractor.reduceRealDivision(managedScript, term3, (Term)pair);
                term8 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{(Term)pair2.getFirst(), (Term)pair2.getSecond()});
            } else {
                pair2 = QvasrAbstractor.reduceRealDivision(managedScript, term, term2);
                term8 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{(Term)pair2.getFirst(), (Term)pair2.getSecond()});
            }
        }
        if (!QvasrUtils.isApplicationTerm(term) && QvasrUtils.isApplicationTerm(term2)) {
            term5 = (ApplicationTerm)term2;
            if ("/".equals(term5.getFunction().getName())) {
                term3 = term5.getParameters()[0];
                term4 = term5.getParameters()[1];
                pair = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term, term4});
                pair2 = QvasrAbstractor.reduceRealDivision(managedScript, pair, term3);
                term8 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{(Term)pair2.getFirst(), (Term)pair2.getSecond()});
            } else {
                pair2 = QvasrAbstractor.reduceRealDivision(managedScript, term, term2);
                term8 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{(Term)pair2.getFirst(), (Term)pair2.getSecond()});
            }
        }
        if (!QvasrUtils.isApplicationTerm(term) && !QvasrUtils.isApplicationTerm(term2)) {
            term5 = QvasrAbstractor.reduceRealDivision(managedScript, term, term2);
            term8 = SmtUtils.divReal((Script)managedScript.getScript(), (Term[])new Term[]{(Term)term5.getFirst(), (Term)term5.getSecond()});
        }
        return term8;
    }

    public static Term simplifyRealMultiplication(ManagedScript managedScript, Term term, Term term2) {
        ApplicationTerm applicationTerm;
        ApplicationTerm applicationTerm2;
        Term term3 = managedScript.getScript().decimal("0");
        if (QvasrUtils.checkTermEquiv(managedScript, term, term3) || QvasrUtils.checkTermEquiv(managedScript, term2, term3)) {
            return term3;
        }
        Term term4 = managedScript.getScript().decimal("1");
        if (QvasrUtils.checkTermEquiv(managedScript, term, term4)) {
            return term2;
        }
        if (QvasrUtils.checkTermEquiv(managedScript, term2, term4)) {
            return term;
        }
        Term term5 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term, term2});
        if (QvasrUtils.isApplicationTerm(term) && QvasrUtils.isApplicationTerm(term2)) {
            Term term6;
            applicationTerm2 = (ApplicationTerm)term;
            applicationTerm = (ApplicationTerm)term2;
            if ("/".equals(applicationTerm2.getFunction().getName()) && "/".equals(applicationTerm.getFunction().getName())) {
                term6 = managedScript.getScript().term("*", new Term[]{applicationTerm2.getParameters()[1], applicationTerm.getParameters()[1]});
                Term term7 = managedScript.getScript().term("*", new Term[]{applicationTerm2.getParameters()[0], applicationTerm.getParameters()[0]});
                term5 = QvasrAbstractor.simplifyRealDivision(managedScript, term7, term6);
            }
            if (!"/".equals(applicationTerm2.getFunction().getName()) && "/".equals(applicationTerm.getFunction().getName())) {
                term6 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{applicationTerm2, applicationTerm.getParameters()[0]});
                term5 = QvasrAbstractor.simplifyRealDivision(managedScript, term6, applicationTerm.getParameters()[1]);
            }
            if ("/".equals(applicationTerm2.getFunction().getName()) && !"/".equals(applicationTerm.getFunction().getName())) {
                term6 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{applicationTerm2.getParameters()[0], applicationTerm});
                term5 = QvasrAbstractor.simplifyRealDivision(managedScript, term6, applicationTerm2.getParameters()[1]);
            }
        }
        if (!QvasrUtils.isApplicationTerm(term) && QvasrUtils.isApplicationTerm(term2) && "/".equals((applicationTerm2 = (ApplicationTerm)term2).getFunction().getName())) {
            applicationTerm = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term, applicationTerm2.getParameters()[0]});
            term5 = QvasrAbstractor.simplifyRealDivision(managedScript, (Term)applicationTerm, applicationTerm2.getParameters()[1]);
        }
        if (QvasrUtils.isApplicationTerm(term) && !QvasrUtils.isApplicationTerm(term2) && "/".equals((applicationTerm2 = (ApplicationTerm)term).getFunction().getName())) {
            applicationTerm = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{term2, applicationTerm2.getParameters()[0]});
            term5 = QvasrAbstractor.simplifyRealDivision(managedScript, (Term)applicationTerm, applicationTerm2.getParameters()[1]);
        }
        return term5;
    }

    public static Term simplifyRealSubtraction(ManagedScript managedScript, Term term, Term term2) {
        Term term3;
        Object object;
        Object object2;
        Term term4;
        Term term5;
        ApplicationTerm applicationTerm;
        ApplicationTerm applicationTerm2;
        Term term6 = SmtUtils.minus((Script)managedScript.getScript(), (Term[])new Term[]{term, term2});
        if (QvasrUtils.isApplicationTerm(term2) && QvasrUtils.isApplicationTerm(term)) {
            applicationTerm2 = (ApplicationTerm)term2;
            applicationTerm = (ApplicationTerm)term;
            if ("/".equals(applicationTerm2.getFunction().getName())) {
                term5 = applicationTerm2.getParameters()[0];
                term4 = applicationTerm2.getParameters()[1];
                if (!"/".equals(applicationTerm.getFunction().getName())) {
                    object2 = QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, (Term)applicationTerm);
                    object2.addAll(QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, term4));
                    object = QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, term5);
                    Term term7 = QvasrAbstractor.expandRealMultiplication(managedScript, (List<Term>)object2);
                    Term term8 = QvasrAbstractor.expandRealMultiplication(managedScript, (List<Term>)object);
                    term3 = SmtUtils.minus((Script)managedScript.getScript(), (Term[])new Term[]{term7, term8});
                    term6 = QvasrAbstractor.simplifyRealDivision(managedScript, term3, term4);
                    term6.toStringDirect();
                } else {
                    object2 = applicationTerm.getParameters()[0];
                    object = applicationTerm.getParameters()[1];
                    if (QvasrUtils.checkTermEquiv(managedScript, term4, object)) {
                        Term term9 = SmtUtils.minus((Script)managedScript.getScript(), (Term[])new Term[]{object2, term5});
                        term6 = QvasrAbstractor.simplifyRealDivision(managedScript, term9, object);
                    } else {
                        Term term10 = QvasrAbstractor.expandRealMultiplication(managedScript, object, term4);
                        Term term11 = QvasrAbstractor.expandRealMultiplication(managedScript, object2, term4);
                        Term term12 = QvasrAbstractor.expandRealMultiplication(managedScript, term5, object);
                        Term term13 = SmtUtils.minus((Script)managedScript.getScript(), (Term[])new Term[]{term11, term12});
                        term6 = QvasrAbstractor.simplifyRealDivision(managedScript, term13, term10);
                    }
                }
            }
        }
        if (!QvasrUtils.isApplicationTerm(term2) && QvasrUtils.isApplicationTerm(term) && "/".equals((applicationTerm2 = (ApplicationTerm)term).getFunction().getName())) {
            term3 = applicationTerm2.getParameters()[0];
            term5 = applicationTerm2.getParameters()[1];
            term4 = QvasrAbstractor.expandRealMultiplication(managedScript, term2, term5);
            object2 = QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, term3);
            object = QvasrAbstractor.expandRealMultiplication(managedScript, (List<Term>)object2);
            applicationTerm = SmtUtils.minus((Script)managedScript.getScript(), (Term[])new Term[]{object, term4});
            term6 = QvasrAbstractor.simplifyRealDivision(managedScript, (Term)applicationTerm, term5);
            term6.toStringDirect();
        }
        if (QvasrUtils.isApplicationTerm(term2) && !QvasrUtils.isApplicationTerm(term) && "/".equals((applicationTerm2 = (ApplicationTerm)term2).getFunction().getName())) {
            term3 = applicationTerm2.getParameters()[0];
            term5 = applicationTerm2.getParameters()[1];
            term4 = QvasrAbstractor.expandRealMultiplication(managedScript, term, term5);
            object2 = QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, term3);
            object = QvasrAbstractor.expandRealMultiplication(managedScript, (List<Term>)object2);
            applicationTerm = SmtUtils.minus((Script)managedScript.getScript(), (Term[])new Term[]{term4, object});
            term6 = QvasrAbstractor.simplifyRealDivision(managedScript, (Term)applicationTerm, term5);
        }
        return term6;
    }

    public static Term reduceNegativeRealSubtraction(ManagedScript managedScript, Term term, Term term2) {
        if (QvasrUtils.isApplicationTerm(term) && QvasrUtils.isApplicationTerm(term2)) {
            Term term3;
            Object object;
            Object object2;
            Object object3;
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
            List<Term> list = Arrays.asList(applicationTerm.getParameters());
            List<Term> list2 = Arrays.asList(applicationTerm2.getParameters());
            if ("+".equals(applicationTerm.getFunction().getName()) && "+".equals(applicationTerm2.getFunction().getName())) {
                object3 = new ArrayDeque();
                object2 = new ArrayDeque();
                object3.addAll(list);
                object2.addAll(list);
                object = new ArrayDeque<Term>(list2);
                block0: while (!object3.isEmpty()) {
                    term3 = (Term)object3.pop();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Term term4 = (Term)iterator.next();
                        if (!QvasrUtils.checkTermEquiv(managedScript, term3, term4)) continue;
                        object.remove(term4);
                        object2.remove(term3);
                        continue block0;
                    }
                }
                list = new ArrayList<Term>((Collection<Term>)object2);
                list2 = new ArrayList<Term>((Collection<Term>)object);
            }
            if (!"+".equals(applicationTerm.getFunction().getName()) && "+".equals(applicationTerm2.getFunction().getName())) {
                object3 = new ArrayDeque();
                object3.add(applicationTerm);
                object2 = new ArrayDeque();
                object = new ArrayDeque();
                object2.addAll(list2);
                object.addAll(list2);
                while (!object2.isEmpty()) {
                    term3 = (Term)object2.pop();
                    if (!QvasrUtils.checkTermEquiv(managedScript, term3, (Term)applicationTerm)) continue;
                    object3.remove(applicationTerm);
                    object.remove(term3);
                    break;
                }
                list = new ArrayList<Term>((Collection<Term>)object3);
                list2 = new ArrayList<Term>((Collection<Term>)object);
            }
            if ("+".equals(applicationTerm.getFunction().getName()) && !"+".equals(applicationTerm2.getFunction().getName())) {
                object3 = new ArrayDeque();
                object2 = new ArrayDeque();
                object3.addAll(list);
                object2.addAll(list);
                object = new ArrayDeque();
                object.add(applicationTerm2);
                while (!object3.isEmpty()) {
                    term3 = (Term)object3.pop();
                    if (!QvasrUtils.checkTermEquiv(managedScript, term3, (Term)applicationTerm2)) continue;
                    object3.remove(applicationTerm2);
                    object2.remove(term3);
                    break;
                }
                list = new ArrayList<Term>((Collection<Term>)object2);
                list2 = new ArrayList<Term>((Collection<Term>)object);
            }
            object3 = managedScript.getScript().decimal("0");
            object2 = managedScript.getScript().decimal("0");
            object = list.toArray(new Term[list.size()]);
            term3 = list2.toArray(new Term[list2.size()]);
            if (list.size() > 1) {
                object3 = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])object);
            }
            if (list.size() == 1) {
                object3 = object[0];
            }
            if (list2.size() > 1) {
                object2 = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])term3);
            }
            if (list2.size() == 1) {
                object2 = term3[0];
            }
            return SmtUtils.minus((Script)managedScript.getScript(), (Term[])new Term[]{object3, object2});
        }
        return SmtUtils.minus((Script)managedScript.getScript(), (Term[])new Term[]{term, term2});
    }

    public static Pair<Term, Term> reduceRealDivision(ManagedScript managedScript, Term term, Term term2) {
        Term term3;
        Term term4 = managedScript.getScript().decimal("1");
        Term term5 = term;
        Term term6 = term2;
        do {
            Term[] termArray;
            Object object2;
            ApplicationTerm applicationTerm;
            term3 = term5;
            if (QvasrUtils.isApplicationTerm(term5) && QvasrUtils.isApplicationTerm(term6)) {
                ArrayList<Object> arrayList;
                List<Term> list;
                applicationTerm = (ApplicationTerm)term5;
                object2 = (ApplicationTerm)term6;
                if ("*".equals(applicationTerm.getFunction().getName()) && "*".equals(object2.getFunction().getName())) {
                    termArray = QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, (Term)applicationTerm);
                    list = QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, (Term)object2);
                    arrayList = new ArrayList<Term>((Collection<Term>)termArray);
                    ArrayList<Term> arrayList2 = new ArrayList<Term>(list);
                    for (Term term7 : termArray) {
                        for (Term term8 : list) {
                            if (!QvasrUtils.checkTermEquiv(managedScript, term7, term8)) continue;
                            arrayList.remove(term7);
                            arrayList2.remove(term8);
                        }
                    }
                    if (arrayList.isEmpty()) {
                        arrayList.add(term4);
                    }
                    if (arrayList2.isEmpty()) {
                        arrayList2.add(term4);
                    }
                    Term[] termArray2 = arrayList.toArray(new Term[arrayList.size()]);
                    Term[] termArray3 = arrayList2.toArray(new Term[arrayList2.size()]);
                    term5 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])termArray2);
                    term6 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])termArray3);
                }
                if ("*".equals(applicationTerm.getFunction().getName()) && !"*".equals(object2.getFunction().getName())) {
                    termArray = QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, (Term)applicationTerm);
                    list = new ArrayList<Term>((Collection<Term>)termArray);
                    arrayList = new ArrayList();
                    arrayList.add((Term)object2);
                    for (Term term9 : termArray) {
                        if (!QvasrUtils.checkTermEquiv(managedScript, term9, (Term)object2)) continue;
                        list.remove(term9);
                        arrayList.remove(object2);
                    }
                    if (list.isEmpty()) {
                        list.add(term4);
                    }
                    if (arrayList.isEmpty()) {
                        arrayList.add(term4);
                    }
                    Term[] termArray4 = list.toArray(new Term[list.size()]);
                    Term[] termArray5 = arrayList.toArray(new Term[arrayList.size()]);
                    term5 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])termArray4);
                    term6 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])termArray5);
                }
                if (!"*".equals(applicationTerm.getFunction().getName()) && "*".equals(object2.getFunction().getName())) {
                    termArray = QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, (Term)object2);
                    list = new ArrayList<Term>();
                    arrayList = new ArrayList(termArray);
                    list.add((Term)applicationTerm);
                    for (Term term10 : termArray) {
                        if (!QvasrUtils.checkTermEquiv(managedScript, term10, (Term)applicationTerm)) continue;
                        list.remove(term10);
                        arrayList.remove(applicationTerm);
                    }
                    if (list.isEmpty()) {
                        list.add(term4);
                    }
                    if (arrayList.isEmpty()) {
                        arrayList.add(term4);
                    }
                    Term[] termArray6 = list.toArray(new Term[list.size()]);
                    Term[] termArray7 = arrayList.toArray(new Term[arrayList.size()]);
                    term5 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])termArray6);
                    term6 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])termArray7);
                }
            }
            if (QvasrUtils.isApplicationTerm(term5) && !QvasrUtils.isApplicationTerm(term6) && "*".equals((applicationTerm = (ApplicationTerm)term5).getFunction().getName())) {
                object2 = new HashSet<Term>(Arrays.asList(applicationTerm.getParameters()));
                Term[] termArray8 = applicationTerm.getParameters();
                int n = termArray8.length;
                int n2 = 0;
                while (n2 < n) {
                    termArray = termArray8[n2];
                    if (QvasrUtils.checkTermEquiv(managedScript, (Term)termArray, term6)) {
                        object2.remove(termArray);
                        term6 = term4;
                    }
                    ++n2;
                }
                termArray = object2.toArray(new Term[object2.size()]);
                term5 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])termArray);
            }
            if (QvasrUtils.isApplicationTerm(term5) || !QvasrUtils.isApplicationTerm(term6) || !"*".equals((applicationTerm = (ApplicationTerm)term6).getFunction().getName())) continue;
            object2 = new HashSet<Term>(Arrays.asList(applicationTerm.getParameters()));
            Term[] termArray9 = applicationTerm.getParameters();
            int n = termArray9.length;
            int n3 = 0;
            while (n3 < n) {
                termArray = termArray9[n3];
                if (QvasrUtils.checkTermEquiv(managedScript, (Term)termArray, term5)) {
                    term5 = term4;
                    object2.remove(termArray);
                }
                ++n3;
            }
            termArray = object2.toArray(new Term[object2.size()]);
            term6 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])termArray);
        } while (!QvasrUtils.checkTermEquiv(managedScript, term3, term5));
        return new Pair((Object)term5, (Object)term6);
    }

    public static List<Term> getApplicationTermMultiplicationParams(ManagedScript managedScript, Term term) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (QvasrUtils.isApplicationTerm(term)) {
            if ("*".equals(((ApplicationTerm)term).getFunction().getName())) {
                Term[] termArray = ((ApplicationTerm)term).getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term2 = termArray[n2];
                    if (QvasrUtils.isApplicationTerm(term2) && "*".equals(((ApplicationTerm)term2).getFunction().getName())) {
                        arrayList.addAll(QvasrAbstractor.getApplicationTermMultiplicationParams(managedScript, term2));
                    } else {
                        arrayList.add(term2);
                    }
                    ++n2;
                }
            } else {
                arrayList.add(term);
            }
        } else {
            arrayList.add(term);
        }
        return arrayList;
    }

    public static List<Term> getApplicationTermSumParams(ApplicationTerm applicationTerm) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if ("+".equals(applicationTerm.getFunction().getName())) {
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                if (QvasrUtils.isApplicationTerm(term) && "+".endsWith(((ApplicationTerm)term).getFunction().getName())) {
                    arrayList.addAll(QvasrAbstractor.getApplicationTermSumParams((ApplicationTerm)term));
                } else {
                    arrayList.add(term);
                }
                ++n2;
            }
        } else {
            arrayList.add((Term)applicationTerm);
        }
        return arrayList;
    }

    private static int findPivot(ManagedScript managedScript, Term[][] termArray, int n) {
        int n2 = -1;
        int n3 = n;
        while (n3 < termArray.length) {
            if (!QvasrUtils.checkTermEquiv(managedScript, termArray[n3][n], managedScript.getScript().decimal("0"))) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    private static Term[][] swap(Term[][] termArray, int n, int n2) {
        int n3 = n;
        while (n3 < termArray[n].length) {
            Term term = termArray[n][n3];
            termArray[n][n3] = termArray[n2][n3];
            termArray[n2][n3] = term;
            ++n3;
        }
        return termArray;
    }

    private static Map<TermVariable, Term> getUpdates(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, BaseType baseType) {
        Term term;
        Object object2;
        SimultaneousUpdate simultaneousUpdate;
        try {
            simultaneousUpdate = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)iUltimateServiceProvider, (TransFormula)unmodifiableTransFormula, (ManagedScript)managedScript);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Could not compute Simultaneous Update!");
        }
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        Map map = simultaneousUpdate.getDeterministicAssignment();
        for (Object object2 : simultaneousUpdate.getReadonlyVars()) {
            map.put(object2, object2.getTermVariable());
        }
        for (Object object2 : map.keySet()) {
            TermVariable termVariable = managedScript.constructFreshTermVariable(object2.getGloballyUniqueId() + "_real", SmtSortUtils.getRealSort((ManagedScript)managedScript));
            hashMap.put(object2.getTermVariable(), termVariable);
        }
        object2 = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            Term term2 = (Term)entry.getValue();
            term = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term2);
            ((HashMap)object2).put((IProgramVar)entry.getKey(), term);
        }
        LinkedHashMap<TermVariable, Term> linkedHashMap = new LinkedHashMap<TermVariable, Term>();
        for (Map.Entry entry : ((HashMap)object2).entrySet()) {
            Term term3;
            ApplicationTerm applicationTerm;
            term = (IProgramVar)entry.getKey();
            Term term4 = (Term)entry.getValue();
            HashMap<Term, Term> hashMap2 = new HashMap<Term, Term>();
            if (QvasrUtils.isApplicationTerm(term4)) {
                applicationTerm = (ApplicationTerm)term4;
                hashMap2.putAll(QvasrAbstractor.appTermToReal(managedScript, applicationTerm));
                term3 = Substitution.apply((ManagedScript)managedScript, hashMap2, (Term)applicationTerm);
            } else if (term4 instanceof ConstantTerm) {
                applicationTerm = SmtUtils.toRational((ConstantTerm)((ConstantTerm)term4));
                term3 = applicationTerm.toTerm(SmtSortUtils.getRealSort((ManagedScript)managedScript));
            } else {
                term3 = (Term)hashMap.get(term.getTermVariable());
            }
            if (baseType == BaseType.ADDITIONS) {
                applicationTerm = (Term)hashMap.get(term.getTermVariable());
                term3 = SmtUtils.minus((Script)managedScript.getScript(), (Term[])new Term[]{term3, applicationTerm});
            }
            linkedHashMap.put((TermVariable)hashMap.get(term.getTermVariable()), term3);
        }
        return linkedHashMap;
    }

    private static Map<Term, Term> appTermToReal(ManagedScript managedScript, ApplicationTerm applicationTerm) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        Term[] termArray = applicationTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (term.getSort() != SmtSortUtils.getRealSort((ManagedScript)managedScript)) {
                if (term instanceof ConstantTerm) {
                    ConstantTerm constantTerm = (ConstantTerm)term;
                    Rational rational = (Rational)constantTerm.getValue();
                    hashMap.put(term, rational.toTerm(SmtSortUtils.getRealSort((ManagedScript)managedScript)));
                } else if (term instanceof TermVariable) {
                    hashMap.put(term, (Term)managedScript.constructFreshTermVariable(((TermVariable)term).getName(), SmtSortUtils.getRealSort((ManagedScript)managedScript)));
                } else {
                    hashMap.putAll(QvasrAbstractor.appTermToReal(managedScript, (ApplicationTerm)term));
                }
            }
            ++n2;
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private static Term[][] constructBaseMatrix(ManagedScript managedScript, Map<TermVariable, Term> map, UnmodifiableTransFormula unmodifiableTransFormula) {
        void var6_12;
        int n = unmodifiableTransFormula.getOutVars().size();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashMap hashMap = new HashMap();
        for (Term term : map.keySet()) {
            HashSet hashSet2 = new HashSet();
            hashSet2.add(term);
            hashSet.add(hashSet2);
        }
        HashSet hashSet3 = new HashSet(hashSet);
        for (Set set : hashSet) {
            Set<Set<Term>> set2 = QvasrUtils.joinSet((Set<Set<Term>>)var6_12, set);
        }
        Term[][] termArray = new Term[var6_12.size() + 1][n + 1];
        int n2 = 0;
        while (n2 < var6_12.size() + 1) {
            int n3 = 0;
            while (n3 < n + 1) {
                termArray[n2][n3] = managedScript.getScript().decimal("0");
                ++n3;
            }
            ++n2;
        }
        HashDeque hashDeque = new HashDeque();
        hashDeque.addAll(var6_12);
        Term term = managedScript.getScript().decimal("1");
        Term term2 = managedScript.getScript().decimal("0");
        int n4 = 0;
        while (!hashDeque.isEmpty()) {
            Term term32;
            int n5 = 0;
            termArray[n4][n] = term;
            HashMap<Term, Term> hashMap2 = new HashMap<Term, Term>();
            if (n4 > 0) {
                Set set = (Set)hashDeque.pop();
                for (Term term32 : set) {
                    hashMap2.put(term32, term2);
                }
            }
            term32 = map.entrySet().iterator();
            while (term32.hasNext()) {
                Term term4;
                Map.Entry<TermVariable, Term> entry = term32.next();
                Term term5 = entry.getValue();
                Term term6 = Substitution.apply((ManagedScript)managedScript, hashMap2, (Term)term5);
                termArray[n4][n5] = term4 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term6);
                ++n5;
            }
            ++n4;
        }
        return termArray;
    }

    /*
     * WARNING - void declaration
     */
    private Term constructBaseFormula(ManagedScript managedScript, Map<TermVariable, Set<Term>> map, UnmodifiableTransFormula unmodifiableTransFormula, BaseType baseType) {
        void var7_10;
        int n = 0;
        HashSet<Term> hashSet = new HashSet<Term>();
        for (Map.Entry<TermVariable, Set<Term>> term2 : map.entrySet()) {
            TermVariable termVariable = managedScript.constructFreshTermVariable("s" + n, SmtSortUtils.getRealSort((ManagedScript)managedScript));
            for (Term term : term2.getValue()) {
                Term term3 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{termVariable, term});
                hashSet.add(term3);
            }
            ++n;
        }
        Term term = managedScript.getScript().decimal("1");
        for (Term term5 : hashSet) {
            Term term4 = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{var7_10, term5});
        }
        Term term5 = SmtUtils.equality((Script)managedScript.getScript(), (Term[])new Term[]{var7_10, managedScript.constructFreshTermVariable("a", SmtSortUtils.getRealSort((ManagedScript)managedScript))});
        return term5;
    }

    private static enum BaseType {
        RESETS,
        ADDITIONS;

    }
}

