/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.lib.results.SyntaxErrorResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Expression2Term;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IForkActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IJoinActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ForkThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.JoinThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TransFormulaAdder {
    private final Boogie2SMT mBoogie2smt;
    private final boolean mSimplifyCodeBlocks;
    private final IUltimateServiceProvider mServices;

    public TransFormulaAdder(Boogie2SMT boogie2SMT, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mBoogie2smt = boogie2SMT;
        this.mSimplifyCodeBlocks = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Simplify code blocks");
    }

    public void addTransitionFormulas(CodeBlock codeBlock, String string, SmtUtils.SimplificationTechnique simplificationTechnique) {
        SmtUtils.SimplificationTechnique simplificationTechnique2;
        CodeBlock codeBlock2;
        List<Object> list;
        if (codeBlock instanceof StatementSequence) {
            list = ((StatementSequence)codeBlock).getStatements();
        } else if (codeBlock instanceof Summary) {
            list = Collections.singletonList(((Summary)codeBlock).getCallStatement());
        } else if (codeBlock instanceof ForkThreadCurrent) {
            codeBlock2 = (ForkThreadCurrent)codeBlock;
            list = Collections.singletonList(((ForkThreadCurrent)codeBlock2).getForkStatement());
            simplificationTechnique2 = TransFormulaAdder.constructForkSmtArguments(((ForkThreadCurrent)codeBlock2).getForkStatement(), this.mBoogie2smt);
            ((ForkThreadCurrent)codeBlock2).setForkSmtArguments((IForkActionThreadCurrent.ForkSmtArguments)simplificationTechnique2);
        } else if (codeBlock instanceof JoinThreadCurrent) {
            codeBlock2 = (JoinThreadCurrent)codeBlock;
            list = Collections.singletonList(((JoinThreadCurrent)codeBlock2).getJoinStatement());
            simplificationTechnique2 = TransFormulaAdder.constructJoinSmtArguments(((JoinThreadCurrent)codeBlock2).getJoinStatement(), this.mBoogie2smt);
            ((JoinThreadCurrent)codeBlock2).setJoinSmtArguments((IJoinActionThreadCurrent.JoinSmtArguments)simplificationTechnique2);
        } else if (codeBlock instanceof GotoEdge) {
            list = Collections.emptyList();
        } else {
            throw new AssertionError((Object)("Cannot add transition formula to CodeBlock of type " + ((Object)((Object)codeBlock)).getClass().getSimpleName()));
        }
        codeBlock2 = null;
        try {
            simplificationTechnique2 = this.mSimplifyCodeBlocks ? simplificationTechnique : SmtUtils.SimplificationTechnique.NONE;
            codeBlock2 = this.mBoogie2smt.getStatements2TransFormula().statementSequence(simplificationTechnique2, string, list);
        }
        catch (SMTLIBException sMTLIBException) {
            if (sMTLIBException.getMessage().equals("Unsupported non-linear arithmetic")) {
                this.reportUnsupportedSyntax(codeBlock, sMTLIBException.getMessage());
            }
            throw sMTLIBException;
        }
        if (!codeBlock2.getOverapproximations().isEmpty()) {
            new Overapprox(codeBlock2.getOverapproximations()).annotate((IElement)codeBlock);
        }
        codeBlock.setTransitionFormula(codeBlock2.getTransFormula());
    }

    private static IForkActionThreadCurrent.ForkSmtArguments constructForkSmtArguments(ForkStatement forkStatement, Boogie2SMT boogie2SMT) {
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray = new Expression2Term.IIdentifierTranslator[2];
        iIdentifierTranslatorArray[0] = new Boogie2SMT.LocalVarAndGlobalVarTranslator(boogie2SMT);
        iIdentifierTranslatorArray[1] = boogie2SMT.createConstOnlyIdentifierTranslator();
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray2 = iIdentifierTranslatorArray;
        Expression2Term.MultiTermResult multiTermResult = boogie2SMT.getExpression2Term().translateToTerms(iIdentifierTranslatorArray2, forkStatement.getThreadID());
        if (!multiTermResult.auxiliaryVars().isEmpty()) {
            throw new UnsupportedOperationException("auxvars not yet supported");
        }
        if (!multiTermResult.overapproximations().isEmpty()) {
            throw new UnsupportedOperationException("overapproximations not yet supported");
        }
        Expression2Term.MultiTermResult multiTermResult2 = boogie2SMT.getExpression2Term().translateToTerms(iIdentifierTranslatorArray2, forkStatement.getArguments());
        if (!multiTermResult2.auxiliaryVars().isEmpty()) {
            throw new UnsupportedOperationException("auxvars not yet supported");
        }
        if (!multiTermResult2.overapproximations().isEmpty()) {
            throw new UnsupportedOperationException("overapproximations not yet supported");
        }
        return new IForkActionThreadCurrent.ForkSmtArguments(multiTermResult, multiTermResult2);
    }

    private static IJoinActionThreadCurrent.JoinSmtArguments constructJoinSmtArguments(JoinStatement joinStatement, Boogie2SMT boogie2SMT) {
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray = new Expression2Term.IIdentifierTranslator[2];
        iIdentifierTranslatorArray[0] = new Boogie2SMT.LocalVarAndGlobalVarTranslator(boogie2SMT);
        iIdentifierTranslatorArray[1] = boogie2SMT.createConstOnlyIdentifierTranslator();
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray2 = iIdentifierTranslatorArray;
        Expression2Term.MultiTermResult multiTermResult = boogie2SMT.getExpression2Term().translateToTerms(iIdentifierTranslatorArray2, joinStatement.getThreadID());
        if (!multiTermResult.auxiliaryVars().isEmpty()) {
            throw new UnsupportedOperationException("auxvars not yet supported");
        }
        if (!multiTermResult.overapproximations().isEmpty()) {
            throw new UnsupportedOperationException("overapproximations not yet supported");
        }
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        VariableLHS[] variableLHSArray = joinStatement.getLhs();
        int n = variableLHSArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLHS variableLHS = variableLHSArray[n2];
            IProgramVar iProgramVar = boogie2SMT.getBoogie2SmtSymbolTable().getBoogieVar(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation(), false);
            arrayList.add(iProgramVar);
            ++n2;
        }
        return new IJoinActionThreadCurrent.JoinSmtArguments(multiTermResult, arrayList);
    }

    void reportUnsupportedSyntax(CodeBlock codeBlock, String string) {
        ILocation iLocation = ILocation.getAnnotation((IElement)codeBlock);
        SyntaxErrorResult syntaxErrorResult = new SyntaxErrorResult("RCFGBuilder", iLocation, string);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)syntaxErrorResult);
        this.mServices.getProgressMonitorService().cancelToolchain();
    }
}

