/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class EliminationTask {
    private static final boolean DEBUG_USE_TO_STRING_DIRECT = false;
    private final int mQuantifier;
    private final LinkedHashSet<TermVariable> mEliminatees;
    private final Term mTerm;
    private final Context mContext;

    public EliminationTask(int n, Set<TermVariable> set, Term term, Context context) {
        assert (n == 0 || n == 1);
        this.mQuantifier = n;
        this.mEliminatees = QuantifierUtils.projectToFreeVars(set, term);
        this.mTerm = term;
        this.mContext = context;
    }

    public EliminationTask(QuantifiedFormula quantifiedFormula, Context context) {
        this.mQuantifier = quantifiedFormula.getQuantifier();
        this.mEliminatees = QuantifierUtils.projectToFreeVars(Arrays.asList(quantifiedFormula.getVariables()), quantifiedFormula.getSubformula());
        this.mTerm = quantifiedFormula.getSubformula();
        this.mContext = context;
    }

    public int getQuantifier() {
        return this.mQuantifier;
    }

    public Set<TermVariable> getEliminatees() {
        return Collections.unmodifiableSet(this.mEliminatees);
    }

    public Term getTerm() {
        return this.mTerm;
    }

    public Term toTerm(Script script) {
        if (this.mEliminatees.isEmpty()) {
            return this.mTerm;
        }
        return script.quantifier(this.mQuantifier, this.mEliminatees.toArray(new TermVariable[this.mEliminatees.size()]), this.mTerm, (Term[][])new Term[0][]);
    }

    public Context getContext() {
        return this.mContext;
    }

    public EliminationTask integrateNewEliminatees(Collection<TermVariable> collection) {
        LinkedHashSet<TermVariable> linkedHashSet = QuantifierUtils.projectToFreeVars(collection, this.getTerm());
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(this.getEliminatees());
        boolean bl = hashSet.addAll(linkedHashSet);
        if (bl) {
            return new EliminationTask(this.getQuantifier(), hashSet, this.getTerm(), this.mContext);
        }
        return this;
    }

    public EliminationTask update(Set<TermVariable> set, Term term) {
        return new EliminationTask(this.getQuantifier(), set, term, this.mContext);
    }

    public EliminationTask update(Term term) {
        return new EliminationTask(this.getQuantifier(), this.getEliminatees(), term, this.mContext);
    }

    public Pair<Term, EliminationTask> makeTight(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        Term term;
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(this.getQuantifier(), this.getTerm());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term = termArray2[n2];
            if (DataStructureUtils.haveEmptyIntersection(this.getEliminatees(), new HashSet<TermVariable>(Arrays.asList(term.getFreeVars())))) {
                arrayList2.add(term);
            } else {
                arrayList.add(term);
            }
            ++n2;
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        term = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), this.getQuantifier(), arrayList2);
        Term term2 = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), this.getQuantifier(), arrayList);
        Context context = this.getContext().constructChildContextForConDis(iUltimateServiceProvider, managedScript, ((ApplicationTerm)this.getTerm()).getFunction(), arrayList2);
        return new Pair((Object)term, (Object)new EliminationTask(this.getQuantifier(), this.getEliminatees(), term2, context));
    }

    public String toString() {
        String string = this.getQuantifier() == 0 ? "\u2203" : "\u2200";
        String string2 = this.getEliminatees().toString();
        String string3 = this.getTerm().toString();
        return string + " " + string2 + ". " + string3;
    }

    public static Script.LBool areDistinct(Script script, EliminationTask eliminationTask, EliminationTask eliminationTask2) {
        Term term = eliminationTask.toTerm(script);
        Term term2 = eliminationTask2.toTerm(script);
        Script.LBool lBool = Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, term2}));
        return lBool;
    }
}

