/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseMinimizeStates;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;

public class MinimizeStatesMultiEdgeMultiNode
extends BaseMinimizeStates {
    private static final String INDENT = "    ";

    public MinimizeStatesMultiEdgeMultiNode(IcfgEdgeBuilder icfgEdgeBuilder, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, BiPredicate<IIcfg<?>, IcfgLocation> biPredicate, ILogger iLogger, boolean bl) {
        super(icfgEdgeBuilder, iUltimateServiceProvider, blockEncodingBacktranslator, biPredicate, iLogger, bl);
    }

    @Override
    protected Collection<? extends IcfgLocation> processCandidate(IIcfg<?> iIcfg, IcfgLocation icfgLocation, Set<IcfgLocation> set) {
        List<Pair<IcfgEdge, IcfgEdge>> list;
        if (this.isNecessary(iIcfg, icfgLocation)) {
            return icfgLocation.getOutgoingNodes();
        }
        List list2 = icfgLocation.getIncomingNodes();
        List list3 = icfgLocation.getOutgoingNodes();
        if (list2.isEmpty() || list3.isEmpty()) {
            return icfgLocation.getOutgoingNodes();
        }
        if (!this.isAllCombinableEdgePair(icfgLocation.getIncomingEdges(), icfgLocation.getOutgoingEdges())) {
            return icfgLocation.getOutgoingNodes();
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("    will try to remove " + String.valueOf(icfgLocation.getDebugIdentifier())));
        }
        if ((list = MinimizeStatesMultiEdgeMultiNode.getEdgePairs(icfgLocation)).isEmpty()) {
            return icfgLocation.getOutgoingNodes();
        }
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        HashSet<IcfgLocation> hashSet2 = new HashSet<IcfgLocation>();
        ArrayList<EdgeConstructor> arrayList = new ArrayList<EdgeConstructor>();
        int n = 0;
        for (Pair<IcfgEdge, IcfgEdge> pair : list) {
            IcfgEdge icfgEdge = (IcfgEdge)pair.getFirst();
            IcfgEdge icfgEdge2 = (IcfgEdge)pair.getSecond();
            hashSet.add(icfgEdge);
            hashSet.add(icfgEdge2);
            arrayList.add(new EdgeConstructor(icfgEdge, icfgEdge2));
            ++n;
            hashSet2.add((IcfgLocation)icfgEdge.getSource());
            set.remove(icfgEdge.getSource());
        }
        arrayList.stream().forEach(EdgeConstructor::access$0);
        int n2 = MinimizeStatesMultiEdgeMultiNode.disconnectEdges(hashSet);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("    removed " + n2 + ", added " + n + " edges"));
        }
        this.mRemovedEdges += n2;
        hashSet2.addAll(icfgLocation.getOutgoingNodes());
        return hashSet2;
    }

    private static List<Pair<IcfgEdge, IcfgEdge>> getEdgePairs(IcfgLocation icfgLocation) {
        ArrayList<Pair<IcfgEdge, IcfgEdge>> arrayList = new ArrayList<Pair<IcfgEdge, IcfgEdge>>();
        for (IcfgEdge icfgEdge : icfgLocation.getIncomingEdges()) {
            if (icfgEdge instanceof Summary) continue;
            for (IcfgEdge icfgEdge2 : icfgLocation.getOutgoingEdges()) {
                if (icfgEdge2 instanceof Summary) continue;
                arrayList.add((Pair<IcfgEdge, IcfgEdge>)new Pair((Object)icfgEdge, (Object)icfgEdge2));
            }
        }
        return arrayList;
    }

    private static int disconnectEdges(Collection<IcfgEdge> collection) {
        int n = 0;
        for (IcfgEdge icfgEdge : collection) {
            icfgEdge.disconnectSource();
            icfgEdge.disconnectTarget();
            ++n;
        }
        return n;
    }

    private final class EdgeConstructor {
        private final IcfgLocation mSource;
        private final IcfgLocation mTarget;
        private final IcfgEdge mFirst;
        private final IcfgEdge mSecond;

        private EdgeConstructor(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
            this.mSource = (IcfgLocation)icfgEdge.getSource();
            this.mTarget = (IcfgLocation)icfgEdge2.getTarget();
            this.mFirst = icfgEdge;
            this.mSecond = icfgEdge2;
        }

        private IcfgEdge constructSequentialComposition() {
            IcfgEdge icfgEdge = MinimizeStatesMultiEdgeMultiNode.this.getEdgeBuilder().constructSequentialComposition(this.mSource, this.mTarget, this.mFirst, this.mSecond);
            if (MinimizeStatesMultiEdgeMultiNode.this.mLogger.isDebugEnabled()) {
                MinimizeStatesMultiEdgeMultiNode.this.mLogger.debug((Object)"    replacing");
                MinimizeStatesMultiEdgeMultiNode.this.mLogger.debug((Object)(MinimizeStatesMultiEdgeMultiNode.INDENT + String.valueOf(this.mFirst)));
                MinimizeStatesMultiEdgeMultiNode.this.mLogger.debug((Object)(MinimizeStatesMultiEdgeMultiNode.INDENT + String.valueOf(this.mSecond)));
                MinimizeStatesMultiEdgeMultiNode.this.mLogger.debug((Object)"    with");
                MinimizeStatesMultiEdgeMultiNode.this.mLogger.debug((Object)(MinimizeStatesMultiEdgeMultiNode.INDENT + String.valueOf(icfgEdge)));
            }
            MinimizeStatesMultiEdgeMultiNode.this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge, (IIcfgTransition<?>)this.mFirst);
            MinimizeStatesMultiEdgeMultiNode.this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge, (IIcfgTransition<?>)this.mSecond);
            return icfgEdge;
        }

        static /* synthetic */ IcfgEdge access$0(EdgeConstructor edgeConstructor) {
            return edgeConstructor.constructSequentialComposition();
        }
    }
}

