/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class IfThenElseExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(IfThenElseExpression.class);
    Expression condition;
    Expression thenPart;
    Expression elsePart;

    public IfThenElseExpression(ILocation iLocation, Expression expression, Expression expression2, Expression expression3) {
        super(iLocation);
        this.condition = expression;
        this.thenPart = expression2;
        this.elsePart = expression3;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid IfThenElseExpression: " + String.valueOf((Object)this);
    }

    public IfThenElseExpression(ILocation iLocation, IBoogieType iBoogieType, Expression expression, Expression expression2, Expression expression3) {
        super(iLocation, iBoogieType);
        this.condition = expression;
        this.thenPart = expression2;
        this.elsePart = expression3;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid IfThenElseExpression: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IfThenElseExpression").append('[');
        stringBuffer.append((Object)this.condition);
        stringBuffer.append(',').append((Object)this.thenPart);
        stringBuffer.append(',').append((Object)this.elsePart);
        return stringBuffer.append(']').toString();
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getThenPart() {
        return this.thenPart;
    }

    public Expression getElsePart() {
        return this.elsePart;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.condition);
        list.add(this.thenPart);
        list.add(this.elsePart);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            if (this.condition != null) {
                this.condition.accept(generatedBoogieAstVisitor);
            }
            if (this.thenPart != null) {
                this.thenPart.accept(generatedBoogieAstVisitor);
            }
            if (this.elsePart != null) {
                this.elsePart.accept(generatedBoogieAstVisitor);
            }
        }
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.condition != null) {
            expression2 = this.condition.accept(generatedBoogieAstTransformer);
        }
        Expression expression3 = null;
        if (this.thenPart != null) {
            expression3 = this.thenPart.accept(generatedBoogieAstTransformer);
        }
        Expression expression4 = null;
        if (this.elsePart != null) {
            expression4 = this.elsePart.accept(generatedBoogieAstTransformer);
        }
        if (this.condition != expression2 || this.thenPart != expression3 || this.elsePart != expression4) {
            return new IfThenElseExpression(this.loc, this.type, expression2, expression3, expression4);
        }
        return this;
    }
}

