/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class UnaryExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(UnaryExpression.class);
    Operator operator;
    Expression expr;

    public UnaryExpression(ILocation iLocation, Operator operator, Expression expression) {
        super(iLocation);
        this.operator = operator;
        this.expr = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid UnaryExpression: " + String.valueOf((Object)this);
    }

    public UnaryExpression(ILocation iLocation, IBoogieType iBoogieType, Operator operator, Expression expression) {
        super(iLocation, iBoogieType);
        this.operator = operator;
        this.expr = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid UnaryExpression: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UnaryExpression").append('[');
        stringBuffer.append((Object)this.operator);
        stringBuffer.append(',').append((Object)this.expr);
        return stringBuffer.append(']').toString();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getExpr() {
        return this.expr;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.expr);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.expr != null) {
            this.expr.accept(generatedBoogieAstVisitor);
        }
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.expr != null) {
            expression2 = this.expr.accept(generatedBoogieAstTransformer);
        }
        if (this.expr != expression2) {
            return new UnaryExpression(this.loc, this.type, this.operator, expression2);
        }
        return this;
    }

    public static enum Operator {
        LOGICNEG,
        ARITHNEGATIVE,
        OLD;

    }
}

