/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.Map;
import java.util.Set;

public class TraceAbstractionBenchmarks
implements ICsvProviderProvider<Object> {
    private final StatisticsData mCegarLoopBenchmarkData;
    private final int mProcedures;
    private final int mLocations;
    private final int mEdges;
    private final int mErrorLocations;
    private int mCegarLoopsRun = 0;

    public TraceAbstractionBenchmarks(IIcfg<?> iIcfg) {
        this.mProcedures = iIcfg.getProcedureEntryNodes().size();
        this.mLocations = (int)iIcfg.getProgramPoints().entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).count();
        this.mEdges = IcfgUtils.countNumberOfEdges(iIcfg);
        this.mErrorLocations = (int)iIcfg.getProcedureErrorNodes().entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream()).count();
        this.mCegarLoopBenchmarkData = new StatisticsData();
    }

    public void aggregateBenchmarkData(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mCegarLoopBenchmarkData.aggregateBenchmarkData(iStatisticsDataProvider);
        ++this.mCegarLoopsRun;
    }

    public static String prettyprintNanoseconds(long l) {
        long l2 = l / 1000000000L;
        long l3 = l / 100000000L % 10L;
        return l2 + "." + l3 + "s";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CFG has ");
        stringBuilder.append(this.mProcedures);
        stringBuilder.append(" procedures, ");
        stringBuilder.append(this.mLocations);
        stringBuilder.append(" locations, ");
        stringBuilder.append(this.mEdges);
        stringBuilder.append(" edges, ");
        stringBuilder.append(this.mErrorLocations);
        stringBuilder.append(" error locations. ");
        stringBuilder.append("Started ");
        stringBuilder.append(this.mCegarLoopsRun);
        stringBuilder.append(" CEGAR loops. ");
        stringBuilder.append(this.mCegarLoopBenchmarkData.toString());
        return stringBuilder.toString();
    }

    public ICsvProvider<Object> createCsvProvider() {
        return this.mCegarLoopBenchmarkData.createCsvProvider();
    }
}

