/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IntraproceduralReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LinearPatternBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LinearTransitionPattern
extends LinearPatternBase {
    private final Map<IProgramVar, IProgramVar> mInToOutVars;

    public LinearTransitionPattern(Script script, Set<IProgramVar> set, Set<IProgramVar> set2, String string, boolean bl) {
        this.mVariablesOfThisPattern = new HashSet<IProgramVar>(set);
        this.mInToOutVars = new HashMap<IProgramVar, IProgramVar>();
        for (IProgramVar iProgramVar : set2) {
            if (!this.mVariablesOfThisPattern.contains(iProgramVar)) {
                this.mVariablesOfThisPattern.add(iProgramVar);
                this.mInToOutVars.put(iProgramVar, iProgramVar);
                continue;
            }
            IntraproceduralReplacementVar intraproceduralReplacementVar = new IntraproceduralReplacementVar(string + iProgramVar.toString() + "_Out", iProgramVar.getTerm(), iProgramVar.getTermVariable());
            this.mVariablesOfThisPattern.add(intraproceduralReplacementVar);
            this.mInToOutVars.put(iProgramVar, (IProgramVar)intraproceduralReplacementVar);
        }
        this.mFunctionGenerator = new AffineFunctionGenerator(script, (Collection)this.mVariablesOfThisPattern, string);
        this.mStrictInequality = bl;
    }

    private LinearTransitionPattern(AffineFunctionGenerator affineFunctionGenerator, boolean bl, Set<IProgramVar> set, Map<IProgramVar, IProgramVar> map) {
        this.mFunctionGenerator = affineFunctionGenerator;
        this.mStrictInequality = bl;
        this.mVariablesOfThisPattern = set;
        this.mInToOutVars = map;
    }

    public boolean containsOutVars() {
        return !this.mInToOutVars.isEmpty();
    }

    public Term getCoefficientForOutVar(IProgramVar iProgramVar) {
        return this.mFunctionGenerator.getCoefficient(this.mInToOutVars.get(iProgramVar));
    }

    @Override
    public LinearInequality getLinearInequality(Map<IProgramVar, Term> map) {
        assert (this.mInToOutVars.isEmpty());
        return super.getLinearInequality(map);
    }

    public LinearInequality getLinearInequality(Map<IProgramVar, Term> map, Map<IProgramVar, Term> map2) {
        assert (map2.keySet().containsAll(this.mInToOutVars.keySet()));
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>(map);
        for (Map.Entry<IProgramVar, IProgramVar> entry : this.mInToOutVars.entrySet()) {
            hashMap.put(entry.getValue(), map2.get(entry.getKey()));
        }
        return super.getLinearInequality(hashMap);
    }

    public LinearTransitionPattern getPatternWithNegatedCoefficients(Script script) {
        AffineFunctionGenerator affineFunctionGenerator = this.mFunctionGenerator.getGeneratorWithNegatedCoefficients(script);
        return new LinearTransitionPattern(affineFunctionGenerator, this.mStrictInequality, this.mVariablesOfThisPattern, this.mInToOutVars);
    }
}

