/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolantGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IIpTcStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.RefinementEngineStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantconsolidation.InterpolatingTraceCheckWithConsolidation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import java.util.Collection;
import java.util.Collections;

public class IpTcStrategyModuleInterpolantConsolidation<T extends IInterpolatingTraceCheck<L>, L extends IIcfgTransition<?>>
implements IIpTcStrategyModule<InterpolatingTraceCheckWithConsolidation<T, L>, L> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final TaCheckAndRefinementPreferences<?> mPrefs;
    private final PredicateFactory mPredicateFactory;
    private final IIpTcStrategyModule<T, L> mIpTcModule;
    private InterpolatingTraceCheckWithConsolidation<T, L> mInterpolantConsolidation;

    public IpTcStrategyModuleInterpolantConsolidation(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, TaCheckAndRefinementPreferences<L> taCheckAndRefinementPreferences, PredicateFactory predicateFactory, IIpTcStrategyModule<T, L> iIpTcStrategyModule) {
        this.mServices = iUltimateServiceProvider;
        this.mPrefs = taCheckAndRefinementPreferences;
        this.mPredicateFactory = predicateFactory;
        this.mIpTcModule = iIpTcStrategyModule;
        this.mLogger = iLogger;
    }

    public Script.LBool isCorrect() {
        return this.mIpTcModule.isCorrect();
    }

    public boolean providesRcfgProgramExecution() {
        return this.mIpTcModule.providesRcfgProgramExecution();
    }

    public IProgramExecution<L, Term> getRcfgProgramExecution() {
        return this.mIpTcModule.getRcfgProgramExecution();
    }

    public TraceCheckReasonUnknown getTraceCheckReasonUnknown() {
        return this.mIpTcModule.getTraceCheckReasonUnknown();
    }

    public IHoareTripleChecker getHoareTripleChecker() {
        return this.mIpTcModule.getHoareTripleChecker();
    }

    public IPredicateUnifier getPredicateUnifier() {
        return this.mIpTcModule.getPredicateUnifier();
    }

    public void aggregateStatistics(RefinementEngineStatisticsGenerator refinementEngineStatisticsGenerator) {
        this.mIpTcModule.aggregateStatistics(refinementEngineStatisticsGenerator);
        refinementEngineStatisticsGenerator.addStatistics(RefinementEngineStatisticsGenerator.RefinementEngineStatisticsDefinitions.INTERPOLANT_CONSOLIDATION, this.getOrConstruct().getStatistics());
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        return this.getOrConstruct().getInterpolantComputationStatus();
    }

    public Collection<QualifiedTracePredicates> getPerfectInterpolantSequences() {
        IInterpolantGenerator iInterpolantGenerator = this.getOrConstruct();
        if (iInterpolantGenerator.isPerfectSequence()) {
            return Collections.singleton(new QualifiedTracePredicates(iInterpolantGenerator.getIpp(), iInterpolantGenerator.getClass(), true));
        }
        return Collections.emptyList();
    }

    public Collection<QualifiedTracePredicates> getImperfectInterpolantSequences() {
        IInterpolantGenerator iInterpolantGenerator = this.getOrConstruct();
        if (!iInterpolantGenerator.isPerfectSequence()) {
            return Collections.singleton(new QualifiedTracePredicates(iInterpolantGenerator.getIpp(), iInterpolantGenerator.getClass(), false));
        }
        return Collections.emptyList();
    }

    public InterpolatingTraceCheckWithConsolidation<T, L> getOrConstruct() {
        if (this.mInterpolantConsolidation == null) {
            CfgSmtToolkit cfgSmtToolkit = this.mPrefs.getCfgSmtToolkit();
            try {
                this.mInterpolantConsolidation = new InterpolatingTraceCheckWithConsolidation(cfgSmtToolkit, this.mServices, this.mLogger, this.mPredicateFactory, (IInterpolatingTraceCheck)this.mIpTcModule.getOrConstruct());
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                throw new RuntimeException(automataOperationCanceledException);
            }
        }
        return this.mInterpolantConsolidation;
    }
}

