/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.AutomatonFreeRefinementEngine;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngine;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.ITraceCheckStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.RefinementEngineStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IIpAbStrategyModule;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class TraceAbstractionRefinementEngine<L extends IIcfgTransition<?>>
implements IRefinementEngine<L, NestedWordAutomaton<L, IPredicate>> {
    private final ILogger mLogger;
    private final ITARefinementStrategy<L> mStrategy;
    private NestedWordAutomaton<L, IPredicate> mInterpolantAutomaton;
    private List<QualifiedTracePredicates> mUsedTracePredicates;
    private final IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> mAfeResult;
    private final RefinementEngineStatisticsGenerator mAfeStatistics;

    public TraceAbstractionRefinementEngine(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ITARefinementStrategy<L> iTARefinementStrategy) {
        this.mLogger = iLogger;
        this.mStrategy = iTARefinementStrategy;
        AutomatonFreeRefinementEngine automatonFreeRefinementEngine = new AutomatonFreeRefinementEngine(iUltimateServiceProvider, iLogger, iTARefinementStrategy);
        this.mAfeResult = automatonFreeRefinementEngine.getResult();
        this.mAfeStatistics = automatonFreeRefinementEngine.getRefinementEngineStatistics();
        this.generateProof();
    }

    public RefinementEngineStatisticsGenerator getRefinementEngineStatistics() {
        return this.mAfeStatistics;
    }

    private void generateProof() {
        Script.LBool lBool = this.mAfeResult.getCounterexampleFeasibility();
        if (lBool != Script.LBool.UNSAT) {
            this.mInterpolantAutomaton = null;
            this.mUsedTracePredicates = null;
            return;
        }
        Collection collection = (Collection)this.mAfeResult.getInfeasibilityProof();
        IIpAbStrategyModule<L> iIpAbStrategyModule = this.mStrategy.getInterpolantAutomatonBuilder();
        this.logModule("Using interpolant automaton builder", iIpAbStrategyModule);
        try {
            List<QualifiedTracePredicates> list = collection.stream().filter(QualifiedTracePredicates::isPerfect).collect(Collectors.toList());
            List<QualifiedTracePredicates> list2 = collection.stream().filter(qualifiedTracePredicates -> !qualifiedTracePredicates.isPerfect()).collect(Collectors.toList());
            IIpAbStrategyModule.IpAbStrategyModuleResult<L> ipAbStrategyModuleResult = iIpAbStrategyModule.buildInterpolantAutomaton(list, list2);
            this.mInterpolantAutomaton = ipAbStrategyModuleResult.getAutomaton();
            this.mUsedTracePredicates = ipAbStrategyModuleResult.getUsedTracePredicates();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            throw new ToolchainCanceledException((IRunningTaskStackProvider)automataOperationCanceledException, new RunningTaskInfo(iIpAbStrategyModule.getClass(), "computing interpolant automaton"));
        }
    }

    private void logModule(String string, Object object) {
        this.mLogger.info("%s %s [%s]", new Object[]{string, object.getClass().getSimpleName(), object.hashCode()});
    }

    public IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> getResult() {
        return new IRefinementEngineResult.BasicRefinementEngineResult(this.mAfeResult.getCounterexampleFeasibility(), this.mInterpolantAutomaton, this.mAfeResult.getIcfgProgramExecution(), this.mAfeResult.somePerfectSequenceFound(), this.mUsedTracePredicates, new Lazy(() -> this.mAfeResult.getHoareTripleChecker()), new Lazy(() -> this.mAfeResult.getPredicateUnifier()));
    }

    public static interface ITARefinementStrategy<L extends IAction>
    extends IRefinementStrategy<L> {
        public IIpAbStrategyModule<L> getInterpolantAutomatonBuilder();

        public ITraceCheckStrategyModule<L, ?>[] getTraceCheckModules();
    }
}

