/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pathexpressions;

import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.GenericLabeledEdge;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.ILabeledEdge;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.ILabeledGraph;
import java.util.HashSet;
import java.util.Set;

public class GenericLabeledGraph<N, L>
implements ILabeledGraph<N, L> {
    protected final Set<N> mNodes;
    protected final Set<ILabeledEdge<N, L>> mEdges;

    public GenericLabeledGraph() {
        this(new HashSet(), new HashSet<ILabeledEdge<N, L>>());
    }

    protected GenericLabeledGraph(Set<N> set, Set<ILabeledEdge<N, L>> set2) {
        this.mNodes = set;
        this.mEdges = set2;
    }

    public boolean addNode(N n) {
        return this.mNodes.add(n);
    }

    public boolean addEdge(ILabeledEdge<N, L> iLabeledEdge) {
        this.addNode(iLabeledEdge.getSource());
        this.addNode(iLabeledEdge.getTarget());
        return this.mEdges.add(iLabeledEdge);
    }

    public boolean addEdge(N n, L l, N n2) {
        return this.addEdge(new GenericLabeledEdge<N, L>(n, l, n2));
    }

    @Override
    public Set<ILabeledEdge<N, L>> getEdges() {
        return this.mEdges;
    }

    @Override
    public Set<N> getNodes() {
        return this.mNodes;
    }

    public String toString() {
        return "nodes = " + String.valueOf(this.mNodes) + " edges = " + String.valueOf(this.mEdges);
    }
}

