/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.ConjunctGuards;
import de.uni_freiburg.informatik.ultimate.automata.counting.Counter;
import de.uni_freiburg.informatik.ultimate.automata.counting.FinalCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Guard;
import de.uni_freiburg.informatik.ultimate.automata.counting.InitialCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Transition;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CountingAutomaton<LETTER, STATE>
implements IAutomaton<LETTER, STATE> {
    protected final AutomataLibraryServices mServices;
    private Set<LETTER> mAlphabet;
    private Set<STATE> mStates;
    private ArrayList<Counter> mCounter;
    private Map<STATE, InitialCondition> mInitialConditions;
    private Map<STATE, FinalCondition> mFinalConditions;
    private Map<STATE, ArrayList<Transition<LETTER, STATE>>> mTransitions;

    public CountingAutomaton(AutomataLibraryServices automataLibraryServices) {
        this.mServices = automataLibraryServices;
    }

    public CountingAutomaton(AutomataLibraryServices automataLibraryServices, Set<LETTER> set, Set<STATE> set2, ArrayList<Counter> arrayList, Map<STATE, InitialCondition> map, Map<STATE, FinalCondition> map2, Map<STATE, ArrayList<Transition<LETTER, STATE>>> map3) {
        this.mServices = automataLibraryServices;
        this.mAlphabet = set;
        this.mStates = set2;
        this.mCounter = arrayList;
        this.mInitialConditions = map;
        this.mFinalConditions = map2;
        this.mTransitions = map3;
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mAlphabet;
    }

    public Set<STATE> getStates() {
        return this.mStates;
    }

    public ArrayList<Counter> getCounter() {
        return this.mCounter;
    }

    public Map<STATE, InitialCondition> getInitialConditions() {
        return this.mInitialConditions;
    }

    public Map<STATE, FinalCondition> getFinalConditions() {
        return this.mFinalConditions;
    }

    public Map<STATE, ArrayList<Transition<LETTER, STATE>>> getTransitions() {
        return this.mTransitions;
    }

    public void addTransition(STATE STATE, Transition<LETTER, STATE> transition) {
        ArrayList<Transition<LETTER, STATE>> arrayList = this.mTransitions.get(STATE);
        arrayList.add(transition);
        this.mTransitions.put(STATE, arrayList);
    }

    public void addInitialCondition(STATE STATE, ArrayList<ArrayList<Guard>> arrayList) {
        InitialCondition initialCondition = this.mInitialConditions.get(STATE);
        ConjunctGuards conjunctGuards = new ConjunctGuards(initialCondition.getCondition(), arrayList);
        InitialCondition initialCondition2 = new InitialCondition(conjunctGuards.getResult());
        this.mInitialConditions.put(STATE, initialCondition2);
    }

    public void addFinalCondition(STATE STATE, ArrayList<ArrayList<Guard>> arrayList) {
        FinalCondition finalCondition = this.mFinalConditions.get(STATE);
        ConjunctGuards conjunctGuards = new ConjunctGuards(finalCondition.getCondition(), arrayList);
        FinalCondition finalCondition2 = new FinalCondition(conjunctGuards.getResult());
        this.mFinalConditions.put(STATE, finalCondition2);
    }

    public CountingAutomaton<LETTER, STATE> copyCountingAutomaton() {
        Object object2;
        ArrayList<Counter> arrayList = new ArrayList<Counter>();
        for (Counter object22 : this.mCounter) {
            arrayList.add(object22.copyCounter());
        }
        HashMap<STATE, InitialCondition> hashMap = new HashMap<STATE, InitialCondition>();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        for (Object object2 : this.mStates) {
            InitialCondition initialCondition = this.mInitialConditions.get(object2).copyInitialCondition();
            hashMap.put(object2, initialCondition);
            FinalCondition finalCondition = this.mFinalConditions.get(object2).copyFinalCondition();
            hashMap2.put(object2, finalCondition);
            ArrayList<Transition<LETTER, STATE>> arrayList2 = new ArrayList<Transition<LETTER, STATE>>();
            for (Transition<LETTER, STATE> transition : this.mTransitions.get(object2)) {
                arrayList2.add(transition.copyTransition());
            }
            hashMap3.put(object2, arrayList2);
        }
        object2 = new CountingAutomaton<LETTER, STATE>(this.mServices, this.mAlphabet, this.mStates, arrayList, hashMap, hashMap2, hashMap3);
        return object2;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public String sizeInformation() {
        return null;
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        return null;
    }

    public String toString() {
        return AutomatonDefinitionPrinter.toString(this.mServices, "ca", this);
    }
}

