/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiClosureNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;

public final class BuchiClosure<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final INestedWordAutomaton<LETTER, STATE> mResult;

    public BuchiClosure(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = new BuchiClosureNwa<LETTER, STATE>(this.mServices, this.mOperand);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + " Operand " + this.mOperand.sizeInformation() + " thereof " + this.mOperand.getFinalStates().size() + " accepting";
    }

    @Override
    public String exitMessage() {
        return "Start " + this.getOperationName() + " Result " + this.mResult.sizeInformation() + " thereof " + this.mResult.getFinalStates().size() + " accepting";
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty;
        boolean bl;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        ArrayList<NestedLassoWord<LETTER>> arrayList = new ArrayList<NestedLassoWord<LETTER>>();
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty2 = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mOperand);
        boolean bl2 = buchiIsEmpty2.getResult();
        if (!bl2) {
            arrayList.add(buchiIsEmpty2.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        if (!(bl = (buchiIsEmpty = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mResult)).getResult().booleanValue())) {
            arrayList.add(buchiIsEmpty.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        boolean bl3 = true;
        assert (bl3 &= bl2 == bl);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl3;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }
}

