/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UnionIndependenceRelation<STATE, L>
implements IIndependenceRelation<STATE, L> {
    private final Collection<IIndependenceRelation<STATE, L>> mRelations;
    private final Function<Stream<STATE>, STATE> mAggregateConditions;
    private final boolean mSymmetric;
    private final boolean mConditional;
    private final IndependenceStatisticsDataProvider mStatistics;

    public UnionIndependenceRelation(Collection<IIndependenceRelation<STATE, L>> collection) {
        this(collection, null);
    }

    public UnionIndependenceRelation(Collection<IIndependenceRelation<STATE, L>> collection, Function<Stream<STATE>, STATE> function) {
        this.mRelations = collection;
        this.mAggregateConditions = function;
        this.mSymmetric = collection.stream().allMatch(IIndependenceRelation::isSymmetric);
        this.mConditional = collection.stream().anyMatch(IIndependenceRelation::isConditional);
        this.mStatistics = new IndependenceStatisticsDataProvider(UnionIndependenceRelation.class, this.mRelations);
    }

    @Override
    public boolean isSymmetric() {
        return this.mSymmetric;
    }

    @Override
    public boolean isConditional() {
        return this.mConditional;
    }

    @Override
    public IIndependenceRelation.Dependence isIndependent(STATE STATE, L l, L l2) {
        boolean bl = false;
        for (IIndependenceRelation<STATE, L> iIndependenceRelation : this.mRelations) {
            IIndependenceRelation.Dependence dependence = iIndependenceRelation.isIndependent(STATE, l, l2);
            if (dependence == IIndependenceRelation.Dependence.INDEPENDENT) {
                this.mStatistics.reportIndependentQuery(STATE != null);
                return IIndependenceRelation.Dependence.INDEPENDENT;
            }
            bl |= dependence == IIndependenceRelation.Dependence.UNKNOWN;
        }
        if (bl) {
            this.mStatistics.reportUnknownQuery(STATE != null);
            return IIndependenceRelation.Dependence.UNKNOWN;
        }
        this.mStatistics.reportDependentQuery(STATE != null);
        return IIndependenceRelation.Dependence.DEPENDENT;
    }

    @Override
    public ISymbolicIndependenceRelation<L, STATE> getSymbolicRelation() {
        if (this.mAggregateConditions == null || !this.mConditional) {
            return null;
        }
        List list = this.mRelations.stream().map(IIndependenceRelation::getSymbolicRelation).filter(iSymbolicIndependenceRelation -> iSymbolicIndependenceRelation != null).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return new SymbolicUnionIndependence(list);
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    private class SymbolicUnionIndependence
    implements ISymbolicIndependenceRelation<L, STATE> {
        private final Collection<ISymbolicIndependenceRelation<L, STATE>> mSymbolicRelations;
        private final boolean mSymbolicConditional;

        public SymbolicUnionIndependence(Collection<ISymbolicIndependenceRelation<L, STATE>> collection) {
            this.mSymbolicRelations = collection;
            this.mSymbolicConditional = this.mSymbolicRelations.stream().anyMatch(ISymbolicIndependenceRelation::isConditional);
        }

        @Override
        public STATE getCommutativityCondition(STATE STATE, L l, L l2) {
            return UnionIndependenceRelation.this.mAggregateConditions.apply(this.mSymbolicRelations.stream().map(iSymbolicIndependenceRelation -> iSymbolicIndependenceRelation.getCommutativityCondition(STATE, l, l2)).filter(object -> object != null));
        }

        @Override
        public boolean isSymmetric() {
            return UnionIndependenceRelation.this.mSymmetric;
        }

        @Override
        public boolean isConditional() {
            return this.mSymbolicConditional;
        }
    }
}

