/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.rabin.Rabin2BuchiAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public class ToBuchi<LETTER, STATE, CRSF extends IBlackWhiteStateFactory<STATE> & IEmptyStackStateFactory<STATE>>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final Rabin2BuchiAutomaton<LETTER, STATE, CRSF> mConversionAutomaton;
    private final IRabinAutomaton<LETTER, STATE> mRabinAutomaton;

    public ToBuchi(AutomataLibraryServices automataLibraryServices, CRSF CRSF, IRabinAutomaton<LETTER, STATE> iRabinAutomaton) {
        super(automataLibraryServices);
        this.mConversionAutomaton = new Rabin2BuchiAutomaton<LETTER, STATE, CRSF>(iRabinAutomaton, CRSF);
        this.mRabinAutomaton = iRabinAutomaton;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getResult() {
        return this.mConversionAutomaton;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataOperationCanceledException {
        return new IsEmpty(this.mServices, this.mRabinAutomaton).getResult() == new BuchiIsEmpty(this.mServices, this.mConversionAutomaton).getResult();
    }
}

