/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.DagInterpreter;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ProcedureResourceCache;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ProcedureResources;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ICallSummarizer;

public class InterpretCallSummarizer
implements ICallSummarizer {
    private final SifaStats mStats;
    private final ProcedureResourceCache mProcResCache;
    private final DagInterpreter mDagIpreter;

    public InterpretCallSummarizer(SifaStats sifaStats, ProcedureResourceCache procedureResourceCache, DagInterpreter dagInterpreter) {
        this.mStats = sifaStats;
        this.mProcResCache = procedureResourceCache;
        this.mDagIpreter = dagInterpreter;
    }

    @Override
    public IPredicate summarize(String string, IPredicate iPredicate) {
        this.mStats.start(SifaStats.Key.CALL_SUMMARIZER_NEW_COMPUTATION_TIME);
        this.mStats.increment(SifaStats.Key.CALL_SUMMARIZER_CACHE_MISSES);
        ProcedureResources procedureResources = this.mProcResCache.resourcesOf(string);
        IPredicate iPredicate2 = this.mDagIpreter.interpretForSingleMarker(procedureResources.getRegexDag(), procedureResources.getDagOverlayPathToReturn(), iPredicate);
        this.mStats.stop(SifaStats.Key.CALL_SUMMARIZER_NEW_COMPUTATION_TIME);
        return iPredicate2;
    }
}

