/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;

public abstract class NestedFormulas<L extends IAction, TF, SF> {
    private final Counterexample<L> mCounterexample;
    private SF mPrecondition;
    private SF mPostcondition;
    private final SortedMap<Integer, SF> mPendingContexts;

    public NestedFormulas(Counterexample<L> counterexample, SortedMap<Integer, SF> sortedMap) {
        this.mCounterexample = counterexample;
        assert (sortedMap != null);
        this.mPendingContexts = sortedMap;
    }

    public final NestedWord<L> getTrace() {
        return this.mCounterexample.getWord();
    }

    public final Counterexample<L> getCounterexample() {
        return this.mCounterexample;
    }

    public final List<Object> getControlConfigurations() {
        return this.mCounterexample.getControlConfigurations();
    }

    public final SF getPrecondition() {
        return this.mPrecondition;
    }

    public void setPrecondition(SF SF) {
        assert (this.mPrecondition == null) : "already set";
        this.mPrecondition = SF;
    }

    public final SF getPostcondition() {
        return this.mPostcondition;
    }

    public void setPostcondition(SF SF) {
        assert (this.mPostcondition == null) : "already set";
        this.mPostcondition = SF;
    }

    public SF getPendingContext(int n) {
        assert (this.getTrace().isPendingReturn(n)) : "no pending return";
        return (SF)this.mPendingContexts.get(n);
    }

    public void setPendingContext(int n, SF SF) {
        assert (!this.mPendingContexts.containsKey(n)) : "already set";
        assert (this.getTrace().isPendingReturn(n)) : "no pending return";
        this.mPendingContexts.put(n, SF);
    }

    public final Set<Integer> callPositions() {
        return this.getTrace().getCallPositions();
    }

    public final TF getFormulaFromNonCallPos(int n) {
        assert (n >= 0 && n < this.getTrace().length()) : "out of range";
        assert (!this.getTrace().isCallPosition(n)) : "call position";
        return this.getFormulaFromValidNonCallPos(n);
    }

    protected abstract TF getFormulaFromValidNonCallPos(int var1);

    public TF getLocalVarAssignment(int n) {
        assert (n >= 0 && n < this.getTrace().length()) : "out of range";
        assert (this.callPositions().contains(n) || this.getTrace().isPendingReturn(n)) : "neither call nor pending return position";
        assert (this.getTrace().isCallPosition(n) || this.getTrace().isPendingReturn(n)) : "neither call nor pending return position";
        return this.getLocalVarAssignmentFromValidPos(n);
    }

    protected abstract TF getLocalVarAssignmentFromValidPos(int var1);

    public TF getGlobalVarAssignment(int n) {
        assert (n >= 0 && n < this.getTrace().length()) : "out of range";
        assert (this.callPositions().contains(n)) : "no call position";
        assert (this.getTrace().isCallPosition(n)) : "no call position";
        return this.getGlobalVarAssignmentFromValidPos(n);
    }

    protected abstract TF getGlobalVarAssignmentFromValidPos(int var1);

    public TF getOldVarAssignment(int n) {
        assert (n >= 0 && n < this.getTrace().length()) : "out of range";
        assert (this.callPositions().contains(n) || this.getTrace().isPendingReturn(n)) : "neither call nor pending return position";
        assert (this.getTrace().isCallPosition(n) || this.getTrace().isPendingReturn(n)) : "neither call nor pending return position";
        return this.getOldVarAssignmentFromValidPos(n);
    }

    protected abstract TF getOldVarAssignmentFromValidPos(int var1);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.getTrace().length()) {
            if (this.getTrace().isCallPosition(n)) {
                stringBuilder.append("Position " + n + " (call): ");
                var3_3 = this.getLocalVarAssignment(n);
                stringBuilder.append(var3_3);
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append("\t GlobalVarAssignment: ");
                TF TF = this.getGlobalVarAssignment(n);
                stringBuilder.append(TF);
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append("\t OldVarAssignment: ");
                TF TF2 = this.getOldVarAssignment(n);
                stringBuilder.append(TF2);
            } else if (this.getTrace().isReturnPosition(n)) {
                stringBuilder.append("Position " + n + " (return): ");
                var3_3 = this.getFormulaFromNonCallPos(n);
                stringBuilder.append(var3_3);
            } else {
                stringBuilder.append("Position " + n + " (internal): ");
                var3_3 = this.getFormulaFromNonCallPos(n);
                stringBuilder.append(var3_3);
            }
            stringBuilder.append(System.lineSeparator());
            ++n;
        }
        return stringBuilder.toString();
    }
}

