/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

public class IntAllocator {
    private IntervalNode mRoot;

    public IntAllocator(int n, int n2) {
        this.mRoot = new IntervalNode(n, n2);
    }

    public boolean isEmpty() {
        return this.mRoot == null;
    }

    public int alloc() {
        if (this.mRoot.mLow == this.mRoot.mUp) {
            throw new RuntimeException("Allocation on empty IntAllocator");
        }
        IntervalNode intervalNode = this.mRoot;
        IntervalNode intervalNode2 = null;
        while (intervalNode.mLeft != null) {
            intervalNode2 = intervalNode;
            intervalNode = intervalNode.mLeft;
        }
        int n = intervalNode.mLow++;
        if (intervalNode.mLow == intervalNode.mUp) {
            if (intervalNode2 == null) {
                this.mRoot = intervalNode.mRight;
            } else {
                intervalNode2.mLeft = intervalNode.mRight;
            }
        }
        return n;
    }

    public int[] alloc(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.alloc();
            ++n2;
        }
        return nArray;
    }

    public void free(int n) {
        if (this.mRoot != null) {
            IntervalNode intervalNode = this.mRoot;
            while (true) {
                if (n + 1 == intervalNode.mLow) {
                    intervalNode.mLow = n;
                    this.joinLeft(intervalNode);
                    return;
                }
                if (n == intervalNode.mUp) {
                    ++intervalNode.mUp;
                    this.joinRight(intervalNode);
                    return;
                }
                if (n < intervalNode.mLow) {
                    if (intervalNode.mLeft == null) {
                        intervalNode.mLeft = new IntervalNode(n, n + 1);
                        return;
                    }
                    intervalNode = intervalNode.mLeft;
                    continue;
                }
                if (intervalNode.mRight == null) {
                    intervalNode.mRight = new IntervalNode(n, n + 1);
                    return;
                }
                intervalNode = intervalNode.mRight;
            }
        }
        this.mRoot = new IntervalNode(n, n + 1);
    }

    public void free(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            this.free(n3);
            ++n2;
        }
    }

    private void joinLeft(IntervalNode intervalNode) {
        IntervalNode intervalNode2 = intervalNode.mLeft;
        if (intervalNode2 == null) {
            return;
        }
        IntervalNode intervalNode3 = intervalNode;
        while (intervalNode2.mRight != null) {
            intervalNode3 = intervalNode2;
            intervalNode2 = intervalNode2.mRight;
        }
        if (intervalNode.mLow == intervalNode2.mUp) {
            intervalNode.mLow = intervalNode2.mLow;
            if (intervalNode3 == intervalNode) {
                intervalNode3.mLeft = intervalNode2.mLeft;
            } else {
                intervalNode3.mRight = intervalNode2.mLeft;
            }
        }
    }

    private void joinRight(IntervalNode intervalNode) {
        IntervalNode intervalNode2 = intervalNode.mRight;
        if (intervalNode2 == null) {
            return;
        }
        IntervalNode intervalNode3 = intervalNode;
        while (intervalNode2.mLeft != null) {
            intervalNode3 = intervalNode2;
            intervalNode2 = intervalNode2.mLeft;
        }
        if (intervalNode.mUp == intervalNode2.mLow) {
            intervalNode.mUp = intervalNode2.mUp;
            if (intervalNode3 == intervalNode) {
                intervalNode3.mRight = intervalNode2.mRight;
            } else {
                intervalNode3.mLeft = intervalNode2.mRight;
            }
        }
    }

    public int peekLast() {
        if (this.mRoot.mLow == this.mRoot.mUp) {
            return this.mRoot.mLow - 1;
        }
        IntervalNode intervalNode = this.mRoot;
        while (intervalNode.mRight != null) {
            intervalNode = intervalNode.mRight;
        }
        return intervalNode.mLow - 1;
    }

    private static class IntervalNode {
        int mLow;
        int mUp;
        IntervalNode mLeft;
        IntervalNode mRight;

        public IntervalNode(int n, int n2) {
            this.mLow = n;
            this.mUp = n2;
            this.mRight = null;
            this.mLeft = null;
        }
    }
}

