/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.ConstantArrayUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.FunctionDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DataRaceAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DataRaceChecker {
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final MemoryHandler mMemoryHandler;
    private final ITypeHandler mTypeHandler;
    private final TypeSizeAndOffsetComputer mTypeSizeComputer;
    private final TypeSizes mTypeSizes;
    private final ProcedureManager mProcedureManager;
    private final FunctionDeclarations mFunDecl;
    private final Map<String, BoogieType> mRaceIndicators = new HashMap<String, BoogieType>();

    public DataRaceChecker(AuxVarInfoBuilder auxVarInfoBuilder, MemoryHandler memoryHandler, ITypeHandler iTypeHandler, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, TypeSizes typeSizes, ProcedureManager procedureManager, FunctionDeclarations functionDeclarations) {
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mMemoryHandler = memoryHandler;
        this.mTypeHandler = iTypeHandler;
        this.mTypeSizeComputer = typeSizeAndOffsetComputer;
        this.mTypeSizes = typeSizes;
        this.mProcedureManager = procedureManager;
        this.mFunDecl = functionDeclarations;
    }

    public void checkOnRead(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation, LRValue lRValue) {
        if (this.mProcedureManager.isGlobalScope()) {
            return;
        }
        if (DataRaceChecker.isRaceImpossible(lRValue)) {
            return;
        }
        Expression expression = this.createRaceRead();
        DataRaceAnnotation.Race[] raceArray = this.updateRaceIndicator(expressionResultBuilder, iLocation, lRValue, expression, false);
        this.addAssert(expressionResultBuilder, iLocation, lRValue, expression, raceArray);
    }

    private Expression createRaceRead() {
        return this.mMemoryHandler.getBooleanArrayHelper().constructFalse();
    }

    public void checkOnWrite(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation, LRValue lRValue) {
        if (this.mProcedureManager.isGlobalScope()) {
            return;
        }
        if (DataRaceChecker.isRaceImpossible(lRValue)) {
            return;
        }
        Expression expression = this.createRaceWrite(expressionResultBuilder, iLocation);
        DataRaceAnnotation.Race[] raceArray = this.updateRaceIndicator(expressionResultBuilder, iLocation, lRValue, expression, true);
        this.addAssert(expressionResultBuilder, iLocation, lRValue, expression, raceArray);
    }

    private Expression createRaceWrite(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation) {
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, this.getBoolASTType(), SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        HavocStatement havocStatement = new HavocStatement(iLocation, new VariableLHS[]{auxVarInfo.getLhs()});
        expressionResultBuilder.addStatement((Statement)havocStatement);
        return auxVarInfo.getExp();
    }

    private DataRaceAnnotation.Race[] updateRaceIndicator(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation, LRValue lRValue, Expression expression, boolean bl) {
        LeftHandSide[] leftHandSideArray = this.getRaceLhs(iLocation, lRValue);
        DataRaceAnnotation.Race[] raceArray = new DataRaceAnnotation.Race[leftHandSideArray.length];
        int n = 0;
        while (n < leftHandSideArray.length) {
            AssignmentStatement assignmentStatement = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new LeftHandSide[]{leftHandSideArray[n]}, (Expression[])new Expression[]{this.wrapRaceIndicatorValue(iLocation, expression, leftHandSideArray[n].getType())});
            raceArray[n] = DataRaceAnnotation.annotateAccess((IElement)assignmentStatement, (String)DataRaceChecker.getAccessPath(lRValue), (ILocation)iLocation, (boolean)bl);
            expressionResultBuilder.addStatement((Statement)assignmentStatement);
            ++n;
        }
        return raceArray;
    }

    private void addAssert(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation, LRValue lRValue, Expression expression, DataRaceAnnotation.Race[] raceArray) {
        Check check = new Check(Spec.DATA_RACE);
        Expression expression3 = ExpressionFactory.and((ILocation)iLocation, this.getRaceExpressions(iLocation, lRValue).map(expression2 -> ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression2, (Expression)this.wrapRaceIndicatorValue(iLocation, expression, expression2.getType()))).collect(Collectors.toList()));
        AssertStatement assertStatement = new AssertStatement(iLocation, expression3);
        check.annotate((IElement)assertStatement);
        DataRaceAnnotation.annotateCheck((IElement)assertStatement, (DataRaceAnnotation.Race[])raceArray, (ILocation)iLocation);
        expressionResultBuilder.addStatement((Statement)assertStatement);
    }

    private static String getAccessPath(LRValue lRValue) {
        if (lRValue instanceof LocalLValue) {
            ImmutableList<String> immutableList = DataRaceChecker.getAccessPath(((LocalLValue)lRValue).getLhs());
            if (immutableList == null) {
                return null;
            }
            return immutableList.stream().collect(Collectors.joining("->"));
        }
        return null;
    }

    private static ImmutableList<String> getAccessPath(LeftHandSide leftHandSide) {
        LeftHandSide leftHandSide2 = leftHandSide;
        Objects.requireNonNull(leftHandSide2);
        LeftHandSide leftHandSide3 = leftHandSide2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableLHS.class, StructLHS.class, ArrayLHS.class}, (Object)leftHandSide3, 0)) {
            case 0: {
                VariableLHS variableLHS = (VariableLHS)leftHandSide3;
                return ImmutableList.singleton((Object)variableLHS.getIdentifier());
            }
            case 1: {
                StructLHS structLHS = (StructLHS)leftHandSide3;
                ImmutableList<String> immutableList = DataRaceChecker.getAccessPath(structLHS.getStruct());
                if (immutableList == null) {
                    return null;
                }
                return new ImmutableList((Object)structLHS.getField(), immutableList);
            }
            case 2: {
                ArrayLHS arrayLHS = (ArrayLHS)leftHandSide3;
                return null;
            }
        }
        throw new MatchException(null, null);
    }

    private static boolean isRaceImpossible(LRValue lRValue) {
        if (lRValue.getCType().isAtomic()) {
            return true;
        }
        if (lRValue instanceof HeapLValue) {
            IdentifierExpression identifierExpression;
            HeapLValue heapLValue = (HeapLValue)lRValue;
            Expression expression = heapLValue.getAddress();
            return expression instanceof IdentifierExpression && (identifierExpression = (IdentifierExpression)expression).getIdentifier().startsWith("#funAddr~");
        }
        if (!(lRValue instanceof LocalLValue)) {
            return false;
        }
        LocalLValue localLValue = (LocalLValue)lRValue;
        VariableLHS variableLHS = DataRaceChecker.getRootLhs(localLValue.getLhs());
        return switch (variableLHS.getDeclarationInformation().getStorageClass()) {
            case DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, DeclarationInformation.StorageClass.LOCAL, DeclarationInformation.StorageClass.PROC_FUNC -> true;
            case DeclarationInformation.StorageClass.GLOBAL, DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, DeclarationInformation.StorageClass.QUANTIFIED, DeclarationInformation.StorageClass.IMPLEMENTATION -> false;
            default -> throw new MatchException(null, null);
        };
    }

    private static VariableLHS getRootLhs(LeftHandSide leftHandSide) {
        LeftHandSide leftHandSide2 = leftHandSide;
        Objects.requireNonNull(leftHandSide2);
        LeftHandSide leftHandSide3 = leftHandSide2;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StructLHS.class, ArrayLHS.class, VariableLHS.class}, (Object)leftHandSide3, 0)) {
            case 0 -> {
                StructLHS var2_2 = (StructLHS)leftHandSide3;
                yield DataRaceChecker.getRootLhs(var2_2.getStruct());
            }
            case 1 -> {
                ArrayLHS var3_3 = (ArrayLHS)leftHandSide3;
                yield DataRaceChecker.getRootLhs(var3_3.getArray());
            }
            case 2 -> {
                VariableLHS var4_4;
                yield var4_4 = (VariableLHS)leftHandSide3;
            }
            default -> throw new MatchException(null, null);
        };
    }

    private LeftHandSide[] getRaceLhs(ILocation iLocation, LRValue lRValue) {
        if (lRValue instanceof HeapLValue) {
            HeapLValue heapLValue = (HeapLValue)lRValue;
            VariableLHS variableLHS = this.mMemoryHandler.getMemoryRaceArrayLhs(iLocation);
            LeftHandSide[] leftHandSideArray = new LeftHandSide[this.getTypeSize(iLocation, heapLValue.getUnderlyingType())];
            int n = 0;
            while (n < leftHandSideArray.length) {
                Expression expression = this.mMemoryHandler.addIntegerConstantToPointer(iLocation, heapLValue.getAddress(), BigInteger.valueOf(n));
                leftHandSideArray[n] = ExpressionFactory.constructNestedArrayLHS((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression[])new Expression[]{expression});
                ++n;
            }
            return leftHandSideArray;
        }
        if (lRValue instanceof LocalLValue) {
            LocalLValue localLValue = (LocalLValue)lRValue;
            return new LeftHandSide[]{this.getRaceIndicatorLhs(iLocation, localLValue)};
        }
        throw new UnsupportedOperationException();
    }

    private Stream<Expression> getRaceExpressions(ILocation iLocation, LRValue lRValue) {
        return Arrays.stream(this.getRaceLhs(iLocation, lRValue)).map(CTranslationUtil::convertLhsToExpression);
    }

    private int getTypeSize(ILocation iLocation, ICType iCType) {
        Expression expression = this.mTypeSizeComputer.constructBytesizeExpression(iLocation, iCType);
        return this.mTypeSizes.extractIntegerValue(expression, this.mTypeSizeComputer.getSizeT()).intValueExact();
    }

    private LeftHandSide getRaceIndicatorLhs(ILocation iLocation, LocalLValue localLValue) {
        return this.createRaceIndicatorLhs(iLocation, localLValue.getLhs());
    }

    private LeftHandSide createRaceIndicatorLhs(ILocation iLocation, LeftHandSide leftHandSide) {
        LeftHandSide leftHandSide2 = leftHandSide;
        Objects.requireNonNull(leftHandSide2);
        LeftHandSide leftHandSide3 = leftHandSide2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableLHS.class, ArrayLHS.class, StructLHS.class}, (Object)leftHandSide3, 0)) {
            case 0: {
                VariableLHS variableLHS = (VariableLHS)leftHandSide3;
                String string = "#race" + variableLHS.getIdentifier();
                VariableLHS variableLHS2 = new VariableLHS(iLocation, (IBoogieType)this.getRaceIndicatorType(variableLHS.getType()), string, DeclarationInformation.DECLARATIONINFO_GLOBAL);
                assert (this.mRaceIndicators.getOrDefault(string, (BoogieType)variableLHS2.getType()).equals((Object)variableLHS2.getType())) : "Ambiguous types for " + string + ": " + String.valueOf(this.mRaceIndicators.get(string)) + " vs. " + String.valueOf(variableLHS2.getType());
                this.mRaceIndicators.put(string, (BoogieType)variableLHS2.getType());
                return variableLHS2;
            }
            case 1: {
                ArrayLHS arrayLHS = (ArrayLHS)leftHandSide3;
                LeftHandSide leftHandSide4 = this.createRaceIndicatorLhs(iLocation, arrayLHS.getArray());
                return ExpressionFactory.constructNestedArrayLHS((ILocation)iLocation, (LeftHandSide)leftHandSide4, (Expression[])arrayLHS.getIndices());
            }
            case 2: {
                StructLHS structLHS = (StructLHS)leftHandSide3;
                LeftHandSide leftHandSide5 = this.createRaceIndicatorLhs(iLocation, structLHS.getStruct());
                return ExpressionFactory.constructStructAccessLhs((ILocation)iLocation, (LeftHandSide)leftHandSide5, (String)structLHS.getField());
            }
        }
        throw new MatchException(null, null);
    }

    private BoogieType getRaceIndicatorType(IBoogieType iBoogieType) {
        if (iBoogieType instanceof BoogiePrimitiveType || iBoogieType.equals(this.mTypeHandler.getBoogiePointerType())) {
            return this.getBoolType();
        }
        if (iBoogieType instanceof BoogieArrayType) {
            BoogieArrayType boogieArrayType = (BoogieArrayType)iBoogieType;
            assert (boogieArrayType.getNumPlaceholders() == 0);
            BoogieType[] boogieTypeArray = new BoogieType[boogieArrayType.getIndexCount()];
            int n = 0;
            while (n < boogieTypeArray.length) {
                boogieTypeArray[n] = boogieArrayType.getIndexType(n);
                ++n;
            }
            return BoogieType.createArrayType((int)0, (BoogieType[])boogieTypeArray, (BoogieType)this.getRaceIndicatorType((IBoogieType)boogieArrayType.getValueType()));
        }
        if (iBoogieType instanceof BoogieStructType) {
            BoogieStructType boogieStructType = (BoogieStructType)iBoogieType;
            BoogieType[] boogieTypeArray = (BoogieType[])Arrays.stream(boogieStructType.getFieldTypes()).map(this::getRaceIndicatorType).toArray(BoogieType[]::new);
            return BoogieType.createStructType((String[])boogieStructType.getFieldIds(), (BoogieType[])boogieTypeArray);
        }
        throw new UnsupportedOperationException("Cannot detect races for values of type " + String.valueOf(iBoogieType));
    }

    private Expression wrapRaceIndicatorValue(ILocation iLocation, Expression expression, IBoogieType iBoogieType) {
        if (iBoogieType instanceof BoogiePrimitiveType || iBoogieType.equals(this.mTypeHandler.getBoogiePointerType())) {
            return expression;
        }
        if (iBoogieType instanceof BoogieArrayType) {
            BoogieArrayType boogieArrayType = (BoogieArrayType)iBoogieType;
            return ConstantArrayUtil.getConstantArray(this.mFunDecl, iLocation, boogieArrayType, expression);
        }
        if (iBoogieType instanceof BoogieStructType) {
            BoogieStructType boogieStructType = (BoogieStructType)iBoogieType;
            Expression[] expressionArray = (Expression[])Arrays.stream(boogieStructType.getFieldTypes()).map(boogieType -> this.wrapRaceIndicatorValue(iLocation, expression, (IBoogieType)boogieType)).toArray(Expression[]::new);
            return ExpressionFactory.constructStructConstructor((ILocation)iLocation, (String[])boogieStructType.getFieldIds(), (Expression[])expressionArray);
        }
        throw new UnsupportedOperationException("Cannot detect races for values of type " + String.valueOf(iBoogieType));
    }

    public Collection<Declaration> declareRaceCheckingInfrastructure(ILocation iLocation) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        arrayList.add(this.constructMemoryRaceArrayDeclaration(iLocation));
        for (Map.Entry<String, BoogieType> entry : this.mRaceIndicators.entrySet()) {
            VarList varList = new VarList(iLocation, new String[]{entry.getKey()}, entry.getValue().toASTType(iLocation));
            arrayList.add((Declaration)new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{varList}));
        }
        return arrayList;
    }

    private Declaration constructMemoryRaceArrayDeclaration(ILocation iLocation) {
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)this.getBoolType());
        ArrayType arrayType = new ArrayType(iLocation, (IBoogieType)boogieArrayType, new String[0], new ASTType[]{this.mTypeHandler.constructPointerType(iLocation)}, this.getBoolASTType());
        VarList varList = new VarList(iLocation, new String[]{MemoryModelDeclarations.ULTIMATE_DATA_RACE_MEMORY.getName()}, (ASTType)arrayType);
        return new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{varList});
    }

    private ASTType getBoolASTType() {
        return this.mMemoryHandler.getBooleanArrayHelper().constructBoolReplacementType();
    }

    private BoogieType getBoolType() {
        return this.mTypeHandler.getBoogieTypeForBoogieASTType(this.getBoolASTType());
    }
}

