/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import java.util.ArrayList;

public class ProcedureSignature {
    private final ArrayList<ASTType> mInParams = new ArrayList();
    private final ASTType mReturnType;
    private final boolean mTakesVarArgs;
    private final String mStringRepresentation;

    public ProcedureSignature(ITypeHandler iTypeHandler, CFunction cFunction) {
        CDeclaration[] cDeclarationArray = cFunction.getParameterTypes();
        int n = cDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDeclaration cDeclaration = cDeclarationArray[n2];
            ASTType aSTType = iTypeHandler.cType2AstType(LocationFactory.createIgnoreCLocation(), cDeclaration.getType());
            this.mInParams.add(aSTType);
            ++n2;
        }
        this.mReturnType = cFunction.getResultType().isVoidType() ? null : iTypeHandler.cType2AstType(LocationFactory.createIgnoreCLocation(), cFunction.getResultType());
        this.mTakesVarArgs = cFunction.hasVarArgs();
        this.mStringRepresentation = this.buildStringRepresentation();
    }

    public ASTType getReturnType() {
        return this.mReturnType;
    }

    public String toString() {
        return this.mStringRepresentation;
    }

    private String buildStringRepresentation() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("##fun~");
        String string = "";
        for (ASTType aSTType : this.mInParams) {
            stringBuilder.append(string);
            this.flattenASTTypeName(aSTType, stringBuilder);
            string = "~X~";
        }
        if (this.mTakesVarArgs) {
            stringBuilder.append("X~varArgs~");
        }
        stringBuilder.append("~TO~");
        stringBuilder.append(this.mReturnType != null ? BoogiePrettyPrinter.print((ASTType)this.mReturnType) : "VOID");
        return stringBuilder.toString();
    }

    private StringBuilder flattenASTTypeName(ASTType aSTType, StringBuilder stringBuilder) {
        if (aSTType instanceof StructType) {
            VarList[] varListArray;
            stringBuilder.append("~structbegin~");
            StructType structType = (StructType)aSTType;
            VarList[] varListArray2 = varListArray = structType.getFields();
            int n = varListArray.length;
            int n2 = 0;
            while (n2 < n) {
                VarList varList = varListArray2[n2];
                StringBuilder stringBuilder2 = this.flattenASTTypeName(varList.getType(), new StringBuilder());
                int n3 = 0;
                while (n3 < varList.getIdentifiers().length) {
                    stringBuilder.append((CharSequence)stringBuilder2);
                    ++n3;
                }
                ++n2;
            }
            stringBuilder.append("~structend~");
        } else {
            stringBuilder.append(BoogiePrettyPrinter.print((ASTType)aSTType));
        }
        return stringBuilder;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ProcedureSignature procedureSignature = (ProcedureSignature)object;
        boolean bl2 = bl = this.mTakesVarArgs == procedureSignature.mTakesVarArgs && TypeManager.isEquivalent((ASTType)this.mReturnType, (ASTType)procedureSignature.mReturnType) && TypeManager.areEquivalent(this.mInParams, procedureSignature.mInParams);
        assert (bl == this.toString().equals(object.toString())) : "disagreement between string repr and data";
        return bl;
    }

    public int hashCode() {
        return this.mStringRepresentation.hashCode();
    }
}

