/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.INameHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class SvcompLibraryModel
implements ILibraryModel {
    private static final boolean HAVOC_NONDET_AUXVARS_ALSO_BEFORE = true;
    private final FunctionModelHelper mHelper;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final ExpressionTranslation mExpressionTranslation;
    private final INameHandler mNameHandler;
    private final boolean mCheckErrorFunction;
    private final ExpressionResultTransformer mExprResultTransformer;

    public SvcompLibraryModel(FunctionModelHelper functionModelHelper, AuxVarInfoBuilder auxVarInfoBuilder, ExpressionTranslation expressionTranslation, INameHandler iNameHandler, boolean bl, ExpressionResultTransformer expressionResultTransformer) {
        this.mHelper = functionModelHelper;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mExpressionTranslation = expressionTranslation;
        this.mNameHandler = iNameHandler;
        this.mCheckErrorFunction = bl;
        this.mExprResultTransformer = expressionResultTransformer;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        ArrayList<ILibraryModel.FunctionModel> arrayList = new ArrayList<ILibraryModel.FunctionModel>();
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_ltl_step", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> SvcompLibraryModel.handleLtlStep(iDispatcher, iASTFunctionCallExpression, iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_error", this::handleErrorFunction));
        arrayList.add(new ILibraryModel.FunctionModel("reach_error", this::handleErrorFunction));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_assume", this::handleVerifierAssume));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_bool", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNondetBool(iDispatcher, iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet__Bool", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNondetBool(iDispatcher, iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_char", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.CHAR))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_pchar", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_charp", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_float", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_double", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_int", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_long", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.LONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_longlong", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.LONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_int128", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.INT128))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_short", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.SHORT))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_uchar", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.UCHAR))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_unsigned_char", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.UCHAR))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_unsigned", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.UINT))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_unsigned_int", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.UINT))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_uint", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.UINT))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_ulong", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_ulonglong", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.ULONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_uint128", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.UINT128))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_ushort", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.USHORT))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_loff_t", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.LONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_size_t", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_pthread_t", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_sector_t", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_u8", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.UCHAR))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_u16", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.USHORT))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_nondet_u32", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleVerifierNonDet(iDispatcher, iLocation, new CPrimitive(CPrimitive.CPrimitives.UINT))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_atomic_begin", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleByFunctionCall(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.VOID))));
        arrayList.add(new ILibraryModel.FunctionModel("__VERIFIER_atomic_end", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleByFunctionCall(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.VOID))));
        return arrayList;
    }

    private ExpressionResult handleVerifierNondetBool(IDispatcher iDispatcher, ILocation iLocation) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.BOOL);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)new HavocStatement(iLocation, new VariableLHS[]{auxVarInfo.getLhs()}));
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), cPrimitive));
        Expression expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)auxVarInfo.getExp(), (Expression)this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO));
        Expression expression2 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)auxVarInfo.getExp(), (Expression)this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ONE));
        expressionResultBuilder.addStatement((Statement)new AssumeStatement(iLocation, ExpressionFactory.or((ILocation)iLocation, List.of(expression, expression2))));
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, expressionResultBuilder.getDeclarations(), expressionResultBuilder.getAuxVars()));
        return expressionResultBuilder.build();
    }

    private ExpressionResult handleVerifierNonDet(IDispatcher iDispatcher, ILocation iLocation, ICType iCType) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)new HavocStatement(iLocation, new VariableLHS[]{auxVarInfo.getLhs()}));
        RValue rValue = new RValue((Expression)auxVarInfo.getExp(), iCType);
        expressionResultBuilder.setLrValue(rValue);
        this.mExpressionTranslation.addAssumeValueInRangeStatements(iLocation, ((LRValue)rValue).getValue(), rValue.getCType(), expressionResultBuilder);
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, expressionResultBuilder.getDeclarations(), expressionResultBuilder.getAuxVars()));
        return expressionResultBuilder.build();
    }

    private Result handleErrorFunction(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        BooleanLiteral booleanLiteral = ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)false);
        Statement statement = this.mHelper.createAnnotatedAssertOrAssume(iLocation, string, this.mCheckErrorFunction, Spec.ERROR_FUNCTION, (Expression)booleanLiteral);
        return new ExpressionResult(Collections.singletonList(statement), null);
    }

    private ExpressionResult handleByFunctionCall(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, ICType iCType) {
        VariableLHS[] variableLHSArray;
        Object object;
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        Expression[] expressionArray = new Expression[iASTInitializerClauseArray.length];
        int n = 0;
        while (n < iASTInitializerClauseArray.length) {
            object = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[n]);
            expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object);
            expressionArray[n] = ((ExpressionResult)object).getLrValue().getValue();
            ++n;
        }
        if (iCType.isVoidType()) {
            variableLHSArray = new VariableLHS[]{};
        } else {
            object = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.RETURNED);
            expressionResultBuilder.addAuxVarWithDeclaration((AuxVarInfo)object);
            variableLHSArray = new VariableLHS[]{((AuxVarInfo)object).getLhs()};
        }
        expressionResultBuilder.addStatement((Statement)StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])variableLHSArray, (String)string, (Expression[])expressionArray));
        return expressionResultBuilder.build();
    }

    private Result handleVerifierAssume(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        Object object;
        this.mHelper.checkArguments(iLocation, 1, string, iASTFunctionCallExpression.getArguments());
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ArrayList<ExpressionResult> arrayList2 = new ArrayList<ExpressionResult>();
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        int n = iASTInitializerClauseArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iASTInitializerClauseArray[n2];
            ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, (IASTInitializerClause)object);
            if (expressionResult.getLrValue().getValue() == null) {
                String string2 = "Incorrect or invalid in-parameter! " + iLocation.toString();
                throw new IncorrectSyntaxException(iLocation, string2);
            }
            expressionResult = this.mExprResultTransformer.rexIntToBool(expressionResult, iLocation);
            arrayList.add(expressionResult.getLrValue().getValue());
            arrayList2.add(expressionResult);
            ++n2;
        }
        object = new ExpressionResultBuilder().addAllExceptLrValue(arrayList2);
        for (Expression expression : arrayList) {
            ((ExpressionResultBuilder)object).addStatement((Statement)new AssumeStatement(iLocation, expression));
        }
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, ((ExpressionResultBuilder)object).getDeclarations(), ((ExpressionResultBuilder)object).getAuxVars()));
        return ((ExpressionResultBuilder)object).build();
    }

    private static Result handleLtlStep(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation) {
        NamedAttribute namedAttribute = new NamedAttribute(iLocation, "ltl_step", new Expression[0]);
        AssumeStatement assumeStatement = new AssumeStatement(iLocation, new NamedAttribute[]{namedAttribute}, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)true));
        return new ExpressionResult(Collections.singletonList(assumeStatement), null);
    }
}

