/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EllipseVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.subLayout.GraphCollapser;
import edu.uci.ics.jung.visualization.util.PredicatedParallelEdgeIndexFunction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;

public class VertexCollapseDemo
extends JApplet {
    String instructions = "<html>Use the mouse to select multiple vertices<p>either by dragging a region, or by shift-clicking<p>on multiple vertices.<p>After you select vertices, use the Collapse button<p>to combine them into a single vertex.<p>Select a 'collapsed' vertex and use the Expand button<p>to restore the collapsed vertices.<p>The Restore button will restore the original graph.<p>If you select 2 (and only 2) vertices, then press<p>the Compress Edges button, parallel edges between<p>those two vertices will no longer be expanded.<p>If you select 2 (and only 2) vertices, then press<p>the Expand Edges button, parallel edges between<p>those two vertices will be expanded.<p>You can drag the vertices with the mouse.<p>Use the 'Picking'/'Transforming' combo-box to switch<p>between picking and transforming mode.</html>";
    Graph graph = TestGraphs.getOneComponentGraph();
    VisualizationViewer vv;
    Layout layout;
    GraphCollapser collapser = new GraphCollapser(this.graph);

    public VertexCollapseDemo() {
        this.layout = new FRLayout(this.graph);
        Dimension preferredSize = new Dimension(400, 400);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.layout, preferredSize);
        this.vv = new VisualizationViewer(visualizationModel, preferredSize);
        this.vv.getRenderContext().setVertexShapeTransformer(new ClusterVertexShapeFunction());
        PredicatedParallelEdgeIndexFunction eif = PredicatedParallelEdgeIndexFunction.getInstance();
        final HashSet exclusions = new HashSet();
        eif.setPredicate(new Predicate(){

            public boolean evaluate(Object e) {
                return exclusions.contains(e);
            }
        });
        this.vv.getRenderContext().setParallelEdgeIndexFunction(eif);
        this.vv.setBackground(Color.white);
        this.vv.setVertexToolTipTransformer(new ToStringLabeller(){

            public String transform(Object v) {
                if (v instanceof Graph) {
                    return ((Graph)v).getVertices().toString();
                }
                return super.transform(v);
            }
        });
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add(gzsp);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(VertexCollapseDemo.this.vv, 1.1f, VertexCollapseDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(VertexCollapseDemo.this.vv, 0.9090909f, VertexCollapseDemo.this.vv.getCenter());
            }
        });
        JButton collapse = new JButton("Collapse");
        collapse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashSet picked = new HashSet(VertexCollapseDemo.this.vv.getPickedVertexState().getPicked());
                if (picked.size() > 1) {
                    Graph inGraph = VertexCollapseDemo.this.layout.getGraph();
                    Graph clusterGraph = VertexCollapseDemo.this.collapser.getClusterGraph(inGraph, picked);
                    Graph g = VertexCollapseDemo.this.collapser.collapse(VertexCollapseDemo.this.layout.getGraph(), clusterGraph);
                    double sumx = 0.0;
                    double sumy = 0.0;
                    for (Object v : picked) {
                        Point2D p = (Point2D)VertexCollapseDemo.this.layout.transform(v);
                        sumx += p.getX();
                        sumy += p.getY();
                    }
                    Point2D.Double cp = new Point2D.Double(sumx / (double)picked.size(), sumy / (double)picked.size());
                    VertexCollapseDemo.this.vv.getRenderContext().getParallelEdgeIndexFunction().reset();
                    VertexCollapseDemo.this.layout.setGraph(g);
                    VertexCollapseDemo.this.layout.setLocation(clusterGraph, cp);
                    VertexCollapseDemo.this.vv.getPickedVertexState().clear();
                    VertexCollapseDemo.this.vv.repaint();
                }
            }
        });
        JButton compressEdges = new JButton("Compress Edges");
        compressEdges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Set picked = VertexCollapseDemo.this.vv.getPickedVertexState().getPicked();
                if (picked.size() == 2) {
                    Pair pair = new Pair(picked);
                    Graph graph = VertexCollapseDemo.this.layout.getGraph();
                    HashSet edges = new HashSet(graph.getIncidentEdges(pair.getFirst()));
                    edges.retainAll(graph.getIncidentEdges(pair.getSecond()));
                    exclusions.addAll(edges);
                    VertexCollapseDemo.this.vv.repaint();
                }
            }
        });
        JButton expandEdges = new JButton("Expand Edges");
        expandEdges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Set picked = VertexCollapseDemo.this.vv.getPickedVertexState().getPicked();
                if (picked.size() == 2) {
                    Pair pair = new Pair(picked);
                    Graph graph = VertexCollapseDemo.this.layout.getGraph();
                    HashSet edges = new HashSet(graph.getIncidentEdges(pair.getFirst()));
                    edges.retainAll(graph.getIncidentEdges(pair.getSecond()));
                    exclusions.removeAll(edges);
                    VertexCollapseDemo.this.vv.repaint();
                }
            }
        });
        JButton expand = new JButton("Expand");
        expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashSet picked = new HashSet(VertexCollapseDemo.this.vv.getPickedVertexState().getPicked());
                for (Object v : picked) {
                    if (v instanceof Graph) {
                        Graph g = VertexCollapseDemo.this.collapser.expand(VertexCollapseDemo.this.layout.getGraph(), (Graph)v);
                        VertexCollapseDemo.this.vv.getRenderContext().getParallelEdgeIndexFunction().reset();
                        VertexCollapseDemo.this.layout.setGraph(g);
                    }
                    VertexCollapseDemo.this.vv.getPickedVertexState().clear();
                    VertexCollapseDemo.this.vv.repaint();
                }
            }
        });
        JButton reset = new JButton("Reset");
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VertexCollapseDemo.this.layout.setGraph(VertexCollapseDemo.this.graph);
                exclusions.clear();
                VertexCollapseDemo.this.vv.repaint();
            }
        });
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog((JComponent)e.getSource(), VertexCollapseDemo.this.instructions, "Help", -1);
            }
        });
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        controls.add(zoomControls);
        JPanel collapseControls = new JPanel(new GridLayout(3, 1));
        collapseControls.setBorder(BorderFactory.createTitledBorder("Picked"));
        collapseControls.add(collapse);
        collapseControls.add(expand);
        collapseControls.add(compressEdges);
        collapseControls.add(expandEdges);
        collapseControls.add(reset);
        controls.add(collapseControls);
        controls.add(modeBox);
        controls.add(help);
        content.add((Component)controls, "South");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new VertexCollapseDemo());
        f.pack();
        f.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClusterVertexSizeFunction<V>
    implements Transformer<V, Integer> {
        int size;

        public ClusterVertexSizeFunction(Integer size) {
            this.size = size;
        }

        @Override
        public Integer transform(V v) {
            if (v instanceof Graph) {
                return 30;
            }
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClusterVertexShapeFunction<V>
    extends EllipseVertexShapeTransformer<V> {
        ClusterVertexShapeFunction() {
            this.setSizeTransformer(new ClusterVertexSizeFunction(20));
        }

        @Override
        public Shape transform(V v) {
            if (v instanceof Graph) {
                int size = ((Graph)v).getVertexCount();
                if (size < 8) {
                    int sides = Math.max(size, 3);
                    return this.factory.getRegularPolygon(v, sides);
                }
                return this.factory.getRegularStar(v, size);
            }
            return super.transform((Object)v);
        }
    }
}

