/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.modsetannotator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.Activator;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.modsetannotator.ModSetAnalyzer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModSetWriter
implements IUnmanagedObserver {
    private boolean mPerformedChanges = false;
    private final ILogger mLogger;
    private Map<String, Set<String>> mModifies;
    private final ModSetAnalyzer mAnalyzer;

    public ModSetWriter(ModSetAnalyzer modSetAnalyzer, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mAnalyzer = modSetAnalyzer;
    }

    public void init(ModelType modelType, int n, int n2) throws Throwable {
        this.mModifies = this.mAnalyzer.getModifiedGlobals();
    }

    public void finish() throws Throwable {
    }

    public boolean performedChanges() {
        return this.mPerformedChanges;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (iElement instanceof Unit) {
            Unit unit = (Unit)iElement;
            Declaration[] declarationArray = unit.getDeclarations();
            int n = 0;
            while (n < declarationArray.length) {
                Procedure procedure;
                Procedure procedure2;
                Declaration declaration = declarationArray[n];
                if (declaration instanceof Procedure && (procedure2 = this.processProcedure(procedure = (Procedure)declaration)) != procedure) {
                    declarationArray[n] = procedure2;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    protected Procedure processProcedure(Procedure procedure) {
        Set<String> set = this.mModifies.get(procedure.getIdentifier());
        if (set != null && procedure.getSpecification() != null) {
            int n = -1;
            VariableLHS[] variableLHSArray = null;
            Specification[] specificationArray = procedure.getSpecification();
            int n2 = 0;
            while (n2 < specificationArray.length) {
                if (specificationArray[n2] instanceof ModifiesSpecification) {
                    variableLHSArray = ((ModifiesSpecification)specificationArray[n2]).getIdentifiers();
                    n = n2;
                    break;
                }
                ++n2;
            }
            HashSet<VariableLHS> hashSet = new HashSet<VariableLHS>();
            if (variableLHSArray != null) {
                VariableLHS[] variableLHSArray2 = variableLHSArray;
                int n3 = variableLHSArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    VariableLHS object2 = variableLHSArray2[n4];
                    hashSet.add(object2);
                    set.remove(object2.getIdentifier());
                    ++n4;
                }
            }
            if (!set.isEmpty()) {
                this.mPerformedChanges = true;
                for (String string : set) {
                    VariableLHS variableLHS = new VariableLHS(null, string);
                    hashSet.add(variableLHS);
                }
                ModifiesSpecification modifiesSpecification = new ModifiesSpecification(procedure.getLocation(), false, hashSet.toArray(new VariableLHS[hashSet.size()]));
                if (n != -1) {
                    specificationArray[n] = modifiesSpecification;
                } else {
                    Specification[] specificationArray2 = Arrays.copyOf(specificationArray, specificationArray.length + 1);
                    specificationArray2[specificationArray.length] = modifiesSpecification;
                    Procedure procedure2 = new Procedure(procedure.getLocation(), procedure.getAttributes(), procedure.getIdentifier(), procedure.getTypeParams(), procedure.getInParams(), procedure.getOutParams(), specificationArray2, procedure.getBody());
                    return procedure2;
                }
            }
        }
        return procedure;
    }
}

