/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.LAInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;

public class CCInterpolator {
    Interpolator mInterpolator;
    Interpolator.LitInfo mDiseqOccurrences;
    HashMap<SymmetricPair<Term>, Interpolator.LitInfo> mEqualityOccurrences;
    Theory mTheory;
    int mNumInterpolants;
    Collection<Term>[] mInterpolants;
    Term[] mPath;
    BitSet mAllInA;
    int mMaxColor;
    PathEnd mHead;
    PathEnd mTail;

    public CCInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        this.mNumInterpolants = interpolator.mNumInterpolants;
        this.mTheory = interpolator.mTheory;
    }

    private int getParent(int n) {
        int n2 = n + 1;
        while (this.mInterpolator.mStartOfSubtrees[n2] > n) {
            ++n2;
        }
        return n2;
    }

    private int getChild(int n, Interpolator.Occurrence occurrence) {
        int n2 = n - 1;
        while (n2 >= this.mInterpolator.mStartOfSubtrees[n]) {
            if (occurrence.isALocal(n2)) {
                return n2;
            }
            n2 = this.mInterpolator.mStartOfSubtrees[n2] - 1;
        }
        return -1;
    }

    private Term[] interpolateCongruence(ApplicationTerm applicationTerm, ApplicationTerm applicationTerm2) {
        Term[] termArray = new Term[this.mNumInterpolants];
        Term[] termArray2 = applicationTerm.getParameters();
        Term[] termArray3 = applicationTerm2.getParameters();
        Interpolator.LitInfo[] litInfoArray = new Interpolator.LitInfo[termArray2.length];
        assert (applicationTerm.getFunction() == applicationTerm2.getFunction() && termArray2.length == termArray3.length);
        int n = 0;
        while (n < termArray2.length) {
            litInfoArray[n] = termArray2[n] == termArray3[n] ? null : this.mEqualityOccurrences.get(new SymmetricPair<Term>(termArray2[n], termArray3[n]));
            ++n;
        }
        n = 0;
        while (n < this.mNumInterpolants) {
            if (this.mDiseqOccurrences.isBorShared(n)) {
                var8_8 = new ArrayDeque(termArray2.length);
                var9_9 = 0;
                while (var9_9 < termArray2.length) {
                    if (litInfoArray[var9_9] != null && litInfoArray[var9_9].isALocal(n)) {
                        ((ArrayDeque)var8_8).add(this.mTheory.term("=", new Term[]{termArray2[var9_9], termArray3[var9_9]}));
                    } else if (litInfoArray[var9_9] != null && litInfoArray[var9_9].isMixed(n)) {
                        var10_10 = litInfoArray[var9_9].getMixedVar();
                        var11_12 = litInfoArray[var9_9].getLhsOccur().isALocal(n) ? termArray2[var9_9] : termArray3[var9_9];
                        ((ArrayDeque)var8_8).add(this.mTheory.term("=", new Term[]{var10_10, var11_12}));
                    }
                    ++var9_9;
                }
                termArray[n] = this.mTheory.and(((ArrayDeque)var8_8).toArray(new Term[((ArrayDeque)var8_8).size()]));
            } else if (this.mDiseqOccurrences.isALocal(n)) {
                var8_8 = new ArrayDeque(termArray2.length);
                var9_9 = 0;
                while (var9_9 < termArray2.length) {
                    if (litInfoArray[var9_9] != null && litInfoArray[var9_9].isBLocal(n)) {
                        ((ArrayDeque)var8_8).add(this.mTheory.not(this.mTheory.term("=", new Term[]{termArray2[var9_9], termArray3[var9_9]})));
                    } else if (litInfoArray[var9_9] != null && litInfoArray[var9_9].isMixed(n)) {
                        var10_10 = litInfoArray[var9_9].getMixedVar();
                        var11_12 = litInfoArray[var9_9].getLhsOccur().isBLocal(n) ? termArray2[var9_9] : termArray3[var9_9];
                        ((ArrayDeque)var8_8).add(this.mTheory.not(this.mTheory.term("=", new Term[]{var10_10, var11_12})));
                    }
                    ++var9_9;
                }
                termArray[n] = this.mTheory.or(((ArrayDeque)var8_8).toArray(new Term[((ArrayDeque)var8_8).size()]));
            } else {
                var8_8 = new Term[termArray2.length];
                var9_9 = this.mInterpolator.getOccurrence((Term)applicationTerm).isALocal(n) ? 1 : 0;
                int n2 = 0;
                while (n2 < termArray2.length) {
                    if (litInfoArray[n2] == null) {
                        var8_8[n2] = termArray2[n2];
                    } else if (litInfoArray[n2].isMixed(n)) {
                        var8_8[n2] = litInfoArray[n2].getMixedVar();
                    } else if (litInfoArray[n2].isAorShared(n)) {
                        Object object = var8_8[n2] = var9_9 != 0 ? termArray3[n2] : termArray2[n2];
                        assert (this.mInterpolator.getOccurrence((Term)var8_8[n2]).isAB(n));
                    } else {
                        Object object = var8_8[n2] = var9_9 != 0 ? termArray2[n2] : termArray3[n2];
                        assert (this.mInterpolator.getOccurrence((Term)var8_8[n2]).isAB(n));
                    }
                    ++n2;
                }
                var10_10 = this.mTheory.term(applicationTerm.getFunction(), (Term[])var8_8);
                termArray[n] = this.mTheory.term("@EQ", new Term[]{this.mDiseqOccurrences.getMixedVar(), var10_10});
            }
            ++n;
        }
        return termArray;
    }

    /*
     * Unable to fully structure code
     */
    public Term[] interpolateTransitivity() {
        this.mInterpolants = new Collection[this.mNumInterpolants];
        var1_1 = 0;
        while (var1_1 < this.mNumInterpolants) {
            this.mInterpolants[var1_1] = new ArrayList<Term>();
            ++var1_1;
        }
        var1_2 = this.mPath[0];
        var2_3 = this.mPath[this.mPath.length - 1];
        var3_4 = this.mInterpolator.getOccurrence(var1_2);
        var4_5 = this.mInterpolator.getOccurrence(var2_3);
        this.mHead = new PathEnd();
        this.mTail = new PathEnd();
        this.mMaxColor = this.mNumInterpolants;
        this.mAllInA = new BitSet(this.mNumInterpolants);
        this.mAllInA.set(0, this.mNumInterpolants);
        this.mTail.closeAPath(this.mHead, null, var3_4);
        this.mTail.openAPath(this.mHead, null, var3_4);
        var5_6 = 0;
        while (var5_6 < this.mPath.length - 1) {
            var6_7 = this.mPath[var5_6];
            var7_10 = this.mPath[var5_6 + 1];
            var8_12 = this.mEqualityOccurrences.get(new SymmetricPair<Term>((Term)var6_7, var7_10));
            this.mTail.closeAPath(this.mHead, (Term)var6_7, var8_12);
            this.mTail.openAPath(this.mHead, (Term)var6_7, var8_12);
            if (var8_12.getMixedVar() != null) {
                var9_13 = this.mInterpolator.getOccurrence(var7_10);
                this.mTail.closeAPath(this.mHead, (Term)var8_12.getMixedVar(), var9_13);
                this.mTail.openAPath(this.mHead, (Term)var8_12.getMixedVar(), var9_13);
            }
            ++var5_6;
        }
        if (this.mDiseqOccurrences == null) ** GOTO lbl50
        this.mTail.closeAPath(this.mHead, var2_3, this.mDiseqOccurrences);
        this.mTail.openAPath(this.mHead, var2_3, this.mDiseqOccurrences);
        this.mHead.closeAPath(this.mTail, var1_2, this.mDiseqOccurrences);
        this.mHead.openAPath(this.mTail, var1_2, this.mDiseqOccurrences);
        if (this.mDiseqOccurrences.getMixedVar() == null) ** GOTO lbl50
        this.mTail.closeAPathMixed(this.mDiseqOccurrences.getMixedVar(), var3_4);
        this.mHead.closeAPathMixed(this.mDiseqOccurrences.getMixedVar(), var4_5);
        ** GOTO lbl50
        {
            this.mInterpolants[this.mHead.mColor].add(this.mTheory.term("=", new Term[]{var1_2, this.mHead.mTerm[this.mHead.mColor]}));
            this.mHead.mColor = this.getParent(this.mHead.mColor);
            do {
                if (this.mHead.mColor < this.mTail.mColor) continue block2;
                while (this.mTail.mColor < this.mHead.mColor) {
                    this.mInterpolants[this.mTail.mColor].add(this.mTheory.term("=", new Term[]{this.mTail.mTerm[this.mTail.mColor], var2_3}));
                    this.mTail.mColor = this.getParent(this.mTail.mColor);
                }
lbl50:
                // 4 sources

            } while (this.mHead.mColor != this.mTail.mColor);
        }
        if (!CCInterpolator.$assertionsDisabled && this.mHead.mColor != this.mTail.mColor) {
            throw new AssertionError();
        }
        var5_6 = this.mHead.mColor;
        while (var5_6 < this.mMaxColor) {
            var6_8 = var5_6;
            this.mInterpolants[var6_8].add(this.mTheory.not(this.mTheory.term("=", new Term[]{this.mHead.mTerm[var5_6], this.mTail.mTerm[var5_6]})));
            var5_6 = this.getParent(var5_6);
        }
        while (var5_6 < this.mNumInterpolants) {
            var6_9 = var5_6;
            this.mInterpolants[var6_9].add((Term)this.mTheory.mFalse);
            var5_6 = this.getParent(var5_6);
        }
        var6_7 = new Term[this.mNumInterpolants];
        var7_11 = 0;
        while (var7_11 < this.mNumInterpolants) {
            var6_7[var7_11] = this.mTheory.and(this.mInterpolants[var7_11].toArray(new Term[this.mInterpolants[var7_11].size()]));
            ++var7_11;
        }
        return var6_7;
    }

    public Term[] interpolateInstantiation(InterpolatorClauseInfo interpolatorClauseInfo) {
        assert (interpolatorClauseInfo.getLemmaType().equals(":inst"));
        Term[] termArray = new Term[this.mNumInterpolants];
        Term[] termArray2 = interpolatorClauseInfo.getLiterals();
        Term term = this.mInterpolator.getAtom(termArray2[0]);
        Interpolator.LitInfo litInfo = this.mInterpolator.getAtomOccurenceInfo(term);
        int n = 0;
        while (n < this.mNumInterpolants) {
            ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>(termArray2.length);
            if (litInfo.isALocal(n)) {
                var8_8 = 0;
                while (var8_8 < termArray2.length) {
                    var9_9 = this.mInterpolator.getAtom(termArray2[var8_8]);
                    var10_10 = this.mInterpolator.getAtomOccurenceInfo(var9_9);
                    if (var10_10.isBLocal(n)) {
                        arrayDeque.add(termArray2[var8_8]);
                    } else if (var10_10.isMixed(n)) {
                        var11_11 = var10_10.getMixedVar();
                        var12_12 = this.mInterpolator.getAtomTermInfo(var9_9);
                        if (var12_12.isCCEquality()) {
                            Object object = var13_13 = var10_10.getLhsOccur().isBLocal(n) ? ((ApplicationTerm)var9_9).getParameters()[0] : ((ApplicationTerm)var9_9).getParameters()[1];
                            if (this.mInterpolator.isNegatedTerm(termArray2[var8_8])) {
                                arrayDeque.add(this.mTheory.not(this.mTheory.term("=", new Term[]{var11_11, var13_13})));
                            } else {
                                arrayDeque.add(this.mTheory.term("@EQ", new Term[]{var11_11, var13_13}));
                            }
                        } else if (var12_12.isLAEquality() || var12_12.isBoundConstraint()) {
                            var13_13 = var10_10.getAPart(n);
                            var14_14 = new InterpolatorAffineTerm();
                            ((InterpolatorAffineTerm)var14_14).add(Rational.ONE, var12_12.getAffineTerm());
                            ((InterpolatorAffineTerm)var14_14).add(Rational.MONE, var13_13);
                            if (var12_12.isLAEquality()) {
                                var15_15 = ((InterpolatorAffineTerm)var14_14).toSMTLib(this.mTheory, var12_12.isInt());
                                if (this.mInterpolator.isNegatedTerm(termArray2[var8_8])) {
                                    arrayDeque.add(this.mTheory.not(this.mTheory.term("=", new Term[]{var11_11, var15_15})));
                                } else {
                                    arrayDeque.add(this.mTheory.term("@EQ", new Term[]{var11_11, var15_15}));
                                }
                            } else {
                                ((InterpolatorAffineTerm)var14_14).add(Rational.ONE, (Term)var11_11);
                                InfinitesimalNumber infinitesimalNumber = var15_15 = var12_12.isInt() ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
                                if (this.mInterpolator.isNegatedTerm(termArray2[var8_8])) {
                                    ((InterpolatorAffineTerm)var14_14).mul(Rational.MONE);
                                    ((InterpolatorAffineTerm)var14_14).add((InfinitesimalNumber)var15_15);
                                }
                                arrayDeque.add(LAInterpolator.createLATerm((InterpolatorAffineTerm)var14_14, ((InfinitesimalNumber)var15_15).negate(), ((InterpolatorAffineTerm)var14_14).toLeq0(this.mInterpolator.mTheory)));
                            }
                        } else {
                            throw new AssertionError();
                        }
                    }
                    ++var8_8;
                }
                termArray[n] = arrayDeque.isEmpty() ? this.mTheory.mFalse : this.mTheory.or(arrayDeque.toArray(new Term[arrayDeque.size()]));
            } else {
                var8_8 = 0;
                while (var8_8 < termArray2.length) {
                    var9_9 = this.mInterpolator.getAtom(termArray2[var8_8]);
                    var10_10 = this.mInterpolator.getAtomOccurenceInfo(var9_9);
                    if (var10_10.isALocal(n)) {
                        arrayDeque.add(this.mTheory.not(termArray2[var8_8]));
                    } else if (var10_10.isMixed(n)) {
                        var11_11 = var10_10.getMixedVar();
                        var12_12 = this.mInterpolator.getAtomTermInfo(var9_9);
                        if (var12_12.isCCEquality()) {
                            Object object = var13_13 = var10_10.getLhsOccur().isALocal(n) ? ((ApplicationTerm)var9_9).getParameters()[0] : ((ApplicationTerm)var9_9).getParameters()[1];
                            if (this.mInterpolator.isNegatedTerm(termArray2[var8_8])) {
                                arrayDeque.add(this.mTheory.term("=", new Term[]{var11_11, var13_13}));
                            } else {
                                arrayDeque.add(this.mTheory.term("@EQ", new Term[]{var11_11, var13_13}));
                            }
                        } else if (var12_12.isLAEquality() || var12_12.isBoundConstraint()) {
                            var13_13 = new InterpolatorAffineTerm(var10_10.getAPart(n));
                            if (var12_12.isLAEquality()) {
                                var14_14 = var13_13.toSMTLib(this.mTheory, var12_12.isInt());
                                if (this.mInterpolator.isNegatedTerm(termArray2[var8_8])) {
                                    arrayDeque.add(this.mTheory.term("=", new Term[]{var11_11, var14_14}));
                                } else {
                                    arrayDeque.add(this.mTheory.term("@EQ", new Term[]{var11_11, var14_14}));
                                }
                            } else {
                                var13_13.add(Rational.MONE, (Term)var11_11);
                                Object object = var14_14 = var12_12.isInt() ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
                                if (!this.mInterpolator.isNegatedTerm(termArray2[var8_8])) {
                                    var13_13.mul(Rational.MONE);
                                }
                                arrayDeque.add(LAInterpolator.createLATerm(var13_13, ((InfinitesimalNumber)var14_14).negate(), var13_13.toLeq0(this.mInterpolator.mTheory)));
                            }
                        } else {
                            throw new AssertionError();
                        }
                    }
                    ++var8_8;
                }
                termArray[n] = arrayDeque.isEmpty() ? this.mTheory.mTrue : this.mTheory.and(arrayDeque.toArray(new Term[arrayDeque.size()]));
            }
            ++n;
        }
        return termArray;
    }

    public Term[] computeInterpolants(InterpolatorClauseInfo interpolatorClauseInfo) {
        this.mEqualityOccurrences = new HashMap();
        Term[] termArray = interpolatorClauseInfo.getLiterals();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            Term term2 = this.mInterpolator.getAtom(term);
            if (term2 != term) {
                InterpolatorAtomInfo interpolatorAtomInfo = this.mInterpolator.getAtomTermInfo(term2);
                Interpolator.LitInfo litInfo = this.mInterpolator.getAtomOccurenceInfo(term2);
                assert (interpolatorAtomInfo.isCCEquality());
                ApplicationTerm applicationTerm = interpolatorAtomInfo.getEquality();
                this.mEqualityOccurrences.put(new SymmetricPair<Term>(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]), litInfo);
            } else {
                assert (this.mDiseqOccurrences == null);
                this.mDiseqOccurrences = this.mInterpolator.getAtomOccurenceInfo(term2);
            }
            ++n2;
        }
        this.mPath = (Term[])interpolatorClauseInfo.getLemmaAnnotation();
        if (interpolatorClauseInfo.getLemmaType() == ":cong") {
            return this.interpolateCongruence((ApplicationTerm)this.mPath[0], (ApplicationTerm)this.mPath[1]);
        }
        return this.interpolateTransitivity();
    }

    public String toString() {
        return "PathInfo[" + Arrays.toString(this.mPath) + "," + String.valueOf(this.mHead) + "," + String.valueOf(this.mTail) + "," + this.mMaxColor + "]";
    }

    class PathEnd {
        int mColor;
        Term[] mTerm;

        public PathEnd() {
            this.mColor = CCInterpolator.this.mNumInterpolants;
            this.mTerm = new Term[CCInterpolator.this.mNumInterpolants];
        }

        public void closeAPath(PathEnd pathEnd, Term term, Interpolator.Occurrence occurrence) {
            assert (pathEnd.mColor <= CCInterpolator.this.mMaxColor);
            CCInterpolator.this.mAllInA.and(occurrence.mInA);
            while (this.mColor < CCInterpolator.this.mNumInterpolants && occurrence.isBLocal(this.mColor)) {
                CCInterpolator.this.mAllInA.clear();
                int n = this.mColor;
                this.mColor = CCInterpolator.this.getParent(n);
                if (n < CCInterpolator.this.mMaxColor) {
                    CCInterpolator.this.mInterpolants[n].add(CCInterpolator.this.mTheory.term("=", new Term[]{this.mTerm[n], term}));
                    this.mTerm[n] = null;
                    continue;
                }
                assert (CCInterpolator.this.mMaxColor == n);
                pathEnd.mTerm[n] = term;
                CCInterpolator.this.mMaxColor = this.mColor;
            }
        }

        public void openAPath(PathEnd pathEnd, Term term, Interpolator.Occurrence occurrence) {
            int n;
            while ((n = CCInterpolator.this.getChild(this.mColor, occurrence)) >= 0) {
                assert (occurrence.isALocal(n));
                if (CCInterpolator.this.mAllInA.get(n)) {
                    assert (CCInterpolator.this.mMaxColor == this.mColor && CCInterpolator.this.mMaxColor == pathEnd.mColor);
                    CCInterpolator.this.mMaxColor = pathEnd.mColor = n;
                } else {
                    this.mTerm[n] = term;
                }
                this.mColor = n;
            }
        }

        public void closeAPathMixed(TermVariable termVariable, Interpolator.Occurrence occurrence) {
            while (occurrence.isBLocal(this.mColor)) {
                int n = this.mColor;
                this.mColor = CCInterpolator.this.getParent(n);
                assert (n < CCInterpolator.this.mMaxColor);
                CCInterpolator.this.mInterpolants[n].add(CCInterpolator.this.mTheory.term("@EQ", new Term[]{termVariable, this.mTerm[n]}));
                this.mTerm[n] = null;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            stringBuilder.append(this.mColor).append(":[");
            int n = this.mColor;
            while (n < CCInterpolator.this.mMaxColor) {
                stringBuilder.append(string);
                stringBuilder.append(this.mTerm[n]);
                string = ",";
                ++n;
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

