/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.ConstraintAdministrationSolver;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusContainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusUtils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Shrinking;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.UnexploredMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SExpression;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.TimeoutHandler;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class ReMus
implements Iterator<MusContainer> {
    ConstraintAdministrationSolver mSolver;
    UnexploredMap mMap;
    TimeoutHandler mTimeoutHandler;
    long mTimeout;
    Random mRnd;
    boolean mUnknownAllowed;
    LogProxy mLogger;
    ArrayList<MusContainer> mMuses;
    MusContainer mNextMus;
    boolean mProvisionalSat;
    BitSet mMaxUnexplored;
    ArrayList<Integer> mMcs;
    BitSet mKnownCrits;
    BitSet mWorkingSet;
    ReMus mSubordinateRemus;
    boolean mMembersUpToDate;
    boolean mSatisfiableCaseLoopIsRunning;
    BitSet mSatisfiableCaseLoopNextWorkingSet;
    boolean mTimeoutOrTerminationRequestOccurred;

    public ReMus(ConstraintAdministrationSolver constraintAdministrationSolver, UnexploredMap unexploredMap, BitSet bitSet, TimeoutHandler timeoutHandler, long l, Random random, boolean bl, LogProxy logProxy) {
        this.mSolver = constraintAdministrationSolver;
        this.mMap = unexploredMap;
        this.mTimeoutHandler = timeoutHandler;
        this.mTimeout = l;
        this.mTimeoutOrTerminationRequestOccurred = false;
        this.mRnd = random;
        this.mUnknownAllowed = bl;
        this.mLogger = logProxy;
        if (bitSet.length() > this.mSolver.getNumberOfConstraints()) {
            throw new SMTLIBException("There are constraints set in the workingSet that are not registered in the translator of the solver and the map");
        }
        this.mWorkingSet = bitSet;
        this.initializeMembersAndAssertImpliedCrits();
    }

    private ReMus(ConstraintAdministrationSolver constraintAdministrationSolver, UnexploredMap unexploredMap, BitSet bitSet, TimeoutHandler timeoutHandler, Random random, boolean bl, LogProxy logProxy) {
        this(constraintAdministrationSolver, unexploredMap, bitSet, timeoutHandler, 0L, random, bl, logProxy);
    }

    private void initializeMembersAndAssertImpliedCrits() {
        this.mMuses = new ArrayList();
        this.mSolver.clearUnknownConstraints();
        this.mKnownCrits = this.mSolver.getCrits();
        this.mMap.messWithActivityOfAtoms(this.mRnd);
        this.mMaxUnexplored = this.mMap.findMaximalUnexploredSubsetOf(this.mWorkingSet);
        BitSet bitSet = this.mMap.findImpliedCritsOf(this.mWorkingSet);
        this.mSolver.assertCriticalConstraints(bitSet);
        this.mProvisionalSat = !MusUtils.contains(this.mMaxUnexplored, this.mKnownCrits);
        this.mKnownCrits.or(bitSet);
        this.mMembersUpToDate = true;
    }

    @Override
    public boolean hasNext() throws SMTLIBException {
        if (this.mNextMus != null) {
            return true;
        }
        if (this.mTimeoutOrTerminationRequestOccurred) {
            return false;
        }
        boolean bl = false;
        if (this.mTimeout > 0L && !this.mTimeoutHandler.timeoutIsSet()) {
            this.mTimeoutHandler.setTimeout(this.mTimeout);
            bl = true;
        }
        if (this.mSubordinateRemus != null && this.mSubordinateRemus.hasNext()) {
            this.mNextMus = this.mSubordinateRemus.next();
            return true;
        }
        this.removeSubordinateRemus();
        if (this.mSatisfiableCaseLoopIsRunning) {
            this.resumeSatisfiableCaseLoopUntilNextMus();
        }
        if (this.mNextMus != null) {
            return true;
        }
        this.searchForNextMusBeginningInThisRecursionLevel();
        if (this.mNextMus != null) {
            return true;
        }
        if (this.mTimeoutHandler.isTerminationRequested()) {
            this.mTimeoutOrTerminationRequestOccurred = true;
        }
        if (bl) {
            this.mTimeoutHandler.clearTimeout();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void resumeSatisfiableCaseLoopUntilNextMus() {
        if (this.mSubordinateRemus == null) ** GOTO lbl11
        throw new SMTLIBException("Let the subordinate find it's muses first.");
lbl-1000:
        // 1 sources

        {
            var1_1 = MusUtils.pop(this.mMcs);
            this.mSatisfiableCaseLoopNextWorkingSet.set(var1_1);
            this.createNewSubordinateRemusWithExtraCrit(this.mSatisfiableCaseLoopNextWorkingSet, var1_1);
            if (this.mSubordinateRemus.hasNext()) {
                this.mNextMus = this.mSubordinateRemus.next();
            } else {
                this.removeSubordinateRemus();
            }
            this.mSatisfiableCaseLoopNextWorkingSet.clear(var1_1);
lbl11:
            // 2 sources

            ** while (!this.mMcs.isEmpty() && this.mNextMus == null && !this.mTimeoutHandler.isTerminationRequested())
        }
lbl12:
        // 1 sources

        this.mSatisfiableCaseLoopIsRunning = this.mMcs.isEmpty() == false && this.mTimeoutHandler.isTerminationRequested() == false;
    }

    private void searchForNextMusBeginningInThisRecursionLevel() {
        assert (this.mSubordinateRemus == null) : "Let the subordinate find its muses first.";
        assert (!this.mSatisfiableCaseLoopIsRunning) : "Finish the Satisfiable case loop first.";
        if (!this.mMembersUpToDate) {
            this.updateMembersAndAssertImpliedCrits();
        }
        while (!this.mMaxUnexplored.isEmpty() && this.mNextMus == null && !this.mTimeoutHandler.isTerminationRequested()) {
            assert (this.mMembersUpToDate && this.mSubordinateRemus == null) : "Variables of ReMus are corrupted.";
            if (this.mProvisionalSat) {
                this.handleUnexploredIsSat();
            } else {
                BitSet bitSet = (BitSet)this.mMaxUnexplored.clone();
                bitSet.andNot(this.mKnownCrits);
                this.mSolver.assertUnknownConstraints(bitSet);
                Script.LBool lBool = this.mSolver.checkSat();
                this.mSolver.clearUnknownConstraints();
                if (lBool == Script.LBool.SAT) {
                    this.handleUnexploredIsSat();
                } else if (lBool == Script.LBool.UNSAT) {
                    this.handleUnexploredIsUnsat();
                } else {
                    if (this.mTimeoutHandler.isTerminationRequested()) {
                        return;
                    }
                    if (!this.mUnknownAllowed) {
                        throw new SMTLIBException("LBool.UNKNOWN occured in enumeration process, despite of not being explicitly allowed. (To allow it, use allowCheckSatUnknown).");
                    }
                    this.mMap.BlockDown(this.mMaxUnexplored);
                }
            }
            if (this.mSubordinateRemus == null && !this.mTimeoutHandler.isTerminationRequested()) {
                this.updateMembersAndAssertImpliedCrits();
                continue;
            }
            this.mMembersUpToDate = false;
        }
    }

    private void updateMembersAndAssertImpliedCrits() {
        this.mMap.messWithActivityOfAtoms(this.mRnd);
        this.mMaxUnexplored = this.mMap.findMaximalUnexploredSubsetOf(this.mWorkingSet);
        BitSet bitSet = this.mMap.findImpliedCritsOf(this.mWorkingSet);
        bitSet.andNot(this.mKnownCrits);
        this.mSolver.assertCriticalConstraints(bitSet);
        this.mProvisionalSat = !MusUtils.contains(this.mMaxUnexplored, this.mKnownCrits);
        this.mKnownCrits.or(bitSet);
        this.mMembersUpToDate = true;
    }

    private void handleUnexploredIsSat() {
        this.mMap.BlockDown(this.mMaxUnexplored);
        BitSet bitSet = (BitSet)this.mWorkingSet.clone();
        bitSet.andNot(this.mMaxUnexplored);
        if (bitSet.cardinality() == 1) {
            this.mSolver.assertCriticalConstraint(bitSet.nextSetBit(0));
        } else {
            this.mMcs = MusUtils.randomPermutation(bitSet, this.mRnd);
            BitSet bitSet2 = (BitSet)this.mMaxUnexplored.clone();
            while (!this.mMcs.isEmpty() && this.mNextMus == null && !this.mTimeoutHandler.isTerminationRequested()) {
                int n = MusUtils.pop(this.mMcs);
                bitSet2.set(n);
                this.createNewSubordinateRemusWithExtraCrit(bitSet2, n);
                if (this.mSubordinateRemus.hasNext()) {
                    this.mNextMus = this.mSubordinateRemus.next();
                } else {
                    this.removeSubordinateRemus();
                }
                bitSet2.clear(n);
                this.mSatisfiableCaseLoopNextWorkingSet = bitSet2;
            }
            this.mSatisfiableCaseLoopIsRunning = !this.mMcs.isEmpty() && !this.mTimeoutHandler.isTerminationRequested();
        }
    }

    private void handleUnexploredIsUnsat() {
        this.mSolver.pushRecLevel();
        if (this.mLogger != null) {
            this.mLogger.fatal("Now shrinking...");
        }
        this.mNextMus = Shrinking.shrink(this.mSolver, this.mMaxUnexplored, this.mMap, this.mTimeoutHandler, this.mRnd, this.mUnknownAllowed);
        this.mSolver.popRecLevel();
        if (this.mNextMus == null) {
            return;
        }
        BitSet bitSet = (BitSet)this.mNextMus.getMus().clone();
        if ((double)bitSet.cardinality() < 0.9 * (double)this.mMaxUnexplored.cardinality()) {
            ArrayList<Integer> arrayList = MusUtils.randomPermutation(this.mMaxUnexplored, this.mRnd);
            while ((double)bitSet.cardinality() < 0.9 * (double)this.mMaxUnexplored.cardinality()) {
                int n = MusUtils.pop(arrayList);
                if (bitSet.get(n)) continue;
                bitSet.set(n);
            }
            this.createNewSubordinateRemus(bitSet);
        }
    }

    private void createNewSubordinateRemus(BitSet bitSet) {
        this.mSolver.pushRecLevel();
        this.mSubordinateRemus = new ReMus(this.mSolver, this.mMap, bitSet, this.mTimeoutHandler, this.mRnd, this.mUnknownAllowed, this.mLogger);
    }

    private void createNewSubordinateRemusWithExtraCrit(BitSet bitSet, int n) {
        this.mSolver.pushRecLevel();
        this.mSolver.assertCriticalConstraint(n);
        this.mSubordinateRemus = new ReMus(this.mSolver, this.mMap, bitSet, this.mTimeoutHandler, this.mRnd, this.mUnknownAllowed, this.mLogger);
    }

    private void removeSubordinateRemus() {
        if (this.mSubordinateRemus != null) {
            this.mSubordinateRemus = null;
            this.mSolver.popRecLevel();
        }
    }

    @Override
    public MusContainer next() throws SMTLIBException {
        if (this.hasNext()) {
            MusContainer musContainer = this.mNextMus;
            this.mNextMus = null;
            return musContainer;
        }
        throw new NoSuchElementException();
    }

    public ArrayList<MusContainer> enumerate() throws SMTLIBException {
        boolean bl = false;
        if (this.mTimeout > 0L) {
            this.mTimeoutHandler.setTimeout(this.mTimeout);
            bl = true;
        }
        ArrayList<MusContainer> arrayList = new ArrayList<MusContainer>();
        while (this.hasNext()) {
            arrayList.add(this.next());
        }
        if (bl) {
            this.mTimeoutHandler.clearTimeout();
        }
        if (this.mLogger != null && arrayList.size() == 0) {
            Object object = this.mSolver.getInfo(":all-statistics");
            SExpression sExpression = new SExpression(object);
            this.mLogger.fatal(sExpression.toString());
        }
        return arrayList;
    }

    public void resetSolver() {
        this.mTimeoutOrTerminationRequestOccurred = true;
        this.mSolver.reset();
    }
}

