/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.math.BigInteger;

public class VerbosityOption
extends Option {
    private int mDefaultLvl;
    private final LogProxy mLogger;

    public VerbosityOption(LogProxy logProxy) {
        super(true, "How much output to produce on the diagnostic output channel.  The bigger the number the more output will be produces.  0 turns off diagnostic output.");
        this.mLogger = logProxy;
        this.mDefaultLvl = this.mLogger.getLoglevel();
    }

    @Override
    public Option copy() {
        return this;
    }

    @Override
    public void set(Object object) {
        int n;
        if (object instanceof Number) {
            n = ((Number)object).intValue();
        } else if (object instanceof String) {
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SMTLIBException("Not a valid number: " + String.valueOf(object));
            }
        } else {
            throw new SMTLIBException("Not a valid number: " + String.valueOf(object));
        }
        if (n < 0) {
            n = 0;
        } else if (n > 6) {
            n = 6;
        }
        this.mLogger.setLoglevel(n);
    }

    @Override
    public Object get() {
        return BigInteger.valueOf(this.mLogger.getLoglevel());
    }

    @Override
    public void reset() {
        this.mLogger.setLoglevel(this.mDefaultLvl);
    }

    @Override
    public Object defaultValue() {
        return BigInteger.valueOf(this.mDefaultLvl);
    }

    @Override
    public void started() {
        this.mDefaultLvl = this.mLogger.getLoglevel();
    }
}

