/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker;

import com.github.jhoenicke.javacup.runtime.Scanner;
import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import com.github.jhoenicke.javacup.runtime.Symbol;
import com.github.jhoenicke.javacup.runtime.SymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.MinimalProofChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker.ProofLexer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.checker.ProofParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;

public class CheckingScript
extends NoopScript {
    private final String mProofFile;
    private final LogProxy mLogger;
    private final ScopedArrayList<Term> mAssertions = new ScopedArrayList();
    final SimpleSymbolFactory mSymfactory = new SimpleSymbolFactory();
    private Script.LBool mLastCheckSat;
    private SExprLexer mLexer;

    public CheckingScript(LogProxy logProxy, String string) {
        this.mLogger = logProxy;
        this.mProofFile = string;
        this.setProofReader(this.openProofReader(string));
    }

    public CheckingScript(LogProxy logProxy, String string, Reader reader) {
        this.mLogger = logProxy;
        this.mProofFile = string;
        this.setProofReader(reader);
    }

    public void setProofReader(Reader reader) {
        ProofLexer proofLexer = new ProofLexer(reader);
        proofLexer.setSymbolFactory(this.mSymfactory);
        this.mLexer = new SExprLexer(proofLexer);
    }

    public Script.LBool assertTerm(Term term) {
        this.mAssertions.add(term);
        return Script.LBool.UNKNOWN;
    }

    public Term[] getAssertions() {
        return this.mAssertions.toArray(new Term[this.mAssertions.size()]);
    }

    public void push(int n) throws SMTLIBException {
        super.push(n);
        while (n-- > 0) {
            this.mAssertions.beginScope();
        }
    }

    public void pop(int n) throws SMTLIBException {
        super.pop(n);
        int n2 = n;
        while (n2-- > 0) {
            this.mAssertions.endScope();
        }
    }

    private Reader openProofReader(String string) {
        if (string.equals("<stdin>")) {
            return new InputStreamReader(System.in);
        }
        File file = new File(string);
        try {
            if (string.endsWith(".gz")) {
                return new InputStreamReader(new GZIPInputStream(new FileInputStream(file)));
            }
            return new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SMTLIBException("File not found: " + string, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new SMTLIBException("Cannot read file: " + string, (Throwable)iOException);
        }
    }

    public void printError(String string) {
        this.mLogger.error(string);
    }

    public void printResult(Object object) {
        System.out.println(object.toString());
    }

    public Script.LBool checkSat() {
        Symbol symbol;
        Symbol symbol2;
        this.mLexer.clearEOF();
        try {
            symbol2 = this.mLexer.next_token();
            symbol = this.mLexer.next_token();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception", exception);
        }
        if (symbol2.sym != 82) {
            this.mLastCheckSat = Script.LBool.UNKNOWN;
        } else {
            assert (symbol2.sym == 82);
            assert (symbol.sym == 1);
            try {
                this.mLastCheckSat = Script.LBool.valueOf((String)((String)symbol2.value).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.mLastCheckSat = Script.LBool.UNKNOWN;
            }
        }
        return this.mLastCheckSat;
    }

    public Term getProof() {
        this.mLexer.clearEOF();
        if (this.mLastCheckSat == Script.LBool.UNSAT) {
            Term term;
            ProofParser proofParser = new ProofParser(this.mLexer, (SymbolFactory)this.mSymfactory);
            proofParser.setFileName(this.mProofFile);
            proofParser.setScript((Script)this);
            try {
                term = (Term)proofParser.parse().value;
            }
            catch (Exception exception) {
                throw new RuntimeException("Unexpected exception", exception);
            }
            MinimalProofChecker minimalProofChecker = new MinimalProofChecker((Script)this, this.mLogger);
            if (minimalProofChecker.check(term)) {
                int n = minimalProofChecker.getNumberOfHoles();
                this.printResult(n > 0 ? "holey" : "valid");
                this.printResult("holes=" + n);
                this.printResult("assertions=" + minimalProofChecker.getNumberOfAssertions());
                this.printResult("definefuns=" + minimalProofChecker.getNumberOfDefineFun());
                this.printResult("axioms=" + minimalProofChecker.getNumberOfAxioms());
                this.printResult("resolutions=" + minimalProofChecker.getNumberOfResolutions());
            } else {
                this.printResult("invalid");
            }
        } else {
            this.printResult(this.mLastCheckSat.toString());
            try {
                while (this.mLexer.next_token().sym != 1) {
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Unexpected exception", exception);
            }
        }
        return null;
    }

    public class SExprLexer
    implements Scanner {
        private final Scanner mLexer;
        private Symbol mEOFSymbol;
        private int mParenLevel;

        public SExprLexer(Scanner scanner) {
            this.mLexer = scanner;
            this.mEOFSymbol = null;
        }

        public Symbol next_token() throws Exception {
            if (this.mEOFSymbol != null) {
                return this.mEOFSymbol;
            }
            Symbol symbol = this.mLexer.next_token();
            if (symbol.sym == 89) {
                ++this.mParenLevel;
            }
            if (symbol.sym == 90) {
                --this.mParenLevel;
            }
            if (this.mParenLevel == 0) {
                this.mEOFSymbol = CheckingScript.this.mSymfactory.newSymbol("", 1, symbol, symbol);
            }
            return symbol;
        }

        public void clearEOF() {
            this.mEOFSymbol = null;
        }
    }
}

