/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class ProductDawgBuilder<LETTER, COLNAMES, V1, V2, V3> {
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final DawgFactory<LETTER, COLNAMES> mDawgFactory;
    private final BiFunction<V1, V2, V3> mOperation;
    private final Map<Pair<DawgState<LETTER, V1>, DawgState<LETTER, V2>>, DawgState<LETTER, V3>> mCache;

    public ProductDawgBuilder(DawgFactory<LETTER, COLNAMES> dawgFactory, BiFunction<V1, V2, V3> biFunction) {
        this.mDawgFactory = dawgFactory;
        this.mDawgStateFactory = this.mDawgFactory.getDawgStateFactory();
        this.mOperation = biFunction;
        this.mCache = new HashMap<Pair<DawgState<LETTER, V1>, DawgState<LETTER, V2>>, DawgState<LETTER, V3>>();
    }

    public DawgState<LETTER, V3> product(DawgState<LETTER, V1> dawgState, DawgState<LETTER, V2> dawgState2) {
        Pair<DawgState<LETTER, V1>, DawgState<LETTER, V2>> pair = new Pair<DawgState<LETTER, V1>, DawgState<LETTER, V2>>(dawgState, dawgState2);
        DawgState<LETTER, Object> dawgState3 = this.mCache.get(pair);
        if (dawgState3 != null) {
            return dawgState3;
        }
        if (dawgState.isFinal()) {
            assert (dawgState2.isFinal());
            dawgState3 = this.mDawgStateFactory.createFinalState(this.mOperation.apply(dawgState.getFinalValue(), dawgState2.getFinalValue()));
        } else {
            HashMap hashMap = new HashMap();
            for (Map.Entry<DawgState<LETTER, V1>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
                for (Map.Entry<DawgState<LETTER, V2>, DawgLetter<LETTER>> entry2 : dawgState2.getTransitions().entrySet()) {
                    if (entry.getValue().isDisjoint(entry2.getValue())) continue;
                    DawgLetter<LETTER> dawgLetter = entry.getValue().intersect(entry2.getValue());
                    DawgState<LETTER, V3> dawgState4 = this.product(entry.getKey(), entry2.getKey());
                    if (hashMap.containsKey(dawgState4)) {
                        hashMap.put(dawgState4, hashMap.get(dawgState4).union(dawgLetter));
                        continue;
                    }
                    hashMap.put(dawgState4, dawgLetter);
                }
            }
            dawgState3 = this.mDawgStateFactory.createIntermediateState(hashMap);
        }
        this.mCache.put(pair, dawgState3);
        return dawgState3;
    }
}

