/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetterFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DawgLetter<LETTER> {
    final DawgLetterFactory<LETTER> mDawgLetterFactory;
    DawgLetter<LETTER> mComplement;
    final Set<LETTER> mLetters;
    final Object mSortId;
    final boolean mIsComplemented;

    public DawgLetter(DawgLetterFactory<LETTER> dawgLetterFactory, Set<LETTER> set, Object object) {
        this.mDawgLetterFactory = dawgLetterFactory;
        this.mLetters = set;
        this.mSortId = object;
        this.mIsComplemented = false;
    }

    public DawgLetter(DawgLetter<LETTER> dawgLetter) {
        assert (!dawgLetter.mIsComplemented);
        this.mDawgLetterFactory = dawgLetter.mDawgLetterFactory;
        this.mLetters = dawgLetter.mLetters;
        this.mSortId = dawgLetter.mSortId;
        this.mIsComplemented = true;
        this.mComplement = dawgLetter;
        dawgLetter.mComplement = this;
    }

    public Object getSortId() {
        return this.mSortId;
    }

    public final DawgLetter<LETTER> difference(DawgLetter<LETTER> dawgLetter) {
        return this.intersect(dawgLetter.complement());
    }

    public DawgLetter<LETTER> complement() {
        if (this.mComplement == null) {
            this.mComplement = new DawgLetter<LETTER>(this);
        }
        return this.mComplement;
    }

    public DawgLetter<LETTER> intersect(DawgLetter<LETTER> dawgLetter) {
        if (!this.mIsComplemented) {
            HashSet<LETTER> hashSet = new HashSet<LETTER>();
            for (LETTER LETTER : this.mLetters) {
                if (!dawgLetter.matches(LETTER)) continue;
                hashSet.add(LETTER);
            }
            return this.mDawgLetterFactory.getSimpleDawgLetter(hashSet, this.mSortId);
        }
        if (!dawgLetter.mIsComplemented) {
            HashSet<LETTER> hashSet = new HashSet<LETTER>();
            for (LETTER LETTER : dawgLetter.mLetters) {
                if (!this.matches(LETTER)) continue;
                hashSet.add(LETTER);
            }
            return this.mDawgLetterFactory.getSimpleDawgLetter(hashSet, this.mSortId);
        }
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        hashSet.addAll(this.mLetters);
        hashSet.addAll(dawgLetter.mLetters);
        return this.mDawgLetterFactory.getSimpleComplementDawgLetter(hashSet, this.mSortId);
    }

    public boolean matches(LETTER LETTER) {
        return this.mLetters.contains(LETTER) ^ this.mIsComplemented;
    }

    public Set<LETTER> getLetters() {
        if (this.mIsComplemented) {
            HashSet<LETTER> hashSet = new HashSet<LETTER>(this.mDawgLetterFactory.getAllConstants(this.mSortId));
            hashSet.removeAll(this.mLetters);
            return hashSet;
        }
        return this.mLetters;
    }

    public DawgLetter<LETTER> restrictToLetter(LETTER LETTER) {
        if (this.matches(LETTER)) {
            return this.mDawgLetterFactory.getSimpleDawgLetter(Collections.singleton(LETTER), this.mSortId);
        }
        return this.mDawgLetterFactory.getEmptyDawgLetter(this.mSortId);
    }

    public String toString() {
        return "DawgLetter: " + (this.mIsComplemented ? "not" : "") + String.valueOf(this.mLetters);
    }

    public DawgLetter<LETTER> union(DawgLetter<LETTER> dawgLetter) {
        return this.complement().intersect(dawgLetter.complement()).complement();
    }

    public boolean isDisjoint(DawgLetter<LETTER> dawgLetter) {
        if (!this.mIsComplemented) {
            for (LETTER LETTER : this.mLetters) {
                if (!dawgLetter.matches(LETTER)) continue;
                return false;
            }
            return true;
        }
        if (!dawgLetter.mIsComplemented) {
            for (LETTER LETTER : dawgLetter.mLetters) {
                if (!this.matches(LETTER)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return !this.mIsComplemented && this.mLetters.size() == 0;
    }

    public boolean isUniversal() {
        return this.mIsComplemented && this.mLetters.size() == 0;
    }

    public Collection<LETTER> getRawLetters() {
        return this.mLetters;
    }

    public boolean isComplemented() {
        return this.mIsComplemented;
    }

    public boolean isSingleton() {
        return !this.mIsComplemented && this.mLetters.size() == 1;
    }
}

