/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;

public class BoundConstraint
extends DPLLAtom {
    final InfinitesimalNumber mBound;
    final InfinitesimalNumber mIBound;
    final LinVar mVar;

    public BoundConstraint(InfinitesimalNumber infinitesimalNumber, LinVar linVar, int n) {
        super(HashUtils.hashJenkins((int)linVar.hashCode(), (Object)infinitesimalNumber), n);
        assert (infinitesimalNumber.mEps <= 0);
        assert (!linVar.mIsInt || infinitesimalNumber.isIntegral());
        this.mBound = infinitesimalNumber;
        this.mIBound = infinitesimalNumber.add(linVar.getEpsilon());
        assert (!this.mBound.equals(this.mIBound));
        this.mVar = linVar;
        assert (!this.mVar.mConstraints.containsKey(infinitesimalNumber));
        this.mVar.mConstraints.put(infinitesimalNumber, this);
    }

    public LinVar getVar() {
        return this.mVar;
    }

    public InfinitesimalNumber getBound() {
        return this.mBound;
    }

    public InfinitesimalNumber getInverseBound() {
        return this.mIBound;
    }

    @Override
    public String toStringNegated() {
        InfinitesimalNumber infinitesimalNumber = this.getInverseBound();
        if (infinitesimalNumber.mEps > 0) {
            return "[" + this.hashCode() + "]" + String.valueOf(this.mVar) + " > " + String.valueOf(infinitesimalNumber.mReal);
        }
        return "[" + this.hashCode() + "]" + String.valueOf(this.mVar) + " >= " + String.valueOf(infinitesimalNumber);
    }

    @Override
    public String toString() {
        if (this.mBound.mEps < 0) {
            return "[" + this.hashCode() + "]" + String.valueOf(this.mVar) + " < " + String.valueOf(this.mBound.mReal);
        }
        return "[" + this.hashCode() + "]" + String.valueOf(this.mVar) + " <= " + String.valueOf(this.mBound);
    }

    boolean impliedByUpperBound(InfinitesimalNumber infinitesimalNumber) {
        return infinitesimalNumber.lesseq(this.mBound);
    }

    boolean impliedByLowerBound(InfinitesimalNumber infinitesimalNumber) {
        return this.getInverseBound().lesseq(infinitesimalNumber);
    }

    @Override
    public Term getSMTFormula(Theory theory) {
        MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
        mutableAffineTerm.add(Rational.ONE, this.mVar);
        mutableAffineTerm.add(this.mBound.negate());
        return mutableAffineTerm.toSMTLibLeq0(theory);
    }

    public boolean equals(Object object) {
        if (object instanceof BoundConstraint) {
            BoundConstraint boundConstraint = (BoundConstraint)object;
            return boundConstraint.mVar == this.mVar && boundConstraint.mBound.equals(this.mBound);
        }
        return false;
    }
}

