/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class CutCreator {
    LinArSolve mSolver;
    Row[] mURows;
    Column[] mAColumns;

    private int compare(LinVar linVar, LinVar linVar2) {
        return linVar.mMatrixpos - linVar2.mMatrixpos;
    }

    public void computeMatrix(LinArSolve linArSolve) {
        final class LinVarBigInt
        implements Comparable<LinVarBigInt> {
            LinVar mRow;
            BigInteger mCoeff;

            public LinVarBigInt(LinVar linVar, BigInteger bigInteger) {
                this.mRow = linVar;
                this.mCoeff = bigInteger;
            }

            void addToMap(Map<LinVar, Collection<LinVarBigInt>> map, LinVar linVar) {
                Collection<LinVarBigInt> collection = map.get(linVar);
                if (collection == null) {
                    collection = new TreeSet<LinVarBigInt>();
                    map.put(linVar, collection);
                }
                collection.add(this);
            }

            @Override
            public int compareTo(LinVarBigInt linVarBigInt) {
                return CutCreator.this.compare(this.mRow, linVarBigInt.mRow);
            }

            public String toString() {
                return this.mCoeff.toString() + "*" + String.valueOf(this.mRow);
            }
        }
        BigInteger[] bigIntegerArray;
        TreeMap<LinVar, Collection<LinVarBigInt>> treeMap = new TreeMap<LinVar, Collection<LinVarBigInt>>();
        for (LinVar linVar : linArSolve.mLinvars) {
            if (linVar.mBasic) continue;
            boolean bl = false;
            if (linVar.getValue().compareTo(linVar.getLowerBound()) <= 0) {
                bl = true;
            }
            if (linVar.isInitiallyBasic()) {
                for (Map.Entry<LinVar, BigInteger> entry : linVar.getLinTerm().entrySet()) {
                    bigIntegerArray = entry.getValue();
                    if (bl) {
                        bigIntegerArray = bigIntegerArray.negate();
                    }
                    new LinVarBigInt(linVar, (BigInteger)bigIntegerArray).addToMap(treeMap, entry.getKey());
                }
                continue;
            }
            new LinVarBigInt(linVar, BigInteger.valueOf(bl ? -1 : 1)).addToMap(treeMap, linVar);
        }
        this.mAColumns = new Column[treeMap.size()];
        this.mURows = new Row[treeMap.size()];
        int n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            LinVar[] linVarArray = new LinVar[collection.size()];
            bigIntegerArray = new BigInteger[collection.size()];
            int n2 = 0;
            for (LinVarBigInt linVarBigInt : collection) {
                linVarArray[n2] = linVarBigInt.mRow;
                bigIntegerArray[n2] = linVarBigInt.mCoeff;
                assert (n2 == 0 || this.compare(linVarArray[n2 - 1], linVarArray[n2]) < 0);
                ++n2;
            }
            this.mAColumns[n] = new Column(linVarArray, bigIntegerArray);
            this.mURows[n] = new Row((LinVar)entry.getKey());
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void mgcdColumn(int var1_1) {
        var2_2 = this.mAColumns[var1_1].mIndices[0];
        var3_3 = var1_1 + 1;
        while (var3_3 < this.mAColumns.length) {
            if (this.compare(this.mAColumns[var3_3].mIndices[0], var2_2) < 0) {
                var2_2 = this.mAColumns[var3_3].mIndices[0];
            }
            ++var3_3;
        }
        var3_3 = (int)this.isTight(var2_2);
        var4_4 = this.isFixed(var2_2);
        var5_5 = this.mAColumns.length;
        ** GOTO lbl73
        {
            --var5_5;
            do {
                if (this.mAColumns[var5_5 - 1].mIndices[0] != var2_2) continue block1;
                if (!CutCreator.$assertionsDisabled && var5_5 <= var1_1) {
                    throw new AssertionError();
                }
                var6_7 = var1_1;
                while (var6_7 < var5_5) {
                    if (!CutCreator.$assertionsDisabled && this.mAColumns[var5_5 - 1].mIndices[0] != var2_2) {
                        throw new AssertionError();
                    }
                    if (this.mAColumns[var6_7].mIndices[0] != var2_2) {
                        var7_8 = this.mAColumns[var6_7];
                        this.mAColumns[var6_7] = this.mAColumns[--var5_5];
                        this.mAColumns[var5_5] = var7_8;
                        var8_13 = this.mURows[var6_7];
                        this.mURows[var6_7] = this.mURows[var5_5];
                        this.mURows[var5_5] = var8_13;
                    }
                    while (this.mAColumns[var5_5 - 1].mIndices[0] != var2_2) {
                        --var5_5;
                    }
                    if (!CutCreator.$assertionsDisabled && this.mAColumns[var1_1].mIndices[0] != var2_2) {
                        throw new AssertionError();
                    }
                    if (!CutCreator.$assertionsDisabled && this.mAColumns[var6_7].mIndices[0] != var2_2) {
                        throw new AssertionError();
                    }
                    if (this.mURows[var1_1].isInt() && (!this.mURows[var6_7].isInt() || this.mAColumns[var1_1].mCoeffs[0].abs().compareTo(this.mAColumns[var6_7].mCoeffs[0].abs()) > 0)) {
                        var7_8 = this.mAColumns[var6_7];
                        this.mAColumns[var6_7] = this.mAColumns[var1_1];
                        this.mAColumns[var1_1] = var7_8;
                        var8_13 = this.mURows[var6_7];
                        this.mURows[var6_7] = this.mURows[var1_1];
                        this.mURows[var1_1] = var8_13;
                    }
                    ++var6_7;
                }
                if (this.mAColumns[var1_1].mCoeffs[0].signum() < 0) {
                    this.mAColumns[var1_1].negate();
                    this.mURows[var1_1].negate();
                }
                var6_6 = this.mAColumns[var1_1].mCoeffs[0];
                if (!this.mURows[var1_1].isInt() && !var6_6.equals(BigInteger.ONE)) {
                    this.mURows[var1_1].divide(var6_6);
                    var7_9 = 0;
                    while (var7_9 < this.mAColumns[var1_1].mCoeffs.length) {
                        var8_13 = this.mAColumns[var1_1].mCoeffs[var7_9].gcd(var6_6);
                        var9_15 = var6_6.divide((BigInteger)var8_13);
                        this.multiplyARow(this.mAColumns[var1_1].mIndices[var7_9], var9_15);
                        this.mAColumns[var1_1].mCoeffs[var7_9] = this.mAColumns[var1_1].mCoeffs[var7_9].divide(var6_6);
                        ++var7_9;
                    }
                    var6_6 = BigInteger.ONE;
                }
                var7_8 = var6_6.shiftRight(1);
                var8_12 = var1_1 + 1;
                while (var8_12 < var5_5) {
                    if (!CutCreator.$assertionsDisabled && this.mAColumns[var8_12].mIndices[0] != var2_2) {
                        throw new AssertionError();
                    }
                    var9_15 = this.mAColumns[var8_12].mCoeffs[0];
                    var9_15 = var9_15.signum() < 0 ? var9_15.subtract((BigInteger)var7_8) : var9_15.add((BigInteger)var7_8);
                    var10_17 = var9_15.divide(var6_6);
                    this.mAColumns[var8_12].addmul(this.mAColumns[var1_1], var10_17.negate());
                    if (!CutCreator.$assertionsDisabled && this.mAColumns[var8_12].mIndices[0] == var2_2 && this.mAColumns[var8_12].mCoeffs[0].abs().compareTo(var7_8.abs()) > 0) {
                        throw new AssertionError();
                    }
                    this.mURows[var1_1].addmul(this.mURows[var8_12], var10_17);
                    ++var8_12;
                }
lbl73:
                // 2 sources

            } while (var5_5 > var1_1 + 1);
        }
        if (this.mAColumns[var1_1].mCoeffs[0].signum() < 0) {
            this.mAColumns[var1_1].negate();
            this.mURows[var1_1].negate();
        }
        if ((var6_6 = this.mAColumns[var1_1].mCoeffs[0]).equals(BigInteger.ONE)) {
            var7_11 = 0;
            while (var7_11 < var1_1) {
                var8_12 = 0;
                while (var8_12 < this.mAColumns[var7_11].mIndices.length && this.compare(this.mAColumns[var7_11].mIndices[var8_12], var2_2) < 0) {
                    ++var8_12;
                }
                if (var8_12 != this.mAColumns[var7_11].mIndices.length && this.mAColumns[var7_11].mIndices[var8_12] == var2_2) {
                    if (!CutCreator.$assertionsDisabled && this.mAColumns[var7_11].mIndices[var8_12] != var2_2) {
                        throw new AssertionError();
                    }
                    if (!this.mURows[var7_11].isInt() && this.mURows[var1_1].isInt()) {
                        var4_4 &= this.mURows[var7_11].mFixed;
                        var3_3 &= (int)(this.mAColumns[var7_11].mCoeffs[var8_12].signum() > 0 ? this.mURows[var7_11].mFixed : this.mURows[var7_11].mTight);
                    } else {
                        if (!CutCreator.$assertionsDisabled && this.mAColumns[var7_11].mIndices[var8_12] != var2_2) {
                            throw new AssertionError();
                        }
                        var9_15 = this.mAColumns[var7_11].mCoeffs[var8_12];
                        this.mAColumns[var7_11].addmul(this.mAColumns[var1_1], var9_15.negate());
                        this.mURows[var1_1].addmul(this.mURows[var7_11], var9_15);
                    }
                }
                ++var7_11;
            }
        } else {
            var7_8 = var6_6.shiftRight(1);
            var8_14 = var6_6.shiftRight(5);
            var9_16 = 0;
            while (var9_16 < var1_1) {
                var10_18 = 0;
                while (var10_18 < this.mAColumns[var9_16].mIndices.length && this.compare(this.mAColumns[var9_16].mIndices[var10_18], var2_2) < 0) {
                    ++var10_18;
                }
                if (var10_18 != this.mAColumns[var9_16].mIndices.length && this.mAColumns[var9_16].mIndices[var10_18] == var2_2) {
                    if (!CutCreator.$assertionsDisabled && this.mAColumns[var9_16].mIndices[var10_18] != var2_2) {
                        throw new AssertionError();
                    }
                    if (!this.mURows[var9_16].isInt() && this.mURows[var1_1].isInt()) {
                        var4_4 &= this.mURows[var9_16].mFixed;
                        var3_3 &= (int)(this.mAColumns[var9_16].mCoeffs[var10_18].signum() > 0 ? this.mURows[var9_16].mFixed : this.mURows[var9_16].mTight);
                    } else {
                        var11_19 = this.mAColumns[var9_16].mCoeffs[var10_18];
                        var12_20 = var11_19.divideAndRemainder(var6_6);
                        var13_21 = var12_20[0];
                        var14_22 = var12_20[1];
                        if (var14_22.signum() != 0) {
                            var15_23 = 0;
                            var4_4 &= this.mURows[var9_16].mFixed;
                            if (var14_22.signum() < 0) {
                                var14_22 = var14_22.add(var6_6);
                                var15_23 = -1;
                            }
                            if (var14_22.compareTo((BigInteger)(var16_24 = this.mURows[var9_16].mFixed != false || var3_3 == 0 || this.mURows[var9_16].mTight == false ? var7_8 : var8_14)) >= 0) {
                                var14_22 = var14_22.subtract(var6_6);
                                ++var15_23;
                            }
                            if (var15_23 != 0) {
                                var13_21 = var13_21.add(BigInteger.valueOf(var15_23));
                            }
                            if (!this.mURows[var9_16].mTight) {
                                var3_3 = 0;
                            } else if (var14_22.signum() > 0) {
                                var3_3 &= this.mURows[var9_16].mFixed;
                            }
                        }
                        if (var13_21.signum() != 0) {
                            this.mAColumns[var9_16].addmul(this.mAColumns[var1_1], var13_21.negate());
                            this.mURows[var1_1].addmul(this.mURows[var9_16], var13_21);
                        }
                    }
                }
                ++var9_16;
            }
        }
        this.mURows[var1_1].mFixed = var4_4;
        this.mURows[var1_1].mTight = var3_3;
        this.mURows[var1_1].computeValue();
        if (!CutCreator.$assertionsDisabled && var1_1 + 1 != this.mAColumns.length && this.mAColumns[var1_1 + 1].mIndices[0] == var2_2) {
            throw new AssertionError();
        }
    }

    private void multiplyARow(LinVar linVar, BigInteger bigInteger) {
        int n = 0;
        while (n < this.mAColumns.length) {
            int n2 = 0;
            while (n2 < this.mAColumns[n].mIndices.length) {
                if (this.mAColumns[n].mIndices[n2] == linVar) {
                    this.mAColumns[n].mCoeffs[n2] = this.mAColumns[n].mCoeffs[n2].multiply(bigInteger);
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean isTight(LinVar linVar) {
        return linVar.getValue().equals(linVar.getLowerBound()) || linVar.getValue().equals(linVar.getUpperBound());
    }

    private boolean isFixed(LinVar linVar) {
        return linVar.getLowerBound().equals(linVar.getUpperBound());
    }

    /*
     * Unable to fully structure code
     */
    private boolean[] computeBadness() {
        var1_1 = new boolean[this.mAColumns.length];
        var2_2 = 0;
        while (var2_2 < this.mAColumns.length) {
            block5: {
                block4: {
                    if (!this.mURows[var2_2].isBad()) break block4;
                    var1_1[var2_2] = true;
                    break block5;
                }
                var3_3 = var2_2 + 1;
                var4_4 = 1;
                ** GOTO lbl17
                {
                    ++var3_3;
                    do {
                        if (var3_3 < this.mAColumns.length && this.compare(this.mAColumns[var3_3].mIndices[0], this.mAColumns[var2_2].mIndices[var4_4]) < 0) continue block1;
                        if (var3_3 < this.mAColumns.length && this.mAColumns[var3_3].mIndices[0] == this.mAColumns[var2_2].mIndices[var4_4]) {
                            var1_1[var3_3] = true;
                        }
                        ++var4_4;
lbl17:
                        // 2 sources

                    } while (var4_4 < this.mAColumns[var2_2].mIndices.length);
                }
            }
            ++var2_2;
        }
        return var1_1;
    }

    public void generateCut(int n, boolean bl) {
        assert (this.mURows[n].mIndices[0].mIsInt);
        Literal literal = this.mURows[n].createConstraint();
        if (this.mSolver.getLogger().isDebugEnabled()) {
            this.mSolver.getLogger().debug((bl ? "cut on " : "branch on ") + String.valueOf(literal));
        }
        this.mSolver.mSuggestions.add(literal);
        if (bl) {
            ++this.mSolver.mNumCuts;
        } else {
            ++this.mSolver.mNumBranches;
        }
    }

    public CutCreator(LinArSolve linArSolve) {
        this.mSolver = linArSolve;
        this.computeMatrix(linArSolve);
    }

    public void generateCuts() {
        int n = 0;
        while (n < this.mAColumns.length) {
            this.mgcdColumn(n);
            ++n;
        }
        if (this.mSolver.getLogger().isDebugEnabled()) {
            this.mSolver.getLogger().debug("Cuts From Proofs");
            this.mSolver.getLogger().debug("cols");
            n = 0;
            while (n < this.mAColumns.length) {
                if (this.mAColumns[n].mCoeffs.length != 1 || !this.mAColumns[n].mCoeffs[0].equals(BigInteger.ONE)) {
                    this.mSolver.getLogger().debug("[" + n + "] " + String.valueOf(this.mAColumns[n]));
                }
                ++n;
            }
            this.mSolver.getLogger().debug("rows");
            n = 0;
            while (n < this.mURows.length) {
                this.mSolver.getLogger().debug("[" + n + "] " + String.valueOf(this.mURows[n]));
                ++n;
            }
        }
        boolean[] blArray = this.computeBadness();
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        while (n5 < this.mURows.length) {
            if (!(blArray[n5] || !this.mURows[n5].mTight && n2 >= 0 && this.mURows[n2].mTight || this.mURows[n5].mCoeffs.length > n3 && this.mURows[n2].mTight == this.mURows[n5].mTight)) {
                int n6 = 0;
                BigInteger[] bigIntegerArray = this.mURows[n5].mCoeffs;
                int n7 = this.mURows[n5].mCoeffs.length;
                int n8 = 0;
                while (n8 < n7) {
                    BigInteger bigInteger = bigIntegerArray[n8];
                    n6 = Math.max(n6, bigInteger.bitLength());
                    ++n8;
                }
                if (n6 < n4 || this.mURows[n5].mCoeffs.length != n3 || this.mURows[n2].mTight != this.mURows[n5].mTight) {
                    n2 = n5;
                    n4 = n6;
                    n3 = this.mURows[n5].mCoeffs.length;
                }
            }
            ++n5;
        }
        this.generateCut(n2, this.mURows[n2].mTight);
    }

    public class Column {
        LinVar[] mIndices;
        BigInteger[] mCoeffs;

        public Column(LinVar[] linVarArray, BigInteger[] bigIntegerArray) {
            this.mIndices = linVarArray;
            this.mCoeffs = bigIntegerArray;
        }

        public void negate() {
            int n = 0;
            while (n < this.mCoeffs.length) {
                this.mCoeffs[n] = this.mCoeffs[n].negate();
                ++n;
            }
        }

        public void addmul(Column column, BigInteger bigInteger) {
            LinVar[] linVarArray = new LinVar[this.mIndices.length + column.mIndices.length];
            BigInteger[] bigIntegerArray = new BigInteger[linVarArray.length];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < this.mIndices.length && n2 < column.mIndices.length) {
                if (this.mIndices[n] == column.mIndices[n2]) {
                    BigInteger bigInteger2 = this.mCoeffs[n].add(column.mCoeffs[n2].multiply(bigInteger));
                    if (bigInteger2.signum() != 0) {
                        linVarArray[n3] = this.mIndices[n];
                        bigIntegerArray[n3] = bigInteger2;
                        ++n3;
                    }
                    ++n;
                    ++n2;
                    continue;
                }
                if (CutCreator.this.compare(this.mIndices[n], column.mIndices[n2]) < 0) {
                    linVarArray[n3] = this.mIndices[n];
                    bigIntegerArray[n3] = this.mCoeffs[n];
                    ++n3;
                    ++n;
                    continue;
                }
                linVarArray[n3] = column.mIndices[n2];
                bigIntegerArray[n3] = column.mCoeffs[n2].multiply(bigInteger);
                ++n3;
                ++n2;
            }
            while (n < this.mIndices.length) {
                linVarArray[n3] = this.mIndices[n];
                bigIntegerArray[n3] = this.mCoeffs[n];
                ++n3;
                ++n;
            }
            while (n2 < column.mIndices.length) {
                linVarArray[n3] = column.mIndices[n2];
                bigIntegerArray[n3] = column.mCoeffs[n2].multiply(bigInteger);
                ++n3;
                ++n2;
            }
            assert (n3 > 0);
            if (n3 < bigIntegerArray.length) {
                this.mIndices = new LinVar[n3];
                this.mCoeffs = new BigInteger[n3];
                System.arraycopy(linVarArray, 0, this.mIndices, 0, n3);
                System.arraycopy(bigIntegerArray, 0, this.mCoeffs, 0, n3);
            } else {
                this.mIndices = linVarArray;
                this.mCoeffs = bigIntegerArray;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            int n = 0;
            while (n < this.mIndices.length) {
                stringBuilder.append(string).append(this.mIndices[n].mMatrixpos).append(": ").append(this.mCoeffs[n]);
                string = ", ";
                ++n;
            }
            return stringBuilder.toString();
        }
    }

    public class Row {
        LinVar[] mIndices;
        BigInteger[] mCoeffs;
        boolean mIsInt;
        boolean mTight;
        boolean mFixed;
        Rational mCurval;
        Rational mEpsilons;

        public Row(LinVar linVar) {
            assert (!linVar.isInitiallyBasic());
            this.mIsInt = linVar.mIsInt;
            if (this.mIsInt) {
                this.mIndices = new LinVar[]{linVar};
                this.mCoeffs = new BigInteger[]{BigInteger.ONE};
            } else {
                this.mIndices = new LinVar[0];
                this.mCoeffs = new BigInteger[0];
            }
        }

        public boolean isInt() {
            return this.mIsInt;
        }

        public void negate() {
            int n = 0;
            while (n < this.mCoeffs.length) {
                this.mCoeffs[n] = this.mCoeffs[n].negate();
                ++n;
            }
        }

        public void addmul(Row row, BigInteger bigInteger) {
            if (!this.isInt()) {
                return;
            }
            assert (row.isInt());
            LinVar[] linVarArray = new LinVar[this.mIndices.length + row.mIndices.length];
            BigInteger[] bigIntegerArray = new BigInteger[linVarArray.length];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < this.mIndices.length && n2 < row.mIndices.length) {
                if (this.mIndices[n] == row.mIndices[n2]) {
                    BigInteger bigInteger2 = this.mCoeffs[n].add(row.mCoeffs[n2].multiply(bigInteger));
                    if (bigInteger2.signum() != 0) {
                        linVarArray[n3] = this.mIndices[n];
                        bigIntegerArray[n3] = bigInteger2;
                        ++n3;
                    }
                    ++n;
                    ++n2;
                    continue;
                }
                if (CutCreator.this.compare(this.mIndices[n], row.mIndices[n2]) < 0) {
                    linVarArray[n3] = this.mIndices[n];
                    bigIntegerArray[n3] = this.mCoeffs[n];
                    ++n3;
                    ++n;
                    continue;
                }
                linVarArray[n3] = row.mIndices[n2];
                bigIntegerArray[n3] = row.mCoeffs[n2].multiply(bigInteger);
                ++n3;
                ++n2;
            }
            while (n < this.mIndices.length) {
                linVarArray[n3] = this.mIndices[n];
                bigIntegerArray[n3] = this.mCoeffs[n];
                ++n3;
                ++n;
            }
            while (n2 < row.mIndices.length) {
                linVarArray[n3] = row.mIndices[n2];
                bigIntegerArray[n3] = row.mCoeffs[n2].multiply(bigInteger);
                ++n3;
                ++n2;
            }
            assert (n3 > 0);
            if (n3 < bigIntegerArray.length) {
                this.mIndices = new LinVar[n3];
                this.mCoeffs = new BigInteger[n3];
                System.arraycopy(linVarArray, 0, this.mIndices, 0, n3);
                System.arraycopy(bigIntegerArray, 0, this.mCoeffs, 0, n3);
            } else {
                this.mIndices = linVarArray;
                this.mCoeffs = bigIntegerArray;
            }
        }

        public String getVar() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            int n = 0;
            while (n < this.mIndices.length) {
                stringBuilder.append(string).append(this.mCoeffs[n]).append(" * (").append(this.mIndices[n]).append(')');
                string = " + ";
                ++n;
            }
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getVar());
            stringBuilder.append(" == ").append(this.mCurval);
            stringBuilder.append(" + ").append(this.mEpsilons).append(" eps");
            return stringBuilder.toString();
        }

        public Literal createConstraint() {
            assert (this.mIsInt);
            MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
            int n = 0;
            while (n < this.mIndices.length) {
                mutableAffineTerm.add(Rational.valueOf((BigInteger)this.mCoeffs[n], (BigInteger)BigInteger.ONE), this.mIndices[n]);
                ++n;
            }
            mutableAffineTerm.add(new InfinitesimalNumber(this.mCurval, this.mEpsilons.signum()).floor().negate());
            return CutCreator.this.mSolver.generateConstraint(mutableAffineTerm, false);
        }

        public void computeValue() {
            this.mCurval = Rational.ZERO;
            this.mEpsilons = Rational.ZERO;
            int n = 0;
            while (n < this.mIndices.length) {
                LinVar linVar = this.mIndices[n];
                Rational rational = Rational.valueOf((BigInteger)this.mCoeffs[n], (BigInteger)BigInteger.ONE);
                ExactInfinitesimalNumber exactInfinitesimalNumber = linVar.getValue();
                this.mCurval = this.mCurval.addmul(rational, exactInfinitesimalNumber.getRealValue());
                this.mEpsilons = this.mEpsilons.addmul(rational, exactInfinitesimalNumber.getEpsilon());
                ++n;
            }
        }

        public boolean isBad() {
            if (!this.mIsInt) {
                return true;
            }
            return this.mCurval.isIntegral() && this.mEpsilons.signum() == 0;
        }

        public void divide(BigInteger bigInteger) {
            assert (!this.mIsInt);
        }
    }
}

