/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Collections;

public class BoogieASTUtil {
    public static String getLHSId(LeftHandSide leftHandSide) {
        LeftHandSide leftHandSide2 = leftHandSide;
        while (leftHandSide2 instanceof ArrayLHS || leftHandSide2 instanceof StructLHS) {
            if (leftHandSide2 instanceof ArrayLHS) {
                leftHandSide2 = ((ArrayLHS)leftHandSide2).getArray();
                continue;
            }
            if (!(leftHandSide2 instanceof StructLHS)) continue;
            leftHandSide2 = ((StructLHS)leftHandSide2).getStruct();
        }
        return ((VariableLHS)leftHandSide2).getIdentifier();
    }

    public static String getLeftMostId(Expression expression) {
        assert (expression instanceof IdentifierExpression || expression instanceof StructAccessExpression || expression instanceof ArrayAccessExpression);
        Expression expression2 = expression;
        while (expression2 instanceof ArrayAccessExpression || expression2 instanceof StructAccessExpression) {
            if (expression2 instanceof ArrayAccessExpression) {
                expression2 = ((ArrayAccessExpression)expression2).getArray();
                continue;
            }
            if (!(expression2 instanceof StructAccessExpression)) continue;
            expression2 = ((StructAccessExpression)expression2).getStruct();
        }
        return ((IdentifierExpression)expression2).getIdentifier();
    }

    public static String[] getLHSList(LeftHandSide leftHandSide) {
        LeftHandSide leftHandSide2 = leftHandSide;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (leftHandSide2 instanceof ArrayLHS || leftHandSide2 instanceof StructLHS) {
            if (leftHandSide2 instanceof ArrayLHS) {
                leftHandSide2 = ((ArrayLHS)leftHandSide2).getArray();
                continue;
            }
            if (!(leftHandSide2 instanceof StructLHS)) continue;
            StructLHS structLHS = (StructLHS)leftHandSide2;
            arrayList.add(structLHS.getField());
            leftHandSide2 = structLHS.getStruct();
        }
        arrayList.add(((VariableLHS)leftHandSide2).getIdentifier());
        Collections.reverse(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static LeftHandSide getLHSforExpression(Expression expression) {
        assert (expression instanceof IdentifierExpression || expression instanceof StructAccessExpression || expression instanceof ArrayAccessExpression);
        ILocation iLocation = expression.getLocation();
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            return new VariableLHS(iLocation, identifierExpression.getType(), identifierExpression.getIdentifier(), null);
        }
        if (expression instanceof StructAccessExpression) {
            StructAccessExpression structAccessExpression = (StructAccessExpression)expression;
            LeftHandSide leftHandSide = BoogieASTUtil.getLHSforExpression(structAccessExpression.getStruct());
            return new StructLHS(iLocation, structAccessExpression.getType(), leftHandSide, structAccessExpression.getField());
        }
        if (expression instanceof ArrayAccessExpression) {
            ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)expression;
            LeftHandSide leftHandSide = BoogieASTUtil.getLHSforExpression(arrayAccessExpression.getArray());
            return ExpressionFactory.constructNestedArrayLHS((ILocation)iLocation, (LeftHandSide)leftHandSide, (Expression[])arrayAccessExpression.getIndices());
        }
        throw new IllegalArgumentException("Wrong implementation! This method is not intended to handle this argument!");
    }
}

