/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness;

import de.uni_freiburg.informatik.ultimate.cdt.translation.LineOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.CorrectnessWitnessExtractor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedFunctionContract;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedGhostUpdate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedGhostVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedLocationInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedLoopInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.ExtractedWitnessInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.IExtractedCorrectnessWitness;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.IExtractedWitnessDeclaration;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.FunctionContract;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.GhostUpdate;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.GhostVariable;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Location;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LocationInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LoopInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WitnessEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class YamlCorrectnessWitnessExtractor
extends CorrectnessWitnessExtractor {
    private Witness mWitness;

    public YamlCorrectnessWitnessExtractor(IUltimateServiceProvider iUltimateServiceProvider) {
        super(iUltimateServiceProvider);
    }

    public void setWitness(Witness witness) {
        this.mWitness = witness;
    }

    @Override
    public boolean isReady() {
        return this.mWitness != null && this.mTranslationUnit != null;
    }

    @Override
    protected IExtractedCorrectnessWitness extractWitness() {
        LocationFactory locationFactory = new LocationFactory(null, new LineOffsetComputer(this.mTranslationUnit.getRawSignature()));
        HashMap<IASTNode, ExtractedLoopInvariant> hashMap = new HashMap<IASTNode, ExtractedLoopInvariant>();
        HashMap<IASTNode, ExtractedLocationInvariant> hashMap2 = new HashMap<IASTNode, ExtractedLocationInvariant>();
        YamlExtractedCorrectnessWitness yamlExtractedCorrectnessWitness = new YamlExtractedCorrectnessWitness();
        for (WitnessEntry witnessEntry : this.mWitness.getEntries()) {
            Consumer<IASTNode> consumer;
            Location location;
            Object object;
            if (witnessEntry instanceof GhostVariable) {
                object = (GhostVariable)witnessEntry;
                yamlExtractedCorrectnessWitness.addGlobalDeclaration(new ExtractedGhostVariable(object.getVariable(), object.getInitialValue(), object.getType(), (IASTNode)this.mTranslationUnit));
                this.mStats.success();
                continue;
            }
            if (witnessEntry instanceof LocationInvariant) {
                location = ((LocationInvariant)witnessEntry).getLocation();
                consumer = iASTNode -> YamlCorrectnessWitnessExtractor.addLocationInvariant((LocationInvariant)witnessEntry, iASTNode, hashMap2);
            } else if (witnessEntry instanceof LoopInvariant) {
                location = ((LoopInvariant)witnessEntry).getLocation();
                consumer = iASTNode -> YamlCorrectnessWitnessExtractor.addLoopInvariant((LoopInvariant)witnessEntry, iASTNode, hashMap);
            } else if (witnessEntry instanceof FunctionContract) {
                location = ((FunctionContract)witnessEntry).getLocation();
                consumer = iASTNode -> YamlCorrectnessWitnessExtractor.addFunctionContract((FunctionContract)witnessEntry, iASTNode, yamlExtractedCorrectnessWitness);
            } else if (witnessEntry instanceof GhostUpdate) {
                object = (GhostUpdate)witnessEntry;
                location = object.getLocation();
                consumer = arg_0 -> YamlCorrectnessWitnessExtractor.lambda$3(yamlExtractedCorrectnessWitness, (GhostUpdate)object, arg_0);
            } else {
                throw new UnsupportedOperationException("Unknown entry type " + witnessEntry.getClass().getSimpleName());
            }
            object = new LineColumnMatchingVisitor(location, locationFactory);
            ((LineColumnMatchingVisitor)((Object)object)).run(this.mTranslationUnit);
            IASTNode iASTNode2 = ((LineColumnMatchingVisitor)((Object)object)).getMatchedNode();
            if (iASTNode2 == null) {
                if (this.mIgnoreUnmatchedEntries) {
                    this.mStats.fail();
                    continue;
                }
                throw new UnsupportedOperationException("The following witness entry could not be matched: " + String.valueOf(witnessEntry));
            }
            consumer.accept(iASTNode2);
            this.mStats.success();
        }
        hashMap.forEach((arg_0, arg_1) -> YamlExtractedCorrectnessWitness.access$0(yamlExtractedCorrectnessWitness, arg_0, arg_1));
        hashMap2.forEach((arg_0, arg_1) -> YamlExtractedCorrectnessWitness.access$0(yamlExtractedCorrectnessWitness, arg_0, arg_1));
        return yamlExtractedCorrectnessWitness;
    }

    private static void addFunctionContract(FunctionContract functionContract, IASTNode iASTNode, YamlExtractedCorrectnessWitness yamlExtractedCorrectnessWitness) {
        if (!(iASTNode instanceof IASTSimpleDeclaration) && !(iASTNode instanceof IASTFunctionDefinition)) {
            throw new UnsupportedOperationException("Function contract is only allowed at declaration or definition of a function (found " + iASTNode.getClass().getSimpleName() + ")");
        }
        yamlExtractedCorrectnessWitness.addFunctionContract(iASTNode, new ExtractedFunctionContract(functionContract.getRequires(), functionContract.getEnsures(), iASTNode));
    }

    private static void addLocationInvariant(LocationInvariant locationInvariant, IASTNode iASTNode, Map<IASTNode, ExtractedLocationInvariant> map) {
        String string = locationInvariant.getInvariant();
        ExtractedLocationInvariant extractedLocationInvariant = map.get(iASTNode);
        if (extractedLocationInvariant != null) {
            string = YamlCorrectnessWitnessExtractor.conjunctInvariants(extractedLocationInvariant.getInvariant(), string);
        }
        map.put(iASTNode, new ExtractedLocationInvariant(string, iASTNode, true));
    }

    private static void addLoopInvariant(LoopInvariant loopInvariant, IASTNode iASTNode, Map<IASTNode, ExtractedLoopInvariant> map) {
        if (!(iASTNode instanceof IASTWhileStatement || iASTNode instanceof IASTForStatement || iASTNode instanceof IASTDoStatement)) {
            throw new UnsupportedOperationException("Loop invariant is only allowed at loop (found " + iASTNode.getClass().getSimpleName() + ")");
        }
        String string = loopInvariant.getInvariant();
        ExtractedLoopInvariant extractedLoopInvariant = map.get(iASTNode);
        if (extractedLoopInvariant != null) {
            string = YamlCorrectnessWitnessExtractor.conjunctInvariants(extractedLoopInvariant.getInvariant(), string);
        }
        map.put(iASTNode, new ExtractedLoopInvariant(string, iASTNode));
    }

    private static String conjunctInvariants(String string, String string2) {
        return "(" + string + ") && (" + string2 + ")";
    }

    private static /* synthetic */ void lambda$3(YamlExtractedCorrectnessWitness yamlExtractedCorrectnessWitness, GhostUpdate ghostUpdate, IASTNode iASTNode) {
        yamlExtractedCorrectnessWitness.addGhostUpdate(iASTNode, new ExtractedGhostUpdate(ghostUpdate.getVariable(), ghostUpdate.getValue(), iASTNode));
    }

    private static final class LineColumnMatchingVisitor
    extends ASTGenericVisitor {
        private IASTNode mMatchedNode;
        private final Location mLocation;
        private final LocationFactory mLocationFactory;

        public LineColumnMatchingVisitor(Location location, LocationFactory locationFactory) {
            super(true);
            this.mLocation = location;
            this.mLocationFactory = locationFactory;
        }

        public void run(IASTTranslationUnit iASTTranslationUnit) {
            iASTTranslationUnit.accept((ASTVisitor)this);
        }

        public IASTNode getMatchedNode() {
            return this.mMatchedNode;
        }

        protected int genericVisit(IASTNode iASTNode) {
            if (iASTNode instanceof IASTTranslationUnit) {
                return 3;
            }
            CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation(iASTNode);
            if (cACSLLocation == null) {
                return 3;
            }
            if (this.mLocation.getLine().intValue() == cACSLLocation.getStartLine() && (this.mLocation.getColumn() == null || this.mLocation.getColumn().intValue() == cACSLLocation.getStartColumn())) {
                this.mMatchedNode = iASTNode;
                return 2;
            }
            return 3;
        }
    }

    private static final class YamlExtractedCorrectnessWitness
    implements IExtractedCorrectnessWitness {
        private final HashRelation<IASTNode, ExtractedWitnessInvariant> mInvariants = new HashRelation();
        private final HashRelation<IASTNode, ExtractedFunctionContract> mFunctionContracts = new HashRelation();
        private final Map<IASTNode, List<ExtractedGhostUpdate>> mGhostUpdates = new HashMap<IASTNode, List<ExtractedGhostUpdate>>();
        private final Set<IExtractedWitnessDeclaration> mGlobalDeclarations = new HashSet<IExtractedWitnessDeclaration>();

        private YamlExtractedCorrectnessWitness() {
        }

        private void addInvariant(IASTNode iASTNode, ExtractedWitnessInvariant extractedWitnessInvariant) {
            this.mInvariants.addPair((Object)iASTNode, (Object)extractedWitnessInvariant);
        }

        private void addFunctionContract(IASTNode iASTNode, ExtractedFunctionContract extractedFunctionContract) {
            this.mFunctionContracts.addPair((Object)iASTNode, (Object)extractedFunctionContract);
        }

        private void addGhostUpdate(IASTNode iASTNode2, ExtractedGhostUpdate extractedGhostUpdate) {
            this.mGhostUpdates.computeIfAbsent(iASTNode2, iASTNode -> new ArrayList()).add(extractedGhostUpdate);
        }

        private void addGlobalDeclaration(IExtractedWitnessDeclaration iExtractedWitnessDeclaration) {
            this.mGlobalDeclarations.add(iExtractedWitnessDeclaration);
        }

        @Override
        public Set<ExtractedWitnessInvariant> getInvariants(IASTNode iASTNode) {
            return this.mInvariants.getImage((Object)iASTNode);
        }

        @Override
        public Set<ExtractedFunctionContract> getFunctionContracts(IASTNode iASTNode) {
            return this.mFunctionContracts.getImage((Object)iASTNode);
        }

        @Override
        public List<ExtractedGhostUpdate> getGhostUpdates(IASTNode iASTNode) {
            return this.mGhostUpdates.getOrDefault(iASTNode, List.of());
        }

        @Override
        public Set<IExtractedWitnessDeclaration> getGlobalDeclarations() {
            return Collections.unmodifiableSet(this.mGlobalDeclarations);
        }

        @Override
        public List<String> printAllEntries() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry object : this.mInvariants.getSetOfPairs()) {
                arrayList.add(((ExtractedWitnessInvariant)object.getValue()).toString());
            }
            for (Map.Entry entry : this.mFunctionContracts.getSetOfPairs()) {
                arrayList.add(((ExtractedFunctionContract)entry.getValue()).toString());
            }
            for (IExtractedWitnessDeclaration iExtractedWitnessDeclaration : this.mGlobalDeclarations) {
                arrayList.add(iExtractedWitnessDeclaration.toString());
            }
            for (List list : this.mGhostUpdates.values()) {
                for (ExtractedGhostUpdate extractedGhostUpdate : list) {
                    arrayList.add(extractedGhostUpdate.toString());
                }
            }
            return arrayList;
        }

        static /* synthetic */ void access$0(YamlExtractedCorrectnessWitness yamlExtractedCorrectnessWitness, IASTNode iASTNode, ExtractedWitnessInvariant extractedWitnessInvariant) {
            yamlExtractedCorrectnessWitness.addInvariant(iASTNode, extractedWitnessInvariant);
        }
    }
}

