/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.SetOfStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaSuccessorStateProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BarelyCoveredLevelRankingsGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingConstraint;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingConstraintDrdCheck;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.StateWithRankInfo;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementNcsbStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public final class BuchiComplementNCSBNwa<LETTER, STATE>
implements INwaSuccessorStateProvider<LETTER, STATE> {
    private static final int MAGIC_RANK = 7777;
    private static final int BARELY_COVERED_MAX_RANK = 3;
    private static final Integer RANK_FINAL = 2;
    private static final Integer RANK_NONFINAL = 3;
    private static final boolean EARLY_SINK_HEURISTIC = false;
    private final AutomataLibraryServices mServices;
    private final SetOfStates<STATE> mSetOfStates;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final IBuchiComplementNcsbStateFactory<STATE> mStateFactory;
    private final StateWithRankInfo<STATE> mEmptyStackStateWri;
    private final Map<LevelRankingState<LETTER, STATE>, STATE> mDet2res = new HashMap<LevelRankingState<LETTER, STATE>, STATE>();
    private final Map<STATE, LevelRankingState<LETTER, STATE>> mRes2det = new HashMap<STATE, LevelRankingState<LETTER, STATE>>();
    private final BarelyCoveredLevelRankingsGenerator<LETTER, STATE> mBclrg;
    private final boolean mLazySOptimization;
    private final EnumSet<LevelRankingConstraint.VoluntaryRankDecrease> mVoluntaryRankDecrease;

    public BuchiComplementNCSBNwa(AutomataLibraryServices automataLibraryServices, IBuchiComplementNcsbStateFactory<STATE> iBuchiComplementNcsbStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, boolean bl) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mStateFactory = iBuchiComplementNcsbStateFactory;
        this.mLazySOptimization = bl;
        this.mSetOfStates = new SetOfStates(this.mStateFactory.createEmptyStackState());
        this.mEmptyStackStateWri = new StateWithRankInfo<STATE>(this.mSetOfStates.getEmptyStackState());
        this.mVoluntaryRankDecrease = bl ? EnumSet.of(LevelRankingConstraint.VoluntaryRankDecrease.ALLOWS_O_ESCAPE_AND_ALL_EVEN_PREDECESSORS_ARE_ACCEPTING, LevelRankingConstraint.VoluntaryRankDecrease.PREDECESSOR_HAS_EMPTY_O) : EnumSet.of(LevelRankingConstraint.VoluntaryRankDecrease.ALL_EVEN_PREDECESSORS_ARE_ACCEPTING);
        this.mBclrg = new BarelyCoveredLevelRankingsGenerator<LETTER, STATE>(this.mServices, this.mOperand, 3, false, true, false, this.mVoluntaryRankDecrease);
        this.constructInitialState();
    }

    private void constructInitialState() {
        LevelRankingState<LETTER, STATE> levelRankingState = new LevelRankingState<LETTER, STATE>(this.mOperand);
        for (Object STATE : this.mOperand.getInitialStates()) {
            if (this.mOperand.isFinal(STATE)) {
                levelRankingState.addRank(this.mEmptyStackStateWri, STATE, RANK_FINAL, true);
                continue;
            }
            levelRankingState.addRank(this.mEmptyStackStateWri, STATE, RANK_NONFINAL, false);
        }
        this.getOrAdd(true, levelRankingState);
    }

    private STATE getOrAdd(boolean bl, LevelRankingState<LETTER, STATE> levelRankingState) {
        STATE STATE = this.mDet2res.get(levelRankingState);
        if (STATE == null) {
            STATE = this.mStateFactory.buchiComplementNcsb(levelRankingState);
            this.mDet2res.put(levelRankingState, STATE);
            this.mRes2det.put(STATE, levelRankingState);
            boolean bl2 = !levelRankingState.isNonAcceptingSink() && levelRankingState.isOempty();
            this.mSetOfStates.addState(bl, bl2, STATE);
        } else assert (!bl);
        return STATE;
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        return this.mSetOfStates.getInitialStates();
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mSetOfStates.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mSetOfStates.isAccepting(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mSetOfStates.getEmptyStackState();
    }

    private LevelRankingConstraintDrdCheck<LETTER, STATE> computeSuccLevelRankingConstraint_Internal(STATE STATE, LETTER LETTER) {
        LevelRankingState<LETTER, STATE> levelRankingState = this.mRes2det.get(STATE);
        if (levelRankingState.isNonAcceptingSink()) {
            return new LevelRankingConstraintDrdCheck();
        }
        LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck = new LevelRankingConstraintDrdCheck<LETTER, STATE>(this.mOperand, levelRankingState.isOempty(), 7777, true, false, levelRankingState);
        for (StateWithRankInfo<STATE> stateWithRankInfo : levelRankingState.getDownStates()) {
            for (StateWithRankInfo<STATE> stateWithRankInfo2 : levelRankingState.getUpStates(stateWithRankInfo)) {
                boolean bl = false;
                for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.mOperand.internalSuccessors(stateWithRankInfo2.getState(), LETTER)) {
                    bl = true;
                    levelRankingConstraintDrdCheck.addConstraint(stateWithRankInfo, outgoingInternalTransition.getSucc(), new DoubleDecker<StateWithRankInfo<STATE>>(stateWithRankInfo, stateWithRankInfo2));
                }
                if (this.mLazySOptimization && !stateWithRankInfo2.isInO() || !this.transitionWouldAnnihilateEvenRank(stateWithRankInfo2, bl)) continue;
                return new LevelRankingConstraintDrdCheck();
            }
        }
        return levelRankingConstraintDrdCheck;
    }

    private boolean transitionWouldAnnihilateEvenRank(StateWithRankInfo<STATE> stateWithRankInfo, boolean bl) {
        return !bl && !this.mOperand.isFinal(stateWithRankInfo.getState()) && LevelRankingState.isEven(stateWithRankInfo.getRank());
    }

    private LevelRankingConstraintDrdCheck<LETTER, STATE> computeSuccLevelRankingConstraint_Call(STATE STATE, LETTER LETTER) {
        LevelRankingState<LETTER, STATE> levelRankingState = this.mRes2det.get(STATE);
        if (levelRankingState.isNonAcceptingSink()) {
            return new LevelRankingConstraintDrdCheck();
        }
        LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck = new LevelRankingConstraintDrdCheck<LETTER, STATE>(this.mOperand, levelRankingState.isOempty(), 7777, true, false, levelRankingState);
        for (StateWithRankInfo<STATE> stateWithRankInfo : levelRankingState.getDownStates()) {
            for (StateWithRankInfo<STATE> stateWithRankInfo2 : levelRankingState.getUpStates(stateWithRankInfo)) {
                boolean bl = false;
                for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : this.mOperand.callSuccessors(stateWithRankInfo2.getState(), LETTER)) {
                    bl = true;
                    levelRankingConstraintDrdCheck.addConstraint(stateWithRankInfo2, outgoingCallTransition.getSucc(), new DoubleDecker<StateWithRankInfo<STATE>>(stateWithRankInfo, stateWithRankInfo2));
                }
                if (this.mLazySOptimization && !stateWithRankInfo2.isInO() || !this.transitionWouldAnnihilateEvenRank(stateWithRankInfo2, bl)) continue;
                return new LevelRankingConstraintDrdCheck();
            }
        }
        return levelRankingConstraintDrdCheck;
    }

    private LevelRankingConstraintDrdCheck<LETTER, STATE> computeSuccLevelRankingConstraint_Return(STATE STATE, STATE STATE2, LETTER LETTER) {
        LevelRankingState<LETTER, STATE> levelRankingState = this.mRes2det.get(STATE);
        if (levelRankingState.isNonAcceptingSink()) {
            return new LevelRankingConstraintDrdCheck();
        }
        LevelRankingState<LETTER, STATE> levelRankingState2 = this.mRes2det.get(STATE2);
        LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck = new LevelRankingConstraintDrdCheck<LETTER, STATE>(this.mOperand, levelRankingState.isOempty(), 7777, true, false, levelRankingState);
        for (StateWithRankInfo<STATE> stateWithRankInfo : levelRankingState2.getDownStates()) {
            for (StateWithRankInfo<STATE> stateWithRankInfo2 : levelRankingState2.getUpStates(stateWithRankInfo)) {
                boolean bl;
                if (!levelRankingState.getDownStates().contains(stateWithRankInfo2) || !(bl = this.computeSuccLevelRankingConstraintReturnHelper(LETTER, levelRankingState, levelRankingConstraintDrdCheck, stateWithRankInfo, stateWithRankInfo2))) continue;
                return new LevelRankingConstraintDrdCheck();
            }
        }
        return levelRankingConstraintDrdCheck;
    }

    private boolean computeSuccLevelRankingConstraintReturnHelper(LETTER LETTER, LevelRankingState<LETTER, STATE> levelRankingState, LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck, StateWithRankInfo<STATE> stateWithRankInfo, StateWithRankInfo<STATE> stateWithRankInfo2) {
        for (StateWithRankInfo<STATE> stateWithRankInfo3 : levelRankingState.getUpStates(stateWithRankInfo2)) {
            boolean bl = false;
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessors(stateWithRankInfo3.getState(), stateWithRankInfo2.getState(), LETTER)) {
                bl = true;
                levelRankingConstraintDrdCheck.addConstraint(stateWithRankInfo, outgoingReturnTransition.getSucc(), new DoubleDecker<StateWithRankInfo<STATE>>(stateWithRankInfo2, stateWithRankInfo3));
            }
            if (!this.transitionWouldAnnihilateEvenRank(stateWithRankInfo3, bl)) continue;
            return true;
        }
        return false;
    }

    private Collection<STATE> computeStates(LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck) {
        if (levelRankingConstraintDrdCheck.isTargetOfConfluenceForcedDelayedRankDecrease(this.mVoluntaryRankDecrease)) {
            return Collections.emptyList();
        }
        Collection<LevelRankingState<LETTER, STATE>> collection = this.mBclrg.generateLevelRankings(levelRankingConstraintDrdCheck, false);
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (LevelRankingState<LETTER, STATE> levelRankingState : collection) {
            STATE STATE = this.getOrAdd(false, levelRankingState);
            arrayList.add(STATE);
        }
        return arrayList;
    }

    @Override
    public int size() {
        return this.mSetOfStates.getStates().size();
    }

    @Override
    public String sizeInformation() {
        return "size Information not available";
    }

    @Override
    public Collection<STATE> internalSuccessors(STATE STATE, LETTER LETTER) {
        LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck = this.computeSuccLevelRankingConstraint_Internal(STATE, LETTER);
        Collection<STATE> collection = this.computeStates(levelRankingConstraintDrdCheck);
        return collection;
    }

    @Override
    public Collection<STATE> callSuccessors(STATE STATE, LETTER LETTER) {
        LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck = this.computeSuccLevelRankingConstraint_Call(STATE, LETTER);
        Collection<STATE> collection = this.computeStates(levelRankingConstraintDrdCheck);
        return collection;
    }

    @Override
    public Collection<STATE> returnSuccessorsGivenHier(STATE STATE, STATE STATE2, LETTER LETTER) {
        LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck = this.computeSuccLevelRankingConstraint_Return(STATE, STATE2, LETTER);
        Collection<STATE> collection = this.computeStates(levelRankingConstraintDrdCheck);
        return collection;
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        throw new UnsupportedOperationException();
    }
}

